/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.remoteimpl.crypt;

import com.sap.engine.services.security.exceptions.BaseRemoteException;
import com.sap.engine.services.security.remote.crypt.RemoteCryptography;
import com.sap.engine.services.security.restriction.Restrictions;
import com.sap.exception.IBaseException;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.security.Provider;
import java.security.Security;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;

public class RemoteCryptographyImpl
extends PortableRemoteObject
implements RemoteCryptography {
    static /* synthetic */ Class class$java$security$Provider;

    public Vector getInstalledProviders() throws RemoteException {
        try {
            Provider[] providers = Security.getProviders();
            Vector<String> result = new Vector<String>();
            int i = 0;
            while (i < providers.length) {
                result.add(providers[i].getName());
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            throw new BaseRemoteException("security_6000", e);
        }
    }

    public String getProviderInfo(String provider) throws RemoteException {
        try {
            return Security.getProvider(provider).getInfo();
        }
        catch (Exception e) {
            Throwable error = null;
            try {
                Class<?> providerClass = Class.forName(provider);
                return ((Provider)providerClass.newInstance()).getInfo();
            }
            catch (Exception exc) {
                error = exc;
            }
            catch (NoClassDefFoundError err) {
                error = err;
            }
            if (e instanceof NullPointerException) {
                return " Cannot add the provider due to " + error;
            }
            throw new BaseRemoteException("security_6001", new Object[]{provider}, e);
        }
    }

    public void setInstalledProviders(Vector providers) throws RemoteException {
        try {
            Restrictions.checkPermission((int)1, (int)0);
            int i = 0;
            while (i < providers.size()) {
                String name = (String)providers.elementAt(i);
                Provider provider = null;
                try {
                    provider = Security.getProvider(name);
                    Security.removeProvider(name);
                }
                catch (Exception e) {
                    provider = null;
                }
                if (provider == null) {
                    Class<?> providerClass = Class.forName(name);
                    int modifiers = providerClass.getModifiers();
                    if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers) || Modifier.isPrivate(modifiers)) {
                        throw new BaseRemoteException("security_6002");
                    }
                    if ((class$java$security$Provider == null ? RemoteCryptographyImpl.class$("java.security.Provider") : class$java$security$Provider).isAssignableFrom(providerClass)) {
                        provider = (Provider)providerClass.newInstance();
                    }
                }
                Security.insertProviderAt(provider, i + 1);
                ++i;
            }
            Provider[] list = Security.getProviders();
            int i2 = list.length - 1;
            while (i2 >= providers.size()) {
                Security.removeProvider(list[i2].getName());
                --i2;
            }
        }
        catch (RemoteException e) {
            if (e instanceof IBaseException) {
                throw e;
            }
            throw new BaseRemoteException("security_6003", e);
        }
        catch (Exception e) {
            throw new BaseRemoteException("security_6004", e);
        }
        catch (NoClassDefFoundError cdnfe) {
            throw new BaseRemoteException("security_6005", cdnfe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

