/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.remoteimpl;

import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.interfaces.security.AuthenticationContext;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.services.security.remote.RemoteAuthentication;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.RemoteUserStore;
import com.sap.engine.services.security.remote.authentication.RemoteAppConfigurationEntry;
import com.sap.engine.services.security.server.AuthenticationContextImpl;
import java.rmi.RemoteException;
import java.util.Map;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.login.AppConfigurationEntry;

public class RemoteAuthenticationImpl
extends PortableRemoteObject
implements RemoteAuthentication {
    private AuthenticationContext authentication;
    private RemoteSecurity remote;

    public RemoteAuthenticationImpl(RemoteSecurity remote, AuthenticationContext authentication) throws RemoteException {
        this.authentication = authentication;
        this.remote = remote;
    }

    public RemoteUserStore getAuthenticationUserStore() throws RemoteException {
        String name = this.authentication.getAuthenticationUserStore().getConfiguration().getName();
        return this.remote.getRemoteUserStoreFactory().getUserStore(name);
    }

    public RemoteAppConfigurationEntry[] getLoginModules() throws RemoteException {
        AppConfigurationEntry[] entries = this.authentication.getLoginModules();
        RemoteAppConfigurationEntry[] result = new RemoteAppConfigurationEntry[entries.length];
        int i = 0;
        while (i < result.length) {
            String name = entries[i].getLoginModuleName();
            Map<String, ?> options = entries[i].getOptions();
            LoginModuleConfiguration[] modules = this.getAuthenticationUserStore().getConfiguration().getLoginModules();
            int j = 0;
            while (j < modules.length) {
                if (modules[j].getLoginModuleClassName().equals(name) && modules[j].getOptions().equals(options)) {
                    name = modules[j].getName();
                    break;
                }
                ++j;
            }
            result[i] = new RemoteAppConfigurationEntry(entries[i], name);
            ++i;
        }
        return result;
    }

    public RemoteAppConfigurationEntry[] getLoginModules(String userStore) throws RemoteException {
        AppConfigurationEntry[] entries = ((AuthenticationContextImpl)this.authentication).getLoginModules(userStore);
        RemoteAppConfigurationEntry[] result = new RemoteAppConfigurationEntry[entries.length];
        int i = 0;
        while (i < result.length) {
            String name = entries[i].getLoginModuleName();
            Map<String, ?> options = entries[i].getOptions();
            LoginModuleConfiguration[] modules = this.getAuthenticationUserStore().getConfiguration().getLoginModules();
            int j = 0;
            while (j < modules.length) {
                if (modules[j].getLoginModuleClassName().equals(name) && modules[j].getOptions().equals(options)) {
                    name = modules[j].getName();
                    break;
                }
                ++j;
            }
            result[i] = new RemoteAppConfigurationEntry(entries[i], name);
            ++i;
        }
        return result;
    }

    public String getProperty(String key) throws RemoteException {
        return this.authentication.getProperty(key);
    }

    public String getTemplate() throws RemoteException {
        return this.authentication.getTemplate();
    }

    public void setLoginModules(RemoteAppConfigurationEntry[] modules) throws RemoteException {
        AppConfigurationEntry[] entries = new AppConfigurationEntry[modules.length];
        int i = 0;
        while (i < entries.length) {
            entries[i] = modules[i].getAppConfigurationEntry();
            ++i;
        }
        this.authentication.setLoginModules(entries);
    }

    public void setLoginModules(String userStore, RemoteAppConfigurationEntry[] modules) throws RemoteException {
        AppConfigurationEntry[] entries = new AppConfigurationEntry[modules.length];
        int i = 0;
        while (i < entries.length) {
            entries[i] = modules[i].getAppConfigurationEntry();
            ++i;
        }
        ((AuthenticationContextImpl)this.authentication).setLoginModules(userStore, entries);
    }

    public void setProperty(String key, String value) throws RemoteException {
        this.authentication.setProperty(key, value);
    }

    public void setTemplate(String template) throws RemoteException {
        this.authentication.setLoginModules(template);
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }
}

