/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.remote.authentication;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;

public class RemoteAppConfigurationEntry
implements Serializable {
    static final long serialVersionUID = 9150184898356412446L;
    private int flag;
    private String className = null;
    private String loginModule = null;
    private Properties map = null;

    public RemoteAppConfigurationEntry() {
    }

    public RemoteAppConfigurationEntry(AppConfigurationEntry entry, String loginModuleName) {
        this.className = entry.getLoginModuleName();
        this.loginModule = loginModuleName;
        this.map = new Properties();
        ((Hashtable)this.map).putAll(entry.getOptions());
        if (entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL) {
            this.flag = 0;
        } else if (entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
            this.flag = 1;
        } else if (entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
            this.flag = 2;
        } else if (entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
            this.flag = 3;
        }
    }

    public AppConfigurationEntry getAppConfigurationEntry() {
        return new AppConfigurationEntry(this.getLoginModuleName(), this.getControlFlag(), this.getOptions());
    }

    public String getClassName() {
        return this.className;
    }

    public String getLoginModuleName() {
        return this.loginModule;
    }

    public AppConfigurationEntry.LoginModuleControlFlag getControlFlag() {
        switch (this.flag) {
            case 0: {
                return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            }
            case 1: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            }
            case 2: {
                return AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            }
            case 3: {
                return AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
            }
        }
        return AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
    }

    public Map getOptions() {
        return this.map;
    }
}

