/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login.monitor;

import com.sap.engine.services.security.login.monitor.PolicyConfigurationMonitor;
import java.util.Enumeration;
import java.util.Hashtable;

public class MonitorTable {
    private static Hashtable table = new Hashtable(20);
    private static PolicyConfigurationMonitor aggregate = new PolicyConfigurationMonitor("AggregatedData");

    public static PolicyConfigurationMonitor getMonitor(String policyConfiguration) {
        String policy = MonitorTable.convertToJMXString(policyConfiguration);
        PolicyConfigurationMonitor monitor = (PolicyConfigurationMonitor)table.get(policy);
        if (monitor == null) {
            Hashtable hashtable = table;
            synchronized (hashtable) {
                monitor = (PolicyConfigurationMonitor)table.get(policy);
                if (monitor == null) {
                    monitor = new PolicyConfigurationMonitor(policy);
                    table.put(policy, monitor);
                }
            }
        }
        return monitor;
    }

    public static void removePolicyConfigurationMonitor(String policy) {
        table.remove(policy);
    }

    public static PolicyConfigurationMonitor getAggregatedMonitor() {
        return aggregate;
    }

    public static String[] getAuthenticationStacks() {
        Enumeration keys = null;
        String[] stacks = null;
        Hashtable hashtable = table;
        synchronized (hashtable) {
            stacks = new String[table.size()];
            keys = table.keys();
        }
        int next = 0;
        while (keys.hasMoreElements()) {
            stacks[next++] = (String)keys.nextElement();
        }
        return stacks;
    }

    private static String convertToJMXString(String s) {
        StringBuffer buffer = new StringBuffer();
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != ',' && chars[i] != '=' && chars[i] != ':' && chars[i] != '\"' && chars[i] != '*' && chars[i] != '?') {
                buffer.append(chars[i]);
            }
            ++i;
        }
        return buffer.toString();
    }
}

