/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.login.CreateSessionAction;
import com.sap.engine.services.security.login.SecurityContext;
import com.sap.engine.services.security.login.SecuritySession;
import com.sap.engine.services.security.login.SecuritySessionPool;
import com.sap.engine.services.security.login.Signer;
import java.security.AccessController;
import java.security.Principal;

public class TicketGenerator {
    private static final int OFFSET_SIZE = 0;
    private static final int OFFSET_CLUSTER_ID = 4;
    private static final int OFFSET_SESSION_TICKET_SIZE = 8;
    private static final int OFFSET_SESSION_TICKET = 12;
    private static final int OFFSET_NUMBER = 0;
    private static final int OFFSET_CREATION = 8;
    private static final int OFFSET_EXPIRATION = 16;
    private static final int OFFSET_TICKET_VALID_BEFORE = 24;
    private static final int OFFSET_PRINCIPAL = 32;
    private static final byte[] EMPTY_TICKET = new byte[]{0, 0, 0, 0};
    private static byte[] ANONYMOUS_TICKET = null;
    private static final int ANONYMOUS_OFFSET_SIZE = 0;
    private static final int ANONYMOUS_OFFSET_EMPTY_TICKET = 4;
    private static final int ANONYMOUS_OFFSET_PRINCIPAL = 8;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] generateTicket(byte[] ticket, SecuritySession session, SecuritySessionPool pool) {
        if (!SystemProperties.getBoolean("server")) {
            if (ticket != null) return ticket;
            return TicketGenerator.getEmptyTicket();
        }
        byte[] oldticket = ticket;
        Principal principal = null;
        if (session == SecurityContext.ANONYMOUS_SESSION) {
            if (pool == null) return TicketGenerator.getAnonymousTicket();
            pool.unregisterSession(oldticket, session);
            return TicketGenerator.getAnonymousTicket();
        }
        if (session != null) {
            principal = session.getPrincipal();
        }
        if (!TicketGenerator.isTicketExpired(ticket) && (principal == null || principal.getName().equals(TicketGenerator.getPrincipalName(ticket)))) return ticket;
        if (principal == null) return TicketGenerator.getEmptyTicket();
        long expiration = session.getExpirationPeriod();
        String name = principal.getName();
        ticket = new byte[32 + name.length() * 2];
        Convert.writeLongToByteArr(ticket, 0, session.getSessionNumber());
        Convert.writeLongToByteArr(ticket, 8, session.getCreationTime());
        Convert.writeLongToByteArr(ticket, 16, expiration);
        if (expiration <= 0L) {
            Convert.writeLongToByteArr(ticket, 24, 0L);
        } else {
            Convert.writeLongToByteArr(ticket, 24, System.currentTimeMillis() + expiration);
        }
        Convert.writeUStringToByteArr(ticket, 32, name);
        byte[] signedticket = null;
        byte[] signature = Signer.sign(ticket);
        signedticket = new byte[12 + ticket.length + signature.length];
        Convert.writeIntToByteArr(signedticket, 0, signedticket.length);
        Convert.writeIntToByteArr(signedticket, 4, SecurityServerFrame.currentParticipant);
        Convert.writeIntToByteArr(signedticket, 8, ticket.length);
        System.arraycopy(ticket, 0, signedticket, 12, ticket.length);
        System.arraycopy(signature, 0, signedticket, 12 + ticket.length, signature.length);
        if (pool == null || TicketGenerator.arraysEqual(oldticket, signedticket)) return signedticket;
        pool.rekeySession(session, oldticket, signedticket);
        return signedticket;
    }

    public static SecuritySession getSecuritySession(byte[] ticket, SecuritySessionPool pool) {
        SecuritySession session = null;
        if (!SystemProperties.getBoolean("server") || !TicketGenerator.isTicketExpired(ticket)) {
            if (pool != null && (session = pool.getSession(ticket)) != null && !session.isValid()) {
                pool.unregisterSession(ticket, session);
                session = null;
            }
            if (ticket == null || ticket.length <= TicketGenerator.getEmptyTicket().length) {
                return SecurityContext.ANONYMOUS_SESSION;
            }
            if (!SystemProperties.getBoolean("server") && TicketGenerator.isTicketAnonymous(ticket)) {
                SecurityContext.setAnonymousPrincipal(TicketGenerator.getAnonymousPrincipalFromTicket(ticket));
                return SecurityContext.ANONYMOUS_SESSION;
            }
            if (session == null && TicketGenerator.isTicketTrusted(ticket)) {
                session = (SecuritySession)AccessController.doPrivileged(new CreateSessionAction(ticket, "ticket", pool));
            }
        }
        if (session == null) {
            session = SecurityContext.ANONYMOUS_SESSION;
        }
        return session;
    }

    public static boolean isTicketAnonymous(byte[] ticket) {
        int i = 0;
        while (i < EMPTY_TICKET.length) {
            if (ticket[4 + i] != EMPTY_TICKET[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static String getAnonymousPrincipalFromTicket(byte[] ticket) {
        int nameSize = (ticket.length - 8) / 2;
        return Convert.byteArrToUString(ticket, 8, nameSize);
    }

    public static final byte[] getEmptyTicket() {
        return EMPTY_TICKET;
    }

    public static byte[] getAnonymousTicket() {
        return ANONYMOUS_TICKET;
    }

    protected static void setAnonymousPrincipal(String anonymousPrincipal) {
        int size = 8 + 2 * anonymousPrincipal.length();
        byte[] newanon = new byte[size];
        Convert.writeIntToByteArr(newanon, 0, size);
        System.arraycopy(EMPTY_TICKET, 0, newanon, 4, EMPTY_TICKET.length);
        Convert.writeUStringToByteArr(newanon, 8, anonymousPrincipal);
        ANONYMOUS_TICKET = newanon;
    }

    public static String getPrincipalName(byte[] ticket) {
        int session_size = Convert.byteArrToInt(ticket, 8);
        return Convert.byteArrToUString(ticket, 44, (session_size - 32) / 2);
    }

    public static int getClusterId(byte[] ticket) {
        return Convert.byteArrToInt(ticket, 4);
    }

    public static long getCreationTime(byte[] ticket) {
        return Convert.byteArrToLong(ticket, 20);
    }

    public static long getSessionNumber(byte[] ticket) {
        if (ticket == null) {
            return -1L;
        }
        return Convert.byteArrToLong(ticket, 12);
    }

    public static byte[] getTicket(byte[] from, int offset) {
        int size = Convert.byteArrToInt(from, offset + 0);
        if (size > EMPTY_TICKET.length) {
            byte[] ticket = new byte[size];
            System.arraycopy(from, offset, ticket, 0, ticket.length);
            return ticket;
        }
        return EMPTY_TICKET;
    }

    public static boolean isTicketExpired(byte[] ticket) {
        if (ticket == null || ticket.length <= 36) {
            return true;
        }
        long expires = Convert.byteArrToLong(ticket, 36);
        return expires <= 0L ? false : expires < System.currentTimeMillis();
    }

    public static boolean isTicketTrusted(byte[] ticket) {
        try {
            if (!Signer.keystoreStarted) {
                return true;
            }
            int clusterId = Convert.byteArrToInt(ticket, 4);
            if (clusterId <= 0) {
                return false;
            }
            int session_size = Convert.byteArrToInt(ticket, 8);
            byte[] sessionticket = new byte[session_size];
            System.arraycopy(ticket, 12, sessionticket, 0, session_size);
            int signature_size = ticket.length - session_size - 12;
            byte[] signature = new byte[signature_size];
            System.arraycopy(ticket, 12 + sessionticket.length, signature, 0, signature_size);
            return Signer.verify(clusterId, sessionticket, signature);
        }
        catch (SecurityException gse) {
            return false;
        }
    }

    private static final boolean arraysEqual(byte[] array1, byte[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int i = 0;
        while (i < array1.length) {
            if (array1[i] != array2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

