/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.util.ConcurrentHashMapLongObject;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import iaik.asn1.structures.AlgorithmID;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Vector;

public class Signer {
    private static final String ALGORITHM = "DSA";
    private static final int KEY_SIZE = 512;
    private static final byte[] EMPTY_SIGNATURE = new byte[0];
    private static PrivateKey serverPK = null;
    private static ConcurrentHashMapLongObject map = new ConcurrentHashMapLongObject();
    private static long currentId = -1L;
    private static KeyStore keystore = null;
    private static SecureRandom random = null;
    private static Vector signatures = null;
    protected static boolean initialized = false;
    protected static boolean keystoreStarted = false;
    static /* synthetic */ Class class$com$sap$engine$services$security$login$Signer;

    public static void keystoreStarted() {
        keystoreStarted = true;
    }

    public static void keystoreStopped() {
        keystoreStarted = false;
        initialized = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] sign(byte[] ticket) {
        byte[] byArray;
        Signature signature = null;
        try {
            try {
                if (!keystoreStarted) {
                    byte[] byArray2 = EMPTY_SIGNATURE;
                    Object var4_5 = null;
                    if (signature == null) return byArray2;
                    signatures.add(signature);
                    return byArray2;
                }
                Signer.initializeKey();
                signature = Signer.getSignature();
                signature.initSign(serverPK, random);
                signature.update(ticket);
                byArray = signature.sign();
            }
            catch (GeneralSecurityException ex) {
                throw new BaseSecurityException("security_1012", ex);
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (signature == null) throw throwable;
            signatures.add(signature);
            throw throwable;
        }
        Object var4_6 = null;
        if (signature == null) return byArray;
        signatures.add(signature);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean verify(long clusterId, byte[] rawdata, byte[] signed) {
        boolean bl;
        Signature signature;
        block8: {
            boolean bl2;
            block7: {
                signature = null;
                try {
                    try {
                        boolean verify;
                        if (!keystoreStarted) {
                            boolean bl3 = true;
                            Object var9_8 = null;
                            if (signature == null) return bl3;
                            signatures.add(signature);
                            return bl3;
                        }
                        if (clusterId <= 0L) {
                            bl2 = false;
                            break block7;
                        }
                        Signer.initializeKey();
                        signature = Signer.getSignature();
                        PublicKey publicKey = (PublicKey)map.get(clusterId);
                        if (publicKey == null) {
                            publicKey = Signer.getPublicKeyFromKeyStore(clusterId);
                        }
                        signature.initVerify(publicKey);
                        signature.update(rawdata);
                        bl = verify = signature.verify(signed);
                        break block8;
                    }
                    catch (GeneralSecurityException ex) {
                        throw new BaseSecurityException("security_1013", ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (signature == null) throw throwable;
                    signatures.add(signature);
                    throw throwable;
                }
            }
            Object var9_9 = null;
            if (signature == null) return bl2;
            signatures.add(signature);
            return bl2;
        }
        Object var9_10 = null;
        if (signature == null) return bl;
        signatures.add(signature);
        return bl;
    }

    private static void initializeKey() {
        if (!initialized && SystemProperties.getBoolean("server")) {
            Class clazz = class$com$sap$engine$services$security$login$Signer == null ? (class$com$sap$engine$services$security$login$Signer = Signer.class$("com.sap.engine.services.security.login.Signer")) : class$com$sap$engine$services$security$login$Signer;
            synchronized (clazz) {
                if (!initialized) {
                    try {
                        KeyPair pair;
                        block9: {
                            currentId = SecurityServerFrame.currentParticipant;
                            pair = Signer.generateKeyPair();
                            serverPK = pair.getPrivate();
                            map.put(currentId, pair.getPublic());
                            keystore = KeyStore.getInstance("EBSDKS");
                            keystore.load(null, null);
                            try {
                                keystore.deleteEntry("Server" + currentId);
                            }
                            catch (KeyStoreException kse) {
                                if (!SecurityResourceAccessor.location.beWarning()) break block9;
                                SecurityResourceAccessor.location.traceThrowableT(400, kse.getLocalizedMessage(), (Throwable)kse);
                            }
                        }
                        keystore.setKeyEntry("Server" + currentId, pair.getPublic(), null, new Certificate[0]);
                        keystoreStarted = true;
                        initialized = true;
                    }
                    catch (Exception e) {
                        keystoreStarted = false;
                    }
                }
            }
        }
    }

    private static Signature getSignature() throws GeneralSecurityException {
        Signature result = null;
        if (signatures.size() > 0) {
            try {
                result = (Signature)signatures.remove(0);
            }
            catch (Exception e) {
                result = null;
            }
        }
        return result != null ? result : AlgorithmID.dsa.getSignatureInstance();
    }

    private static KeyPair generateKeyPair() throws GeneralSecurityException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance(ALGORITHM);
        generator.initialize(512);
        return generator.genKeyPair();
    }

    private static PublicKey getPublicKeyFromKeyStore(long clusterId) throws GeneralSecurityException {
        return (PublicKey)keystore.getKey("Server" + clusterId, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        random = new SecureRandom();
        signatures = new Vector();
    }
}

