/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.security.AuthenticationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SessionListener;
import com.sap.engine.interfaces.security.auth.SecuritySessionExtention;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseIllegalStateException;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import com.sap.engine.services.security.login.ContextAuthorizationExtension;
import com.sap.engine.services.security.login.FastLoginContext;
import com.sap.engine.services.security.login.SecuritySessionPool;
import com.sap.engine.services.security.login.SessionFinalizer;
import com.sap.engine.services.security.login.monitor.MonitorTable;
import com.sap.engine.services.security.server.AuthenticationContextImpl;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.lang.ref.WeakReference;
import java.security.Principal;
import java.util.Date;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;

public class SecuritySession
implements SecuritySessionExtention {
    static final long serialVersionUID = 9150184898356412448L;
    private static final String MON_LOGOUT_REQUEST = "AppServer:Security:LogoutSession";
    private static final String MON_COMPONENT_LOGOUT = "AppServer:Security:LogoutSession:SecuritySession:logout";
    private static long index = 0L;
    private boolean isExpirationPeriodDetermined = false;
    private boolean isValid = true;
    private long sessionNumber = -1L;
    private long lastAccessed = -1L;
    private long expirationPeriod = 0L;
    private long creationTime = -1L;
    private byte[] ticket = null;
    private Principal principal = null;
    private String authentication = null;
    private boolean expired = false;
    private transient Subject subject = null;
    private transient Vector listeners = null;
    protected transient ContextAuthorizationExtension authorizationExtension = null;

    SecuritySession(Principal principal, Subject subject, String authentication) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.sessionNumber = index++;
        }
        this.lastAccessed = this.creationTime = System.currentTimeMillis();
        this.subject = subject;
        this.principal = principal;
        this.authentication = authentication;
        this.monitorNewSession();
    }

    SecuritySession(long sessionNumber, long creationTime, Principal principal, Subject subject, String authentication) {
        this.sessionNumber = sessionNumber;
        this.creationTime = creationTime;
        this.lastAccessed = System.currentTimeMillis();
        this.subject = subject;
        this.principal = principal;
        this.authentication = authentication;
        this.monitorNewSession();
    }

    public boolean equals(Object alien) {
        if (alien == null) {
            return false;
        }
        try {
            SecuritySession session = (SecuritySession)alien;
            if (this.sessionNumber != session.sessionNumber) {
                return false;
            }
            if (this.creationTime != session.creationTime) {
                return false;
            }
            return this.principal.getName().equals(session.principal.getName());
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public long getSessionNumber() {
        return this.sessionNumber;
    }

    public long getExpirationPeriod() {
        block3: {
            if (!this.isExpirationPeriodDetermined) {
                try {
                    this.expirationPeriod = FastLoginContext.sessionExpirationPeriod;
                    this.isExpirationPeriodDetermined = true;
                }
                catch (Throwable t) {
                    if (!SecurityResourceAccessor.location.beWarning()) break block3;
                    SecurityResourceAccessor.location.traceThrowableT(400, t.getLocalizedMessage(), t);
                }
            }
        }
        return this.expirationPeriod;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public byte[] getTicket() {
        return this.ticket;
    }

    public String getAuthenticationConfiguration() {
        return this.authentication;
    }

    public ContextAuthorizationExtension getAuthorizationExtension() {
        if (this.authorizationExtension == null) {
            this.authorizationExtension = new ContextAuthorizationExtension();
        }
        return this.authorizationExtension;
    }

    public void logout(String authStack, CallbackHandler handler) throws LoginException {
        IMonitor monitor = null;
        try {
            monitor = TaskMonitor.getRequestMonitor(null, (String)MON_LOGOUT_REQUEST);
            monitor.startComponent(MON_COMPONENT_LOGOUT);
            if (!SystemProperties.getBoolean("server")) {
                throw new BaseIllegalStateException("security_1025");
            }
            SecurityContext securityContext = SecurityServerFrame.getSecurityContext();
            securityContext = securityContext.getPolicyConfigurationContext(authStack);
            AuthenticationContext authenticationContext = securityContext.getAuthenticationContext();
            FastLoginContext loginContext = (FastLoginContext)authenticationContext.getLoginContext(this.subject, handler);
            loginContext.logoutSession(this);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            monitor.endComponent(MON_COMPONENT_LOGOUT);
            monitor.endRequest(MON_LOGOUT_REQUEST);
            throw throwable;
        }
        monitor.endComponent(MON_COMPONENT_LOGOUT);
        monitor.endRequest(MON_LOGOUT_REQUEST);
    }

    public void expire() {
        Object[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            block5: {
                if (listeners[i] instanceof SessionListener) {
                    try {
                        ((SessionListener)listeners[i]).onSessionLocallyRemoved();
                    }
                    catch (Exception e) {
                        if (!SecurityResourceAccessor.location.beWarning()) break block5;
                        SecurityResourceAccessor.location.traceThrowableT(400, e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            ++i;
        }
        this.isValid = false;
        this.expired = true;
        SecuritySessionPool pool = AuthenticationContextImpl.getSessionPool();
        if (pool != null) {
            pool.unregisterSession(this.getSubject(), this);
            pool.unregisterSession(this.getTicket(), this);
        }
        this.monitorTimeoutSession();
    }

    boolean isValid() {
        if (this.isValid && this.getExpirationPeriod() >= 0L && this.creationTime + this.getExpirationPeriod() <= System.currentTimeMillis()) {
            this.expire();
        }
        return this.isValid;
    }

    void setValid(boolean valid) {
        this.isValid = valid;
        if (!valid) {
            this.monitorInvalidSession();
        }
    }

    protected Object[] getListeners() {
        Vector listeners = this.getListenersVector();
        Object[] result = new Object[listeners.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = ((WeakReference)listeners.elementAt(i)).get();
            ++i;
        }
        return result;
    }

    protected final Vector getListenersVector() {
        if (this.listeners == null) {
            SecuritySession securitySession = this;
            synchronized (securitySession) {
                if (this.listeners == null) {
                    this.listeners = new Vector();
                }
            }
        }
        return this.listeners;
    }

    public void registerListener(SessionListener listener) {
        this.getListenersVector().add(new WeakReference<SessionListener>(listener));
    }

    public void unregisterListener(SessionListener listener) {
        Vector listeners;
        Vector vector = listeners = this.getListenersVector();
        synchronized (vector) {
            int i = 0;
            while (i < listeners.size()) {
                if (listener == ((WeakReference)listeners.elementAt(i)).get()) {
                    listeners.remove(i);
                }
                ++i;
            }
        }
    }

    public void setExpirationPeriod(long expirationPeriod) {
        if (this.getExpirationPeriod() < 0L || expirationPeriod >= 0L && expirationPeriod <= this.getExpirationPeriod()) {
            this.expirationPeriod = expirationPeriod;
            this.isExpirationPeriodDetermined = true;
            if (expirationPeriod >= 0L && this.creationTime + expirationPeriod <= System.currentTimeMillis()) {
                this.expire();
            }
            return;
        }
        if (SecurityServerFrame.threadContext.getThreadContext() == null) {
            this.expirationPeriod = expirationPeriod;
            this.isExpirationPeriodDetermined = true;
            if (expirationPeriod >= 0L && this.creationTime + expirationPeriod <= System.currentTimeMillis()) {
                this.expire();
            }
        } else {
            throw new BaseSecurityException("security_1024");
        }
    }

    void setPrincipalAndSubject(Principal principal, Subject subject) {
        this.principal = principal;
        this.subject = subject;
    }

    public void setAccessed() {
        this.lastAccessed = System.currentTimeMillis();
    }

    protected void setTicket(byte[] ticket) {
        this.ticket = ticket;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("session (");
        result.append(this.sessionNumber);
        result.append(") for ");
        result.append(this.principal);
        result.append(" created at ");
        result.append(new Date(this.creationTime).toString());
        return result.toString();
    }

    public void finalize() throws Throwable {
        this.monitorLogoffSession();
        if (this.listeners != null && this.listeners.size() > 0) {
            SecurityServerFrame.threadContext.startThread(new SessionFinalizer(this.listeners), true);
        }
        super.finalize();
    }

    private void monitorNewSession() {
        if (this.authentication != null) {
            ++MonitorTable.getMonitor((String)this.authentication).successLogonCount;
            ++MonitorTable.getMonitor((String)this.authentication).totalSessionCount;
            ++MonitorTable.getAggregatedMonitor().successLogonCount;
            ++MonitorTable.getAggregatedMonitor().totalSessionCount;
        }
    }

    private void monitorLogoffSession() {
        if (this.authentication != null) {
            ++MonitorTable.getMonitor((String)this.authentication).logoffSessionCount;
            ++MonitorTable.getAggregatedMonitor().logoffSessionCount;
            if (this.isValid) {
                --MonitorTable.getMonitor((String)this.authentication).successLogonCount;
                --MonitorTable.getAggregatedMonitor().successLogonCount;
                return;
            }
            if (this.expired) {
                --MonitorTable.getMonitor((String)this.authentication).tiemoutSessionCount;
                --MonitorTable.getAggregatedMonitor().tiemoutSessionCount;
            } else {
                --MonitorTable.getMonitor((String)this.authentication).invalidSessionCount;
                --MonitorTable.getAggregatedMonitor().invalidSessionCount;
            }
        }
    }

    private void monitorInvalidSession() {
        if (this.authentication != null) {
            ++MonitorTable.getMonitor((String)this.authentication).invalidSessionCount;
            --MonitorTable.getMonitor((String)this.authentication).successLogonCount;
            ++MonitorTable.getAggregatedMonitor().invalidSessionCount;
            --MonitorTable.getAggregatedMonitor().successLogonCount;
        }
    }

    private void monitorTimeoutSession() {
        if (this.authentication != null) {
            ++MonitorTable.getMonitor((String)this.authentication).tiemoutSessionCount;
            --MonitorTable.getMonitor((String)this.authentication).successLogonCount;
            ++MonitorTable.getAggregatedMonitor().tiemoutSessionCount;
            --MonitorTable.getAggregatedMonitor().successLogonCount;
        }
    }
}

