/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.lib.util.ConcurrentSet;
import com.sap.engine.services.security.login.SecuritySession;
import com.sap.engine.services.security.server.AuthenticationContextImpl;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.security.auth.SubjectDomainCombiner;

public class RunAsWeakReference
extends WeakReference {
    private ConcurrentSet runAsHashSet = null;
    private SecuritySession session = null;
    private int hashCode;

    public RunAsWeakReference(SubjectDomainCombiner referent, ReferenceQueue runAsSessionQueue, ConcurrentSet runAsHashSet) {
        super(referent, runAsSessionQueue);
        this.runAsHashSet = runAsHashSet;
        this.session = AuthenticationContextImpl.getSessionPool().add(referent.getSubject(), "run_as");
        this.hashCode = referent.hashCode();
        this.runAsHashSet.add(this);
    }

    public void logoutSession() {
        AuthenticationContextImpl.getSessionPool().removeSessions(this.session);
    }

    public boolean equals(Object object) {
        if (object instanceof RunAsWeakReference) {
            if (object == this) {
                return true;
            }
            return this.get() == ((RunAsWeakReference)object).get();
        }
        return this.get() == object;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public SecuritySession getSession() {
        return this.session;
    }
}

