/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.userstore.context.UserContext;
import com.sap.engine.interfaces.security.userstore.context.UserInfo;
import com.sap.engine.lib.security.LoginExceptionDetails;
import com.sap.engine.lib.security.ReusableLoginContext;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.exceptions.BaseLoginException;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import com.sap.engine.services.security.login.LoginContextFactory;
import com.sap.engine.services.security.login.ModulesProcessAction;
import com.sap.engine.services.security.login.SecurityContext;
import com.sap.engine.services.security.login.SecuritySession;
import com.sap.engine.services.security.login.SecuritySessionPool;
import com.sap.engine.services.security.login.SubjectWrapper;
import com.sap.engine.services.security.login.monitor.MonitorTable;
import com.sap.engine.services.security.login.monitor.PolicyConfigurationMonitor;
import com.sap.engine.services.security.server.AuthenticationContextImpl;
import com.sap.engine.services.security.server.SecurityContextImpl;
import com.sap.engine.services.security.server.jaas.LoginModuleHelperImpl;
import com.sap.util.monitor.jarm.IMonitor;
import com.sap.util.monitor.jarm.TaskMonitor;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class FastLoginContext
extends ReusableLoginContext {
    public static final String MON_AUTHENTICATION_REQUEST = "AppServer:Security:Authentication";
    public static final String MON_LOGOUT_REQUEST = "AppServer:Security:Logout";
    public static final String USER_INFO = "com.sap.engine.security.UserInfo";
    protected static final byte OPERATION_LOGIN = 0;
    protected static final byte OPERATION_ABORT = 1;
    protected static final byte OPERATION_COMMIT = 2;
    protected static final byte OPERATION_LOGOUT = 3;
    private static final String MON_COMPONENT_LOGIN = "AppServer:Security:Authentication:FastLoginContext:login";
    private static final String MON_COMPONENT_LOGOUT = "AppServer:Security:Logout:FastLoginContext:logout";
    private static final String MON_SREQUEST_DESCRIPTION = "Successful login.";
    private static final String MON_FREQUEST_DESCRIPTION = "Failed login.";
    protected Subject subject = null;
    protected CallbackHandler callbackHandler = null;
    private static int threadContextId = -1;
    private static int maxAllowedUsers = -1;
    static int sessionExpirationPeriod = -2;
    private boolean isSubjectProvided = false;
    private AppConfigurationEntry[] configuration = null;
    private Principal userPrincipal = null;
    private Map sharedState = null;
    private SecuritySession session = null;
    private LoginContextFactory factory = null;
    private LoginModule[] modules = null;
    private SecuritySessionPool sessions = null;
    private boolean createSession = true;
    private ModulesProcessAction processAction = null;
    private String authenticationStack = null;
    private PolicyConfigurationMonitor policyMonitor = null;
    private PolicyConfigurationMonitor aggregateMonitor = null;
    static /* synthetic */ Class class$com$sap$engine$lib$security$Principal;

    FastLoginContext(LoginContextFactory factory, boolean createSession, String authenticationStack) throws Exception {
        super("empty");
        this.factory = factory;
        this.createSession = createSession;
        this.authenticationStack = authenticationStack;
        this.policyMonitor = MonitorTable.getMonitor(authenticationStack);
        this.aggregateMonitor = MonitorTable.getAggregatedMonitor();
    }

    public void login() throws LoginException {
        IMonitor monitor = null;
        try {
            monitor = TaskMonitor.getRequestMonitor(null, (String)MON_AUTHENTICATION_REQUEST);
            monitor.startComponent(MON_COMPONENT_LOGIN);
            ThreadContext currentThreadContext = SecurityServerFrame.threadContext.getThreadContext();
            SecurityContext context = null;
            if (currentThreadContext != null) {
                String authentication;
                if (threadContextId == -1) {
                    threadContextId = currentThreadContext.getContextObjectId("security");
                }
                context = (SecurityContext)currentThreadContext.getContextObject(threadContextId);
                if (!(!this.createSession || context == null || context.isAuthenticationPending() || context.getSession() == null || (authentication = context.getSession().getAuthenticationConfiguration()) == null || "SAP-J2EE-Engine".equals(authentication) || "ticket".equals(authentication) || "run_as".equals(authentication))) {
                    throw new BaseLoginException("security_1019", 15);
                }
            }
            if (this.configuration == null) {
                this.sharedState = this.factory.initializeLoginContext(this, false);
            }
            if (this.sessions != null && this.sessions.size() > maxAllowedUsers && this.sessions.getValidSessions().size() > maxAllowedUsers) {
                this.monitorUnsuccessfulLoginAttempt();
                throw new BaseLoginException("security_1003", 14);
            }
            if (!this.isSubjectProvided) {
                this.subject = new Subject();
            }
            boolean passwordChangeFails = false;
            String userName = null;
            SubjectWrapper subjectWrapper = null;
            LoginModuleHelperImpl moduleHelper = ((SecurityContextImpl)SecurityServerFrame.getSecurityContext()).getLoginModuleHelper();
            AuthenticationContextImpl authentication = (AuthenticationContextImpl)SecurityContextImpl.getRoot().getPolicyConfigurationContext((String)this.sharedState.get("sap.security.auth.configuration.name")).getAuthenticationContext();
            UserContext userContext = authentication.getAuthenticationUserStore().getUserContext();
            ClassLoader saveLoader = Thread.currentThread().getContextClassLoader();
            try {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    AccessController.doPrivileged(this.processAction.getAction(this.configuration, this.modules, (byte)0, this.authenticationStack));
                    AccessController.doPrivileged(this.processAction.getAction(this.configuration, this.modules, (byte)2, this.authenticationStack));
                    this.userPrincipal = (Principal)this.sharedState.get("javax.security.auth.login.principal");
                    subjectWrapper = new SubjectWrapper(this.subject, this.userPrincipal);
                    userName = subjectWrapper.getPrincipal().getName();
                    UserInfo userInfo = (UserInfo)this.sharedState.get(USER_INFO);
                    try {
                        moduleHelper.refreshUserInfo(userContext, userName, this.sharedState);
                        if (userInfo == null) {
                            userInfo = moduleHelper.getUserInfo(userContext, userName);
                        }
                    }
                    catch (SecurityException e) {
                        moduleHelper.throwUserLoginException((Exception)e, (byte)0);
                    }
                    if (moduleHelper.isUserAccountExpired(userInfo, userContext, this.sharedState)) {
                        moduleHelper.throwNewLoginException("The user account " + userName + " is either expired, or not valid yet.", (byte)2);
                    }
                    moduleHelper.checkUserLockStatus(userContext, userInfo, this.sharedState);
                    passwordChangeFails = true;
                    if (this.callbackHandler != null) {
                        moduleHelper.changePasswordIfNeeded(userContext, userInfo, this.callbackHandler);
                    }
                    if (authentication.getUserStoreIsTheActiveOne()) {
                        moduleHelper.writeLogonStatistics(true, userInfo, System.currentTimeMillis(), this.sharedState);
                    }
                    monitor.setDescription(MON_SREQUEST_DESCRIPTION);
                }
                catch (Exception e) {
                    monitor.setDescription(MON_FREQUEST_DESCRIPTION);
                    monitor.setUser(SecurityContext.SYSTEM_PRINCIPAL.getName());
                    try {
                        AccessController.doPrivileged(this.processAction.getAction(this.configuration, this.modules, (byte)1, this.authenticationStack));
                    }
                    catch (PrivilegedActionException ee) {
                        // empty catch block
                    }
                    if (!this.isSubjectProvided) {
                        this.subject = null;
                    }
                    this.monitorUnsuccessfulLoginAttempt();
                    Exception exception = null;
                    if (e instanceof PrivilegedActionException) {
                        exception = ((PrivilegedActionException)e).getException();
                    } else {
                        if (e instanceof RuntimeException) {
                            SecurityResourceAccessor.location.traceThrowableT(500, e.getLocalizedMessage(), (Throwable)e);
                        } else if (SecurityResourceAccessor.location.beDebug()) {
                            SecurityResourceAccessor.location.traceThrowableT(100, e.getLocalizedMessage(), (Throwable)e);
                        }
                        exception = e;
                    }
                    if (!passwordChangeFails && exception instanceof LoginException && authentication.getUserStoreIsTheActiveOne()) {
                        moduleHelper.writeLogonStatistics(false, (String)this.sharedState.get("sap.security.auth.refresh.done"), System.currentTimeMillis(), this.sharedState);
                    }
                    if (exception instanceof LoginExceptionDetails) {
                        throw new BaseLoginException("security_1004", exception, ((LoginExceptionDetails)((Object)exception)).getExceptionCause());
                    }
                    throw new BaseLoginException("security_1004", exception);
                }
                Object var14_17 = null;
                Thread.currentThread().setContextClassLoader(saveLoader);
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                Thread.currentThread().setContextClassLoader(saveLoader);
                throw throwable;
            }
            if (context != null && this.sessions != null && this.createSession) {
                this.session = this.sessions.add(subjectWrapper, this.authenticationStack);
                context.setSession(this.session);
            }
            monitor.setUser(userName);
            Object var16_20 = null;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            monitor.endComponent(MON_COMPONENT_LOGIN);
            monitor.endRequest(MON_AUTHENTICATION_REQUEST);
            throw throwable;
        }
        monitor.endComponent(MON_COMPONENT_LOGIN);
        monitor.endRequest(MON_AUTHENTICATION_REQUEST);
    }

    public void logout() throws LoginException {
        IMonitor monitor = null;
        try {
            monitor = TaskMonitor.getRequestMonitor(null, (String)MON_LOGOUT_REQUEST);
            monitor.startComponent(MON_COMPONENT_LOGOUT);
            if (this.subject == null) {
                throw new BaseLoginException("security_1005", 16);
            }
            try {
                AccessController.doPrivileged(this.processAction.getAction(this.configuration, this.modules, (byte)3, this.authenticationStack));
            }
            catch (PrivilegedActionException e) {
                Exception exception;
                if (!this.isSubjectProvided) {
                    this.subject = null;
                }
                if ((exception = e.getException()) instanceof LoginExceptionDetails) {
                    throw new BaseLoginException("security_1006", exception, ((LoginExceptionDetails)((Object)exception)).getExceptionCause());
                }
                throw new BaseLoginException("security_1006", exception);
            }
            if (this.session != null) {
                Principal principal = this.session.getPrincipal();
                if (principal != null) {
                    monitor.setUser(principal.getName());
                }
                if (this.sessions != null) {
                    this.sessions.removeSessions(this.session);
                }
                this.session.setValid(false);
            } else {
                monitor.setUser(this.getPrincipal().getName());
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.endComponent(MON_COMPONENT_LOGOUT);
            monitor.endRequest(MON_LOGOUT_REQUEST);
            throw throwable;
        }
        monitor.endComponent(MON_COMPONENT_LOGOUT);
        monitor.endRequest(MON_LOGOUT_REQUEST);
    }

    public void close() {
        this.factory.close(this);
    }

    protected void logoutSession(SecuritySession session) throws LoginException {
        this.factory.initializeLoginContext(this, true);
        this.session = session;
        this.logout();
    }

    void set(SecuritySessionPool sessions, Subject subject, LoginModule[] modules, AppConfigurationEntry[] configuration) {
        String max;
        this.configuration = configuration;
        this.sessions = sessions;
        this.subject = subject;
        this.modules = modules;
        this.isSubjectProvided = subject != null;
        this.processAction = new ModulesProcessAction();
        if (maxAllowedUsers == -1) {
            block8: {
                try {
                    max = SecurityServerFrame.getServiceProperties().getProperty("MaxUsersCount");
                    maxAllowedUsers = Integer.valueOf(max);
                }
                catch (Exception e) {
                    SecurityResourceAccessor.category.warningT(SecurityResourceAccessor.location, "Unable to retrieve the maximum number of users to be logged in! This should be specified in security service properties and the value should be integer.");
                    if (!SecurityResourceAccessor.location.beWarning()) break block8;
                    SecurityResourceAccessor.location.traceThrowableT(400, "Unable to retrieve the maximum number of users to be logged in! This should be specified in security service properties and the value should be integer.", (Throwable)e);
                }
            }
            if (maxAllowedUsers == -1) {
                maxAllowedUsers = Integer.MAX_VALUE;
            }
        }
        if (sessionExpirationPeriod == -2) {
            block9: {
                try {
                    max = SecurityServerFrame.getServiceProperties().getProperty("SessionExpirationPeriod");
                    sessionExpirationPeriod = Integer.valueOf(max);
                }
                catch (Exception e) {
                    SecurityResourceAccessor.category.warningT(SecurityResourceAccessor.location, "Unable to retrieve the session expiration period from security service properties! This property should have an integer value.");
                    if (!SecurityResourceAccessor.location.beWarning()) break block9;
                    SecurityResourceAccessor.location.traceThrowableT(400, "Unable to retrieve the session expiration period from security service properties! This property should have an integer value.", (Throwable)e);
                }
            }
            if (sessionExpirationPeriod == -2) {
                sessionExpirationPeriod = -1;
            }
        }
    }

    void set(Subject subject, CallbackHandler handler) {
        this.subject = subject;
        this.callbackHandler = handler;
    }

    private void monitorUnsuccessfulLoginAttempt() {
        ++this.policyMonitor.failedLogonCount;
        ++this.aggregateMonitor.failedLogonCount;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.subject != null) {
            Set<Object> s;
            try {
                s = this.subject.getPrincipals(class$com$sap$engine$lib$security$Principal == null ? (class$com$sap$engine$lib$security$Principal = FastLoginContext.class$("com.sap.engine.lib.security.Principal")) : class$com$sap$engine$lib$security$Principal);
                this.userPrincipal = (Principal)s.iterator().next();
            }
            catch (Exception e) {
                this.userPrincipal = null;
            }
            if (this.userPrincipal == null) {
                try {
                    s = this.subject.getPrincipals();
                    this.userPrincipal = (Principal)s.iterator().next();
                }
                catch (Exception e) {
                    this.userPrincipal = null;
                }
            }
        }
        return this.userPrincipal != null ? this.userPrincipal : SecurityContext.SYSTEM_PRINCIPAL;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

