/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.login;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.services.security.exceptions.BaseNotSerializableException;
import com.sap.engine.services.security.exceptions.SecurityResourceAccessor;
import com.sap.engine.services.security.login.InputSerializator;
import com.sap.engine.services.security.login.OutputSerializator;
import com.sap.exception.IBaseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.security.auth.login.AppConfigurationEntry;

public class ConfigEntrySerializator {
    public static final int MAX_BYTES = 2000;
    static /* synthetic */ Class class$javax$security$auth$login$AppConfigurationEntry;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$security$auth$login$AppConfigurationEntry$LoginModuleControlFlag;
    static /* synthetic */ Class class$java$util$Map;

    public static final AppConfigurationEntry[] readAppConfigurationEntryArray(Configuration configuration) {
        try {
            int size = ConfigEntrySerializator.getSize(configuration);
            AppConfigurationEntry[] result = new AppConfigurationEntry[size];
            Configuration sub = null;
            String appconfigentryClassname = null;
            String classname = null;
            AppConfigurationEntry.LoginModuleControlFlag flag = null;
            Hashtable<String, Object> options = null;
            Object flagValue = null;
            int i = 0;
            while (i < size) {
                block32: {
                    block31: {
                        sub = configuration.getSubConfiguration("" + i);
                        classname = (String)sub.getConfigEntry("classname");
                        flagValue = sub.getConfigEntry("flag");
                        if (flagValue instanceof Integer) {
                            switch ((Integer)flagValue) {
                                case 0: {
                                    flag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
                                    break;
                                }
                                case 1: {
                                    flag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                                    break;
                                }
                                case 2: {
                                    flag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                                    break;
                                }
                                case 3: {
                                    flag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                                }
                            }
                        } else if (flagValue instanceof String) {
                            if ("OPTIONAL".equals(flagValue)) {
                                flag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
                            } else if ("REQUIRED".equals(flagValue)) {
                                flag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                            } else if ("REQUISITE".equals(flagValue)) {
                                flag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                            } else if ("SUFFICIENT".equals(flagValue)) {
                                flag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                            }
                        }
                        options = new Hashtable<String, Object>(11);
                        try {
                            Configuration optionsConfiguration = sub.getSubConfiguration("options");
                            String[] keys = optionsConfiguration.getAllConfigEntryNames();
                            String[] fileKeys = optionsConfiguration.getAllFileEntryNames();
                            Object value = null;
                            int k = 0;
                            while (k < keys.length) {
                                value = optionsConfiguration.getConfigEntry(keys[k]);
                                if (value instanceof byte[]) {
                                    options.put(keys[k], ConfigEntrySerializator.array2object((byte[])value));
                                } else {
                                    options.put(keys[k], value);
                                }
                                ++k;
                            }
                            int k2 = 0;
                            while (k2 < fileKeys.length) {
                                byte[] arr = ConfigEntrySerializator.readInputStream(optionsConfiguration.getFile(fileKeys[k2]));
                                options.put(fileKeys[k2], ConfigEntrySerializator.array2object(arr));
                                ++k2;
                            }
                        }
                        catch (Exception e) {
                            if (!SecurityResourceAccessor.location.beWarning()) break block31;
                            SecurityResourceAccessor.location.traceThrowableT(400, "Could not properly read the login module options from the configuration with path {0}.", new Object[]{sub.getPath()}, (Throwable)e);
                        }
                    }
                    try {
                        appconfigentryClassname = (String)sub.getConfigEntry("appconfigentryclassname");
                    }
                    catch (Exception e) {
                        appconfigentryClassname = null;
                    }
                    if (appconfigentryClassname == null || appconfigentryClassname.equals((class$javax$security$auth$login$AppConfigurationEntry == null ? ConfigEntrySerializator.class$("javax.security.auth.login.AppConfigurationEntry") : class$javax$security$auth$login$AppConfigurationEntry).getName())) {
                        result[i] = new AppConfigurationEntry(classname, flag, options);
                    } else {
                        try {
                            Class<?> classs = Class.forName(appconfigentryClassname);
                            Constructor<?> constructor = classs.getConstructor(class$java$lang$String == null ? ConfigEntrySerializator.class$("java.lang.String") : class$java$lang$String, class$javax$security$auth$login$AppConfigurationEntry$LoginModuleControlFlag == null ? ConfigEntrySerializator.class$("javax.security.auth.login.AppConfigurationEntry$LoginModuleControlFlag") : class$javax$security$auth$login$AppConfigurationEntry$LoginModuleControlFlag, class$java$util$Map == null ? ConfigEntrySerializator.class$("java.util.Map") : class$java$util$Map);
                            result[i] = (AppConfigurationEntry)constructor.newInstance(classname, flag, options);
                        }
                        catch (Throwable t) {
                            if (!SecurityResourceAccessor.location.beWarning()) break block32;
                            SecurityResourceAccessor.location.traceThrowableT(400, t.getLocalizedMessage(), t);
                        }
                    }
                }
                ++i;
            }
            return result;
        }
        catch (Exception e) {
            BaseNotSerializableException bse = new BaseNotSerializableException("security_1021", e);
            bse.log();
            return new AppConfigurationEntry[0];
        }
    }

    private static byte[] readInputStream(InputStream file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int bufferSize = 256;
        byte[] io_buffer = new byte[bufferSize];
        int readBytesCount = -1;
        while ((readBytesCount = file.read(io_buffer)) != -1) {
            out.write(io_buffer, 0, readBytesCount);
        }
        return out.toByteArray();
    }

    public static final void writeAppConfigurationEntryArray(Configuration configuration, AppConfigurationEntry[] array) {
        try {
            Configuration sub;
            Hashtable properties;
            String flag;
            block21: {
                if (array == null) {
                    array = new AppConfigurationEntry[]{};
                }
                flag = "OPTIONAL";
                properties = null;
                sub = null;
                try {
                    configuration.deleteAllSubConfigurations();
                }
                catch (Exception e) {
                    String[] subnames = configuration.getAllSubConfigurationNames();
                    if (subnames == null || subnames.length <= 0 || !SecurityResourceAccessor.location.beWarning()) break block21;
                    SecurityResourceAccessor.location.traceThrowableT(400, e.getLocalizedMessage(), (Throwable)e);
                }
            }
            try {
                configuration.addConfigEntry("size", new Integer(array.length));
            }
            catch (Exception e) {
                configuration.modifyConfigEntry("size", new Integer(array.length));
            }
            int i = 0;
            while (i < array.length) {
                sub = configuration.createSubConfiguration("" + i);
                if (!array[i].getClass().getName().equals((class$javax$security$auth$login$AppConfigurationEntry == null ? ConfigEntrySerializator.class$("javax.security.auth.login.AppConfigurationEntry") : class$javax$security$auth$login$AppConfigurationEntry).getName())) {
                    sub.addConfigEntry("appconfigentryclassname", array[i].getClass().getName());
                }
                sub.addConfigEntry("classname", array[i].getLoginModuleName());
                if (array[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL) {
                    flag = "OPTIONAL";
                } else if (array[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                    flag = "REQUIRED";
                } else if (array[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                    flag = "REQUISITE";
                } else if (array[i].getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT) {
                    flag = "SUFFICIENT";
                }
                sub.addConfigEntry("flag", flag);
                if (array[i].getOptions() instanceof Hashtable) {
                    properties = (Hashtable)array[i].getOptions();
                } else {
                    properties = new Hashtable();
                    properties.putAll(array[i].getOptions());
                }
                Configuration optionsConfiguration = sub.createSubConfiguration("options");
                Enumeration enumeration = properties.keys();
                String key = null;
                Object value = null;
                while (enumeration.hasMoreElements()) {
                    key = (String)enumeration.nextElement();
                    value = properties.get(key);
                    if (value != null && value.getClass().getClassLoader() != null) {
                        if (!(value instanceof Serializable)) continue;
                        byte[] arr = ConfigEntrySerializator.object2array((Serializable)properties.get(key));
                        if (arr.length <= 2000) {
                            optionsConfiguration.addConfigEntry(key, arr);
                            continue;
                        }
                        ByteArrayInputStream in = new ByteArrayInputStream(arr);
                        optionsConfiguration.addFileAsStream(key, in);
                        continue;
                    }
                    optionsConfiguration.addConfigEntry(key, properties.get(key));
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseNotSerializableException bse = new BaseNotSerializableException("security_1022", e);
            bse.log();
        }
    }

    public static final int getSize(Configuration configuration) {
        try {
            return (Integer)configuration.getConfigEntry("size");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static Serializable array2object(byte[] abyte0) throws NotSerializableException {
        Serializable serializable;
        block8: {
            ByteArrayInputStream bytearrayinputstream = null;
            InputSerializator objectinputstream = null;
            String loaderName = null;
            try {
                bytearrayinputstream = new ByteArrayInputStream(abyte0);
                objectinputstream = new InputSerializator(null, bytearrayinputstream);
                objectinputstream.loaderName = loaderName = (String)objectinputstream.readObject();
                serializable = (Serializable)objectinputstream.readObject();
            }
            catch (NotSerializableException exception) {
                if (exception instanceof IBaseException) {
                    throw exception;
                }
                throw new BaseNotSerializableException("security_1014", exception);
            }
            catch (Exception exception) {
                throw new BaseNotSerializableException("security_1001", exception);
            }
            try {
                if (objectinputstream != null) {
                    objectinputstream.close();
                }
                if (bytearrayinputstream != null) {
                    bytearrayinputstream.close();
                }
            }
            catch (Exception e) {
                if (!SecurityResourceAccessor.location.beWarning()) break block8;
                SecurityResourceAccessor.location.traceThrowableT(400, e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return serializable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] object2array(Serializable serializable) throws NotSerializableException {
        ByteArrayOutputStream bytearrayoutputstream = null;
        OutputSerializator objectoutputstream = null;
        ClassLoader loader = null;
        String loaderName = null;
        try {
            try {
                block12: {
                    loader = serializable.getClass().getClassLoader();
                    if (loader != null) {
                        try {
                            loaderName = (String)loader.getClass().getMethod("getName", new Class[0]).invoke((Object)loader, new Object[0]);
                        }
                        catch (Throwable t) {
                            if (!SecurityResourceAccessor.location.beWarning()) break block12;
                            SecurityResourceAccessor.location.traceThrowableT(400, t.getLocalizedMessage(), t);
                        }
                    }
                }
                bytearrayoutputstream = new ByteArrayOutputStream();
                objectoutputstream = new OutputSerializator(loaderName, bytearrayoutputstream);
                objectoutputstream.writeObject(loaderName);
                objectoutputstream.writeObject(serializable);
                objectoutputstream.flush();
                byte[] t = bytearrayoutputstream.toByteArray();
                Object var7_8 = null;
                try {
                    if (objectoutputstream != null) {
                        objectoutputstream.close();
                    }
                    if (bytearrayoutputstream == null) return t;
                    bytearrayoutputstream.close();
                    return t;
                }
                catch (Exception e) {
                    if (!SecurityResourceAccessor.location.beWarning()) return t;
                    SecurityResourceAccessor.location.traceThrowableT(400, e.getLocalizedMessage(), (Throwable)e);
                }
                return t;
            }
            catch (Exception exception) {
                throw new BaseNotSerializableException("security_1002", exception);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {}
            catch (Exception e) {
                if (!SecurityResourceAccessor.location.beWarning()) throw throwable;
                SecurityResourceAccessor.location.traceThrowableT(400, e.getLocalizedMessage(), (Throwable)e);
                throw throwable;
            }
            if (objectoutputstream != null) {
                objectoutputstream.close();
            }
            if (bytearrayoutputstream == null) throw throwable;
            bytearrayoutputstream.close();
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

