/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement.tree;

import com.sap.engine.interfaces.security.userstore.context.SearchFilter;
import com.sap.engine.services.security.gui.userstore.usermanagement.ParentsDialog;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.GroupTreeNode;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.UserCellRenderer;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.UserTreeNode;
import com.sap.engine.services.security.gui.util.SortedList;
import com.sap.engine.services.security.remote.RemoteGroupContext;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteIterator;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.RemoteUserContext;
import com.sap.engine.services.security.remote.RemoteUserStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class UserTreePanel
extends JPanel
implements TreeSelectionListener,
ActionListener,
ListSelectionListener,
ChangeListener,
KeyListener {
    private final String SEARCH_ACTION_COMMAND = "SEARCH_ACTION_COMMAND";
    private final String RESET_ACTION_COMMAND = "RESET_ACTION_COMMAND";
    protected Frame frame = null;
    private JTabbedPane tabbedPane = new JTabbedPane(3);
    private JTabbedPane searchTabbedPane = new JTabbedPane();
    private JPanel searchComponent = new JPanel();
    private JPanel userTreeComponent = new JPanel();
    protected JTree tree = new JTree();
    protected GroupTreeNode root;
    private boolean areUsersVisible = true;
    private boolean areGroupsVisible = true;
    private RemoteUserContext userContext = null;
    private RemoteGroupContext groupContext = null;
    private static String usersString = "Users";
    private static String groupsString = "Groups";
    private SortedList list = new SortedList();
    private JTextField userNamePatternField = new JTextField();
    private JTextField userMaxCountField = new JTextField();
    private JCheckBox checkLockedUsers = new JCheckBox(" Locked Users");
    private JTextField groupNamePatternField = new JTextField();
    private JTextField groupChildgroupPatternField = new JTextField();
    private JTextField groupChilduserPatternField = new JTextField();
    private JTextField groupMaxCountField = new JTextField();
    private JButton searchBtn = new JButton("Search");
    private JButton resetBtn = new JButton("Reset");
    private ArrayList usersListData = new ArrayList(0);
    private ArrayList groupsListData = new ArrayList(0);
    private JLabel searchStateBar = new JLabel();
    private int userSearchState = -1;
    private int groupSearchState = -1;
    private boolean isTreeInitialized = false;
    private boolean isSearchRefreshed = false;
    private boolean isInitializing = false;

    public UserTreePanel() {
        JScrollPane scroll = new JScrollPane();
        this.userTreeComponent.setLayout(new BorderLayout());
        this.userTreeComponent.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " User Tree "));
        this.userTreeComponent.add((Component)scroll, "Center");
        scroll.getViewport().add((Component)this.tree, null);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new UserCellRenderer(this));
        this.tree.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(true);
        this.searchComponent.setLayout(new GridBagLayout());
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)this.searchBtn, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        buttonsPanel.add((Component)this.resetBtn, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.searchBtn.setActionCommand("SEARCH_ACTION_COMMAND");
        this.searchBtn.addActionListener(this);
        this.resetBtn.setActionCommand("RESET_ACTION_COMMAND");
        this.resetBtn.addActionListener(this);
        JPanel userSearchComponent = new JPanel(new GridBagLayout());
        userSearchComponent.add((Component)new JLabel("Name: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        userSearchComponent.add((Component)this.userNamePatternField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        userSearchComponent.add((Component)new JLabel("Display: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        userSearchComponent.add((Component)this.userMaxCountField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        userSearchComponent.add((Component)this.checkLockedUsers, new GridBagConstraints(0, 2, 2, 1, 0.1, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        JPanel groupSearchComponent = new JPanel(new GridBagLayout());
        groupSearchComponent.add((Component)new JLabel("Name: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        groupSearchComponent.add((Component)this.groupNamePatternField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        groupSearchComponent.add((Component)new JLabel("Child Group: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        groupSearchComponent.add((Component)this.groupChildgroupPatternField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        groupSearchComponent.add((Component)new JLabel("Child User: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        groupSearchComponent.add((Component)this.groupChilduserPatternField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        groupSearchComponent.add((Component)new JLabel("Display: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        groupSearchComponent.add((Component)this.groupMaxCountField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.searchTabbedPane.addTab(usersString, userSearchComponent);
        this.searchTabbedPane.addTab(groupsString, groupSearchComponent);
        this.searchTabbedPane.addChangeListener(this);
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.setBorder(BorderFactory.createEtchedBorder());
        listPanel.add((Component)new JScrollPane(this.list), "Center");
        listPanel.add((Component)this.searchStateBar, "South");
        this.setsearchState(-1);
        this.searchComponent.add((Component)this.searchTabbedPane, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 11, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.searchComponent.add((Component)buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.searchComponent.add((Component)listPanel, new GridBagConstraints(0, 2, 1, 2, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.searchComponent.setPreferredSize(new Dimension(180, 400));
        this.tabbedPane.addTab("Search", this.searchComponent);
        this.tabbedPane.addTab("Tree", this.userTreeComponent);
        this.tabbedPane.addChangeListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.userNamePatternField.addKeyListener(this);
        this.userMaxCountField.addKeyListener(this);
        this.groupNamePatternField.addKeyListener(this);
        this.groupChildgroupPatternField.addKeyListener(this);
        this.groupChilduserPatternField.addKeyListener(this);
        this.groupMaxCountField.addKeyListener(this);
        this.userMaxCountField.setToolTipText("Here specify the maximum number of results to be displayed.");
        this.groupChildgroupPatternField.setToolTipText("<html><font size=3>Here specify the name of a sub-contained group for the searched group.<br>Note that wildcards are interpreted as literals.</html>");
        this.groupChilduserPatternField.setToolTipText("<html><font size=3>Here specify the name of a user contained in the searched group.<br>Note that wildcards are interpreted as literals.</html>");
        this.groupMaxCountField.setToolTipText("Here specify the maximum number of results to be displayed.");
        this.list.setSelectionMode(0);
    }

    public UserTreePanel(RemoteSecurity security) throws RemoteException {
        this();
        this.init(security);
    }

    public UserTreePanel(RemoteUserStore userStore) throws RemoteException {
        this();
        this.init(userStore);
    }

    public UserTreePanel(RemoteUserContext userContext, RemoteGroupContext groupContext) throws RemoteException {
        this();
        this.init(userContext, groupContext);
    }

    public void init(RemoteSecurity security) throws RemoteException {
        this.init(security.getRemoteUserStoreFactory().getActiveUserStore());
    }

    public void init(RemoteUserStore userStore) throws RemoteException {
        this.init(userStore.getUserContext(), userStore.getGroupContext());
    }

    public void init(RemoteUserContext userContext, RemoteGroupContext groupContext) throws RemoteException {
        if (userContext == null) {
            throw new NullPointerException("User context must not be null!");
        }
        this.userContext = userContext;
        this.groupContext = groupContext;
        this.root = null;
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.tree.addTreeSelectionListener(listener);
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath selection = this.tree.getSelectionPath();
        if (selection != null) {
            if (selection.getLastPathComponent() instanceof UserTreeNode && !this.areUsersVisible) {
                this.tree.clearSelection();
            } else if (selection.getLastPathComponent() instanceof GroupTreeNode) {
                GroupTreeNode groupNode;
                this.initTree(groupNode, (groupNode = (GroupTreeNode)selection.getLastPathComponent()) == this.root);
                if (!this.areGroupsVisible) {
                    this.tree.clearSelection();
                }
            }
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.list.addListSelectionListener(listener);
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    public Object getSelectedUser() {
        if (this.tabbedPane.getSelectedComponent() == this.userTreeComponent) {
            TreePath selection = this.tree.getSelectionPath();
            if (selection != null) {
                try {
                    if (selection.getLastPathComponent() instanceof UserTreeNode) {
                        return this.userContext.getUserInfo(((UserTreeNode)selection.getLastPathComponent()).getName());
                    }
                    if (selection.getLastPathComponent() instanceof GroupTreeNode) {
                        return this.groupContext.getGroupInfo(((GroupTreeNode)selection.getLastPathComponent()).getName());
                    }
                }
                catch (Exception _) {
                    return null;
                }
            }
        } else {
            String nodeName = (String)this.list.getSelectedValue();
            if (nodeName != null) {
                if (this.searchTabbedPane.getSelectedIndex() == 0) {
                    try {
                        return this.userContext.getUserInfo(nodeName);
                    }
                    catch (Exception _) {
                        return null;
                    }
                }
                try {
                    return this.groupContext.getGroupInfo(nodeName);
                }
                catch (Exception _) {
                    return null;
                }
            }
        }
        return null;
    }

    public RemoteGroupInfo getSelectedUserParent() {
        if (this.tabbedPane.getSelectedComponent() == this.userTreeComponent) {
            TreePath selection = this.tree.getSelectionPath();
            if (selection != null) {
                try {
                    int position = selection.getPathCount() - 2;
                    if (position >= 0) {
                        return this.groupContext.getGroupInfo(((GroupTreeNode)selection.getPathComponent(position)).getName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            String nodeName = (String)this.list.getSelectedValue();
            RemoteIterator parents = null;
            try {
                parents = this.searchTabbedPane.getSelectedIndex() == 0 ? this.userContext.getUserInfo(nodeName).getParentGroups() : this.groupContext.getGroupInfo(nodeName).getParentGroups();
                ParentsDialog dialog = null;
                ArrayList listData = new ArrayList();
                while (parents.hasNext()) {
                    listData.add(parents.next());
                }
                dialog = new ParentsDialog(this.frame, listData);
                dialog.setLocationRelativeTo(this.frame);
                ((Component)dialog).setVisible(true);
                if (dialog.isConfirmed()) {
                    return this.groupContext.getGroupInfo(dialog.getSelectedParent());
                }
            }
            catch (Exception _) {
                return null;
            }
        }
        return null;
    }

    public boolean hasSelectedUserParent() {
        if (this.tabbedPane.getSelectedComponent() == this.userTreeComponent) {
            TreePath selection = this.tree.getSelectionPath();
            if (selection != null) {
                int position = selection.getPathCount() - 2;
                return position >= 0;
            }
        } else {
            String nodeName = (String)this.list.getSelectedValue();
            if (this.searchTabbedPane.getSelectedIndex() == 0) {
                try {
                    return this.userContext.getUserInfo(nodeName).getParentGroups().hasNext();
                }
                catch (Exception _) {
                    return false;
                }
            }
            try {
                return this.groupContext.getGroupInfo(nodeName).getParentGroups().hasNext();
            }
            catch (Exception _) {
                return false;
            }
        }
        return false;
    }

    public Object[] getSelectedUsers() {
        if (this.tabbedPane.getSelectedIndex() == 1) {
            TreePath selection = this.tree.getSelectionPath();
            if (selection != null) {
                try {
                    if (selection.getLastPathComponent() instanceof UserTreeNode) {
                        return new Object[]{this.userContext.getUserInfo(((UserTreeNode)selection.getLastPathComponent()).getName())};
                    }
                    if (selection.getLastPathComponent() instanceof GroupTreeNode) {
                        return new Object[]{this.groupContext.getGroupInfo(((GroupTreeNode)selection.getLastPathComponent()).getName())};
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            String nodeName = (String)this.list.getSelectedValue();
            if (this.searchTabbedPane.getSelectedIndex() == 0) {
                try {
                    return new Object[]{this.userContext.getUserInfo(nodeName)};
                }
                catch (Exception _) {
                    return new Object[0];
                }
            }
            try {
                return new Object[]{this.groupContext.getGroupInfo(nodeName)};
            }
            catch (Exception _) {
                return new Object[0];
            }
        }
        return new Object[0];
    }

    protected void initTree(GroupTreeNode node, boolean isRoot) {
        try {
            RemoteGroupInfo nodeGroupInfo;
            if (node.initialized()) {
                return;
            }
            RemoteIterator childrenGroups = null;
            RemoteIterator childrenUsers = null;
            Exception exception = null;
            RemoteGroupInfo remoteGroupInfo = nodeGroupInfo = node.getName().equals("") ? null : this.groupContext.getGroupInfo(node.getName());
            if (node.getName().equals("") || nodeGroupInfo != null) {
                int fromIndex;
                node.removeAllChildren();
                if (node.getName().equals("")) {
                    if (this.groupContext != null) {
                        childrenGroups = this.groupContext.listRootGroups();
                    }
                    childrenUsers = this.userContext.listRootUsers();
                } else {
                    childrenGroups = nodeGroupInfo.getChildGroups();
                    childrenUsers = nodeGroupInfo.getUsersInGroup();
                }
                while (childrenGroups != null && childrenGroups.hasNext() && this.groupContext != null) {
                    GroupTreeNode tempNode = null;
                    Object child = childrenGroups.next();
                    try {
                        tempNode = new GroupTreeNode((String)child);
                        tempNode.add(new GroupTreeNode(null));
                        node.insertSortedNode(tempNode, -1);
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                }
                try {
                    fromIndex = node.getIndex(node.getLastChild()) + 1;
                }
                catch (NoSuchElementException nse) {
                    fromIndex = -1;
                }
                while (childrenUsers != null && childrenUsers.hasNext()) {
                    UserTreeNode tempNode = null;
                    String child = (String)childrenUsers.next();
                    try {
                        tempNode = new UserTreeNode(child);
                        node.insertSortedNode(tempNode, fromIndex);
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                }
            }
            node.setInitialized();
            if (exception != null) {
                System.err.println("Exception during  the visualization of the subtree of group " + node.getName());
                System.err.println(exception);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
        this.tree.validate();
    }

    public void refreshTree() {
        this.refreshTree(this.getRoot());
    }

    private void refreshTree(GroupTreeNode root) {
        try {
            this.root = root == null ? new GroupTreeNode() : root;
            this.initTree(this.root, true);
            ((DefaultTreeModel)this.tree.getModel()).setRoot(this.root);
            this.tree.setRootVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GroupTreeNode getRoot() {
        return this.root;
    }

    public boolean areUsersVisible() {
        return this.areUsersVisible;
    }

    public void setUsersVisible(boolean flag) {
        this.areUsersVisible = flag;
        if (!this.areUsersVisible) {
            this.searchTabbedPane.setSelectedIndex(1);
            this.searchTabbedPane.setEnabledAt(0, false);
        } else {
            this.searchTabbedPane.setSelectedIndex(0);
            this.searchTabbedPane.setEnabledAt(0, true);
        }
    }

    public void setGroupsVisible(boolean flag) {
        this.areGroupsVisible = flag;
        if (!this.areGroupsVisible) {
            this.searchTabbedPane.setSelectedIndex(0);
            this.searchTabbedPane.setEnabledAt(1, false);
        } else {
            this.searchTabbedPane.setSelectedIndex(1);
            this.searchTabbedPane.setEnabledAt(1, true);
        }
    }

    public void clearSelection() {
        this.tree.clearSelection();
        this.list.clearSelection();
    }

    public void clear() {
        ((DefaultMutableTreeNode)this.tree.getModel().getRoot()).removeAllChildren();
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("SEARCH_ACTION_COMMAND")) {
            this.searchAction();
        } else if (command.equals("RESET_ACTION_COMMAND")) {
            this.resetAction();
        }
    }

    private void searchAction() {
        if (this.searchTabbedPane.getSelectedIndex() == 0) {
            this.searchUsersAction();
        } else {
            this.searchGroupsAction();
        }
    }

    private void searchUsersAction() {
        this.searchStateBar.setText("Searching...");
        SearchFilter searchFilter = this.userContext.getSearchFilter();
        String searchValue = null;
        int filterSize = 0;
        if (this.userNamePatternField.getText().length() > 0) {
            searchFilter.setSearchAttribute("user.name", searchValue, (searchValue = this.userNamePatternField.getText()).indexOf("*") == -1 ? 0 : 1);
            filterSize = (byte)(filterSize + 1);
        }
        if (filterSize == 0) {
            searchFilter.setSearchAttribute("user.name", "*", 1);
            filterSize = (byte)(filterSize + 1);
        }
        if (this.checkLockedUsers.isSelected()) {
            searchFilter.setSearchAttribute("user.locked", "true", -1);
            filterSize = (byte)(filterSize + 1);
        }
        int searchResultSize = -1;
        if (filterSize == 1) {
            try {
                searchResultSize = new Integer(this.userMaxCountField.getText());
                if (searchResultSize <= 0) {
                    searchResultSize = 0;
                    this.userMaxCountField.setText("all");
                }
            }
            catch (NumberFormatException _) {
                this.userMaxCountField.setText("all");
            }
        } else {
            this.userMaxCountField.setText("all");
        }
        this.userNamePatternField.setEditable(false);
        this.userMaxCountField.setEditable(false);
        this.checkLockedUsers.setEnabled(false);
        this.searchBtn.setEnabled(false);
        searchFilter.setMaxSearchResultSize(searchResultSize);
        try {
            RemoteIterator resultIterator = this.userContext.searchUsers(searchFilter);
            this.usersListData = new ArrayList();
            while (resultIterator.hasNext()) {
                this.usersListData.add(resultIterator.next());
            }
            this.list.setListData(this.usersListData, null);
            this.userSearchState = resultIterator.getState();
            this.setsearchState(this.userSearchState);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    private void searchGroupsAction() {
        if (this.groupContext != null) {
            this.searchStateBar.setText("Searching...");
            SearchFilter searchFilter = this.groupContext.getSearchFilter();
            String searchValue = null;
            int filterSize = 0;
            if (this.groupNamePatternField.getText().length() > 0) {
                searchFilter.setSearchAttribute("group.name", searchValue, (searchValue = this.groupNamePatternField.getText()).indexOf("*") == -1 ? 0 : 1);
                filterSize = (byte)(filterSize + 1);
            }
            if (this.groupChildgroupPatternField.getText().length() > 0) {
                searchFilter.setSearchAttribute("group.childgroup", searchValue, (searchValue = this.groupChildgroupPatternField.getText()).indexOf("*") == -1 ? 0 : 1);
                filterSize = (byte)(filterSize + 1);
            }
            if (this.groupChilduserPatternField.getText().length() > 0) {
                searchFilter.setSearchAttribute("group.childuser", searchValue, (searchValue = this.groupChilduserPatternField.getText()).indexOf("*") == -1 ? 0 : 1);
                filterSize = (byte)(filterSize + 1);
            }
            if (filterSize == 0) {
                searchFilter.setSearchAttribute("group.name", "*", 1);
                filterSize = (byte)(filterSize + 1);
            }
            int searchResultSize = -1;
            if (filterSize == 1) {
                try {
                    searchResultSize = new Integer(this.groupMaxCountField.getText());
                    if (searchResultSize <= 0) {
                        searchResultSize = 0;
                        this.groupMaxCountField.setText("all");
                    }
                }
                catch (NumberFormatException _) {
                    this.groupMaxCountField.setText("all");
                }
            } else {
                this.groupMaxCountField.setText("all");
            }
            this.groupNamePatternField.setEditable(false);
            this.groupChildgroupPatternField.setEditable(false);
            this.groupChilduserPatternField.setEditable(false);
            this.groupMaxCountField.setEditable(false);
            this.searchBtn.setEnabled(false);
            searchFilter.setMaxSearchResultSize(searchResultSize);
            try {
                RemoteIterator resultIterator = this.groupContext.searchGroups(searchFilter);
                this.groupsListData = new ArrayList();
                while (resultIterator.hasNext()) {
                    this.groupsListData.add(resultIterator.next());
                }
                this.list.setListData(this.groupsListData, null);
                this.groupSearchState = resultIterator.getState();
                this.setsearchState(this.groupSearchState);
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
    }

    private void resetAction() {
        if (this.searchTabbedPane.getSelectedIndex() == 0) {
            this.userNamePatternField.setEditable(true);
            this.userNamePatternField.requestFocus();
            if (this.userMaxCountField.getText().equals("all")) {
                this.userMaxCountField.setText("");
            }
            this.userMaxCountField.setEditable(true);
            this.checkLockedUsers.setEnabled(true);
            this.usersListData = new ArrayList(0);
            this.list.setListData(this.usersListData, null);
            this.userSearchState = -1;
            this.setsearchState(this.userSearchState);
        } else {
            this.groupNamePatternField.setEditable(true);
            this.groupNamePatternField.requestFocus();
            this.groupChildgroupPatternField.setEditable(true);
            this.groupChilduserPatternField.setEditable(true);
            if (this.groupMaxCountField.getText().equals("all")) {
                this.groupMaxCountField.setText("");
            }
            this.groupMaxCountField.setEditable(true);
            this.groupsListData = new ArrayList(0);
            this.list.setListData(this.groupsListData, null);
            this.groupSearchState = -1;
            this.setsearchState(this.groupSearchState);
        }
        this.searchBtn.setEnabled(true);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void showMessageDialog(String message, String title, int messageType) {
        if (this.frame != null) {
            JOptionPane.showMessageDialog(this.frame, message, title, messageType);
        }
    }

    public void refresh(Object root) {
        this.root = root == null ? new GroupTreeNode() : (GroupTreeNode)root;
        if (this.tabbedPane.getSelectedComponent() == this.searchComponent) {
            if (this.searchTabbedPane.getSelectedIndex() == 0) {
                this.refreshSearchUsers();
            } else {
                this.refreshSearchGroups();
            }
            this.isTreeInitialized = false;
        } else {
            this.refreshTree((GroupTreeNode)root);
            this.isSearchRefreshed = false;
        }
    }

    private void refreshSearchUsers() {
        SearchFilter searchFilter = this.userContext.getSearchFilter();
        String searchValue = null;
        int filterSize = 0;
        if (this.userNamePatternField.getText().length() > 0) {
            searchFilter.setSearchAttribute("user.name", searchValue, (searchValue = this.userNamePatternField.getText()).indexOf("*") == -1 ? 0 : 1);
            filterSize = (byte)(filterSize + 1);
        }
        if (this.userNamePatternField.isEditable()) {
            this.list.setListData(this.usersListData, null);
            this.searchBtn.setEnabled(true);
            return;
        }
        if (filterSize == 0) {
            searchFilter.setSearchAttribute("user.name", "*", 1);
            filterSize = (byte)(filterSize + 1);
        }
        if (this.checkLockedUsers.isSelected()) {
            searchFilter.setSearchAttribute("user.locked", "true", -1);
        }
        int searchResultSize = -1;
        try {
            searchResultSize = new Integer(this.userMaxCountField.getText());
        }
        catch (NumberFormatException _) {
            // empty catch block
        }
        searchFilter.setMaxSearchResultSize(searchResultSize);
        try {
            RemoteIterator resultIterator = this.userContext.searchUsers(searchFilter);
            this.usersListData = new ArrayList();
            while (resultIterator.hasNext()) {
                this.usersListData.add(resultIterator.next());
            }
            this.list.setListData(this.usersListData, null);
            this.userSearchState = resultIterator.getState();
            this.setsearchState(this.userSearchState);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
    }

    private void refreshSearchGroups() {
        if (this.groupContext != null) {
            SearchFilter searchFilter = this.groupContext.getSearchFilter();
            String searchValue = null;
            int filterSize = 0;
            if (this.groupNamePatternField.getText().length() > 0) {
                searchFilter.setSearchAttribute("group.name", searchValue, (searchValue = this.groupNamePatternField.getText()).indexOf("*") == -1 ? 0 : 1);
                filterSize = (byte)(filterSize + 1);
            }
            if (this.groupChildgroupPatternField.getText().length() > 0) {
                searchFilter.setSearchAttribute("group.childgroup", searchValue, (searchValue = this.groupChildgroupPatternField.getText()).indexOf("*") == -1 ? 0 : 1);
                filterSize = (byte)(filterSize + 1);
            }
            if (this.groupChilduserPatternField.getText().length() > 0) {
                searchFilter.setSearchAttribute("group.childuser", searchValue, (searchValue = this.groupChilduserPatternField.getText()).indexOf("*") == -1 ? 0 : 1);
                filterSize = (byte)(filterSize + 1);
            }
            if (this.groupNamePatternField.isEditable()) {
                this.list.setListData(this.groupsListData, null);
                this.searchBtn.setEnabled(true);
                return;
            }
            if (filterSize == 0) {
                searchFilter.setSearchAttribute("group.name", "*", 1);
                filterSize = (byte)(filterSize + 1);
            }
            int searchResultSize = -1;
            try {
                searchResultSize = new Integer(this.groupMaxCountField.getText());
            }
            catch (NumberFormatException _) {
                // empty catch block
            }
            searchFilter.setMaxSearchResultSize(searchResultSize);
            try {
                RemoteIterator resultIterator = this.groupContext.searchGroups(searchFilter);
                this.groupsListData = new ArrayList();
                while (resultIterator.hasNext()) {
                    this.groupsListData.add(resultIterator.next());
                }
                this.list.setListData(this.groupsListData, null);
                this.groupSearchState = resultIterator.getState();
                this.setsearchState(this.groupSearchState);
            }
            catch (RemoteException re) {
                re.printStackTrace();
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        block11: {
            if (this.tabbedPane.getSelectedComponent() == this.searchComponent) {
                try {
                    this.tree.clearSelection();
                    if (this.isSearchRefreshed) {
                        if (this.searchTabbedPane.getSelectedIndex() == 0) {
                            this.list.setListData(this.usersListData, null);
                            this.setsearchState(this.userSearchState);
                            this.searchBtn.setEnabled(this.userNamePatternField.isEditable());
                        } else {
                            this.list.setListData(this.groupsListData, null);
                            this.setsearchState(this.groupSearchState);
                            this.searchBtn.setEnabled(this.groupNamePatternField.isEditable());
                        }
                        break block11;
                    }
                    if (this.searchTabbedPane.getSelectedIndex() == 0) {
                        this.refreshSearchUsers();
                    } else {
                        this.refreshSearchGroups();
                    }
                    this.isSearchRefreshed = true;
                }
                catch (Exception exception) {
                    if (!this.isInitializing) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(this, "Errors prevent Search panel from operating. See logs!", "Search Panel:", 0);
                    }
                    this.tabbedPane.setSelectedIndex(1);
                }
            } else {
                this.list.clearSelection();
                if (!this.isTreeInitialized) {
                    this.refreshTree();
                    this.isTreeInitialized = true;
                }
            }
        }
    }

    public void setInitialized(boolean initialized) {
        try {
            this.isInitializing = true;
            this.isTreeInitialized = initialized;
            this.tabbedPane.setSelectedComponent(this.searchComponent);
            this.searchTabbedPane.setSelectedIndex(1);
            this.resetAction();
            this.searchTabbedPane.setSelectedIndex(0);
            this.resetAction();
            Object var3_2 = null;
            this.isInitializing = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.isInitializing = false;
            throw throwable;
        }
    }

    private void setsearchState(int state) {
        switch (state) {
            case 0: {
                this.searchStateBar.setText("SEARCH_RESULT_OK");
                this.searchStateBar.setToolTipText("<html><font size=3>The search was done successfully<br>and the search result contains all<br>and only all matching objects.</html>");
                break;
            }
            case 1: {
                this.searchStateBar.setText("SEARCH_RESULT_INCOMPLETE");
                this.searchStateBar.setToolTipText("<html><font size=3>The search result is not complete because of an error<br>during execution of the search request. Some matching<br>objects will therefore not be part of the search result,<br>but the result does not contain any non-matching objects.</html>");
                break;
            }
            case 2: {
                this.searchStateBar.setText("SEARCH_RESULT_UNDEFINED");
                this.searchStateBar.setToolTipText("<html><font size=3>The search result is undefined because<br>it contains objects, which do not correctly<br>match the search criteria.</html>");
                break;
            }
            case 4: {
                this.searchStateBar.setText("SIZE_LIMIT_EXCEEDED");
                this.searchStateBar.setToolTipText("<html><font size=3>A size limit exceeded. All objects in the search result<br>match the search criteria, but not all matching objects are<br>returned. The size limit may have been defined either in the search<br>request (client) or in the persistency layer itself (server).</html>");
                break;
            }
            case 8: {
                this.searchStateBar.setText("TIME_LIMIT_EXCEEDED");
                this.searchStateBar.setToolTipText("<html><font size=3>A time limit exceeded. All objects in the search result<br>match the search criteria, but not all matching objects are<br>returned. The time limit may have been defined either in the search<br>request (client) or in the persistency layer itself (server).</html>");
                break;
            }
            default: {
                this.searchStateBar.setText(" ");
                this.searchStateBar.setToolTipText("The state of the search result will be displayed here.");
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (e.getSource() == this.userNamePatternField || e.getSource() == this.userMaxCountField) {
                this.searchUsersAction();
            } else if (e.getSource() == this.groupNamePatternField || e.getSource() == this.groupChildgroupPatternField || e.getSource() == this.groupChilduserPatternField || e.getSource() == this.groupMaxCountField) {
                this.searchGroupsAction();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

