/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.UserStoreControl;
import com.sap.engine.services.security.gui.userstore.usermanagement.ActionControl;
import com.sap.engine.services.security.gui.userstore.usermanagement.GroupAction;
import com.sap.engine.services.security.gui.userstore.usermanagement.ManageStoresAction;
import com.sap.engine.services.security.gui.userstore.usermanagement.NewGroupAction;
import com.sap.engine.services.security.gui.userstore.usermanagement.NewUserAction;
import com.sap.engine.services.security.gui.userstore.usermanagement.PasswordFilterAction;
import com.sap.engine.services.security.gui.userstore.usermanagement.RefreshAction;
import com.sap.engine.services.security.gui.userstore.usermanagement.RemoveAction;
import com.sap.engine.services.security.gui.userstore.usermanagement.UMHash;
import com.sap.engine.services.security.gui.userstore.usermanagement.UngroupAction;
import com.sap.engine.services.security.gui.userstore.usermanagement.UserPropertiesPanel;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.GroupTreeNode;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.UserTreePanel;
import com.sap.engine.services.security.remote.RemoteGroupContext;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteUserContext;
import com.sap.engine.services.security.remote.RemoteUserStore;
import com.sap.engine.services.security.remote.RemoteUserStoreFactory;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class UsersControlPanel
extends JPanel
implements TreeSelectionListener,
ListSelectionListener {
    private UserStoreControl control = null;
    private RemoteUserStoreFactory factory = null;
    public static RemoteUserStore userStore = null;
    public static RemoteUserContext userContext = null;
    public static RemoteGroupContext groupContext = null;
    private GroupAction groupAction = null;
    private ManageStoresAction manageStoresAction = null;
    private NewGroupAction newGroupAction = null;
    private NewUserAction newUserAction = null;
    private PasswordFilterAction passwordFilterAction = null;
    private RefreshAction refreshAction = null;
    private RemoveAction removeAction = null;
    private UngroupAction ungroupAction = null;
    Frame frame = null;
    private UserTreePanel tree = null;
    public static String selectedStore = null;
    public Vector actionControls = new Vector();

    public UsersControlPanel(UserStoreControl control) {
        this.control = control;
    }

    public UserStoreControl getControl() {
        return this.control;
    }

    public void prepare() {
        try {
            if (this.control.getSelectedStore() != null && this.factory != null) {
                userStore = this.factory.getUserStore(this.control.getSelectedStore());
                userContext = userStore.getUserContext();
                groupContext = userStore.getGroupContext();
            }
            this.frame = this.control.getFrame();
            JPanel userControl = new JPanel();
            userControl.setLayout(new BorderLayout());
            this.groupAction = new GroupAction(this);
            this.actionControls.addElement(this.groupAction);
            this.manageStoresAction = new ManageStoresAction(this);
            this.actionControls.addElement(this.manageStoresAction);
            this.newGroupAction = new NewGroupAction(this);
            this.actionControls.addElement(this.newGroupAction);
            this.newUserAction = new NewUserAction(this);
            this.actionControls.addElement(this.newUserAction);
            this.passwordFilterAction = new PasswordFilterAction(this);
            this.actionControls.addElement(this.passwordFilterAction);
            this.refreshAction = new RefreshAction(this);
            this.actionControls.addElement(this.refreshAction);
            this.removeAction = new RemoveAction(this);
            this.actionControls.addElement(this.removeAction);
            this.ungroupAction = new UngroupAction(this);
            this.actionControls.addElement(this.ungroupAction);
            JPanel pane = new JPanel(new GridBagLayout());
            pane.add((Component)this.newUserAction.getButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.newGroupAction.getButton(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.removeAction.getButton(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.ungroupAction.getButton(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.groupAction.getButton(), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.passwordFilterAction.getButton(), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.refreshAction.getButton(), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.1, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.manageStoresAction.getButton(), new GridBagConstraints(0, 8, 1, 1, 0.0, 0.1, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
            userControl.add((Component)pane, "East");
            UserPropertiesPanel na = new UserPropertiesPanel(this);
            userControl.add((Component)na, "Center");
            this.tree = new UserTreePanel();
            this.tree.setFrame(this.frame);
            this.tree.addTreeSelectionListener(this);
            this.tree.addListSelectionListener(this);
            if (userContext != null) {
                try {
                    this.tree.init(userContext, groupContext);
                }
                catch (RemoteException re) {
                    ExceptionHandler.error("Unable to initialize user tree!", re);
                }
            }
            JSplitPane splitPane = new JSplitPane(1);
            splitPane.setLeftComponent(this.tree);
            splitPane.setRightComponent(userControl);
            splitPane.setOneTouchExpandable(true);
            splitPane.setDividerLocation(200);
            this.setLayout(new BorderLayout());
            this.add((Component)splitPane, "Center");
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to set up user control panel!", e);
        }
    }

    public void show(RemoteUserStoreFactory factory) {
        this.factory = factory;
        this.onSelectedStoreChanged();
    }

    public void onSelectedStoreChanged() {
        block5: {
            try {
                if (this.control.getSelectedStore() == null) break block5;
                selectedStore = this.control.getSelectedStore();
                userStore = this.factory.getUserStore(selectedStore);
                userContext = userStore.getUserContext();
                groupContext = userStore.getGroupContext();
                GroupTreeNode root = UMHash.getRoot(selectedStore);
                try {
                    this.tree.init(userContext, groupContext);
                }
                catch (RemoteException re) {
                    ExceptionHandler.error("Unable to set up user control for the selected user store!", re);
                }
                this.tree.setInitialized(false);
                this.tree.refresh(root);
                if (root == null) {
                    root = this.tree.getRoot();
                    UMHash.addRoot(selectedStore, root);
                }
                this.newGroupAction.onSelectionChange(root);
                this.groupAction.onSelectionChange(root);
                this.ungroupAction.onSelectionChange(root);
            }
            catch (Exception e) {
                ExceptionHandler.error("Unable to set up user control for the selected user store!", e);
            }
        }
    }

    public void refreshUsersTree() {
        this.tree.refresh(null);
        UMHash.addRoot(selectedStore, this.tree.getRoot());
    }

    public String getSelectedUser() {
        try {
            if (this.tree.getSelectedUser() != null) {
                if (this.tree.getSelectedUser() instanceof RemoteUserStoreInfo) {
                    return ((RemoteUserStoreInfo)this.tree.getSelectedUser()).getName();
                }
                if (this.tree.getSelectedUser() instanceof RemoteGroupInfo) {
                    return ((RemoteGroupInfo)this.tree.getSelectedUser()).getName();
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            ExceptionHandler.debug("Unable to get selected user from user tree panel!", e);
            return null;
        }
    }

    public boolean hasSelectedUserParent() {
        return this.tree.hasSelectedUserParent();
    }

    public String getSelectedUserParent() {
        try {
            if (this.tree.hasSelectedUserParent()) {
                return this.tree.getSelectedUserParent().getName();
            }
            return null;
        }
        catch (Exception e) {
            ExceptionHandler.debug("Unable to get selected user parent from user tree panel!", e);
            return null;
        }
    }

    public boolean isUserSelected() {
        if (this.tree.getSelectedUser() != null) {
            return this.tree.getSelectedUser() instanceof RemoteUserStoreInfo;
        }
        return false;
    }

    public void valueChanged(TreeSelectionEvent e) {
        GroupTreeNode root = UMHash.getRoot(selectedStore);
        int i = 0;
        while (i < this.actionControls.size()) {
            ((ActionControl)this.actionControls.elementAt(i)).onSelectionChange(root);
            ++i;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int i = 0;
            while (i < this.actionControls.size()) {
                ((ActionControl)this.actionControls.elementAt(i)).onSelectionChange("");
                ++i;
            }
        }
    }

    public RemoteUserStoreFactory getRuntimeInterface() {
        return this.factory;
    }

    public void addActionControl(ActionControl control) {
        this.actionControls.addElement(control);
    }
}

