/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.gui.CScrollField;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.usermanagement.CertificatesDialog;
import com.sap.engine.services.security.gui.userstore.usermanagement.ConfirmPasswordDialog;
import com.sap.engine.services.security.gui.userstore.usermanagement.UsersControlPanel;
import com.sap.engine.services.security.gui.userstore.usermanagement.ViewProfileAction;
import com.sap.engine.services.security.gui.util.SortedList;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteIterator;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class UserPropertiesPanel
extends JPanel
implements AdjustmentListener,
FocusListener,
KeyListener,
ActionListener,
ListSelectionListener {
    private static final String ADD_COMMAND = "ADD_COMMAND";
    private static final String REMOVE_COMMAND = "REMOVE_COMMAND";
    private static final String VIEW_COMMAND = "VIEW_COMMAND";
    private static final String LOCK_COMMAND = "LOCK_COMMAND";
    private static final String PASS_CHANGE_COMMAND = "REQUIRE_PASS_CHANGE";
    private static final String CHANGE_COMMAND = "CHANGE_COMMAND";
    static final String STATUS_LOCK = "Lock";
    static final String STATUS_UNLOCK = "Unlock";
    static final String STATUS_NONE = "Lock/Unlock";
    static final String DEFAULT_LOCK_REASON = "Locked by the Administrator.";
    private JLabel accountName = new JLabel("");
    private JLabel createDate = new JLabel("");
    private JLabel modifyDate = new JLabel("");
    private JLabel failedLogonCount = new JLabel("");
    private JLabel failedLogonDate = new JLabel("");
    private JLabel successLogonCount = new JLabel("");
    private JLabel successLogonDate = new JLabel("");
    private JLabel validFromDate = new JLabel("");
    private JLabel validToDate = new JLabel("");
    private JLabel lastChangePassDate = new JLabel("");
    private JPasswordField passwordField = new JPasswordField(20);
    private JButton changePassBtn = new JButton("Change");
    private JCheckBox passwordChangeRequired = new JCheckBox();
    private JPanel passwordChangeCard = null;
    private CScrollField nextPassChangeField = new CScrollField();
    private JPanel certificatesPanel = new JPanel(new GridBagLayout());
    private JList entriesList = new JList();
    private JScrollPane entriesScrollField = new JScrollPane();
    private JButton addButton = new JButton("Add");
    private JButton removeButton = new JButton("Remove");
    private JButton viewButton = new JButton("View");
    private JLabel lockStatus = new JLabel("Lock Status: ");
    private JLabel lockReason = new JLabel("");
    JButton lockButton = new JButton("Lock/Unlock");
    private SortedList userParentsList = new SortedList();
    private SortedList groupParentsList = new SortedList();
    private boolean editting = true;
    private boolean dateIsChanged = false;
    private boolean passwordIsChanged = false;
    private UsersControlPanel control = null;

    public UserPropertiesPanel(UsersControlPanel control) {
        this.control = control;
        this.setLayout(new CardLayout());
        this.passwordField.addKeyListener(this);
        this.passwordField.addFocusListener(this);
        this.passwordChangeRequired.addActionListener(this);
        this.passwordChangeRequired.setActionCommand(PASS_CHANGE_COMMAND);
        this.nextPassChangeField.addKeyListener(this);
        this.nextPassChangeField.addFocusListener(this);
        this.nextPassChangeField.setMinimumValue(0);
        this.nextPassChangeField.setMaximumValue(10950);
        this.nextPassChangeField.addAdjustmentListener(this);
        this.nextPassChangeField.setPreferredSize(new Dimension(100, 10));
        this.addButton.setActionCommand(ADD_COMMAND);
        this.addButton.addActionListener(this);
        this.removeButton.setActionCommand(REMOVE_COMMAND);
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.viewButton.setActionCommand(VIEW_COMMAND);
        this.viewButton.addActionListener(this);
        this.viewButton.setEnabled(false);
        this.lockButton.setActionCommand(LOCK_COMMAND);
        this.lockButton.addActionListener(this);
        this.lockButton.setEnabled(false);
        JPanel noneAccount = new JPanel();
        noneAccount.setBorder(BorderFactory.createEtchedBorder());
        JPanel groupAccount = new JPanel(new GridBagLayout());
        groupAccount.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Parent Groups "));
        this.groupParentsList.setEnabled(false);
        JScrollPane groupParentsScroll = new JScrollPane(this.groupParentsList);
        groupAccount.add((Component)groupParentsScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel userAccount = new JPanel(new GridBagLayout());
        JPanel accountPanel = new JPanel(new GridBagLayout());
        accountPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Account "));
        accountPanel.add((Component)new JLabel("Account: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        accountPanel.add((Component)this.accountName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.1, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        accountPanel.add((Component)new JLabel("Created On: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        accountPanel.add((Component)this.createDate, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        accountPanel.add((Component)new JLabel("Last Modified: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        accountPanel.add((Component)this.modifyDate, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        accountPanel.add((Component)new JLabel("Valid From: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        accountPanel.add((Component)this.validFromDate, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        accountPanel.add((Component)new JLabel("Valid To: "), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        accountPanel.add((Component)this.validToDate, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        accountPanel.add((Component)this.lockStatus, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        accountPanel.add((Component)this.lockReason, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.1, 10, 1, new Insets(5, 5, 0, 0), 0, 0));
        accountPanel.add((Component)this.lockButton, new GridBagConstraints(2, 5, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.lockButton.setToolTipText(this.lockButton.getText() + " User");
        JPanel userParentsPanel = new JPanel(new GridBagLayout());
        userParentsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Parent Groups "));
        this.userParentsList.setEnabled(false);
        this.userParentsList.setVisibleRowCount(5);
        JScrollPane userParentsScroll = new JScrollPane(this.userParentsList);
        userParentsPanel.add((Component)userParentsScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.certificatesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Certificates "));
        this.entriesList.addListSelectionListener(this);
        this.entriesList.setVisibleRowCount(3);
        this.entriesScrollField.getViewport().add((Component)this.entriesList, "Center");
        this.certificatesPanel.add((Component)this.entriesScrollField, new GridBagConstraints(0, 0, 1, 3, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.certificatesPanel.add((Component)this.addButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.1, 13, 1, new Insets(0, 5, 0, 0), 0, 0));
        this.certificatesPanel.add((Component)this.removeButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.1, 13, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.certificatesPanel.add((Component)this.viewButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.1, 13, 1, new Insets(5, 5, 0, 0), 0, 0));
        JPanel passwordChangeCheck = new JPanel(new GridBagLayout());
        passwordChangeCheck.add((Component)this.passwordChangeRequired, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        passwordChangeCheck.add((Component)new JLabel("No password change required"), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel passwordChangePanel = new JPanel(new GridBagLayout());
        passwordChangePanel.add((Component)new JLabel("  Change Password Every   "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        passwordChangePanel.add((Component)this.nextPassChangeField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        passwordChangePanel.add((Component)new JLabel("   Days.  "), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.1, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.passwordChangeCard = new JPanel();
        this.passwordChangeCard.setLayout(new CardLayout());
        this.passwordChangeCard.add((Component)passwordChangePanel, "false");
        this.passwordChangeCard.add((Component)new JLabel(""), "true");
        this.passwordChangeRequired.setSelected(false);
        ((CardLayout)this.passwordChangeCard.getLayout()).show(this.passwordChangeCard, "false");
        this.passwordField.setPreferredSize(new Dimension(this.passwordField.getPreferredSize().width, this.changePassBtn.getPreferredSize().height));
        this.changePassBtn.addActionListener(this);
        this.changePassBtn.setActionCommand(CHANGE_COMMAND);
        this.changePassBtn.setEnabled(this.passwordIsChanged);
        JPanel authenticationPanel = new JPanel(new GridBagLayout());
        authenticationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Authentication "));
        authenticationPanel.add((Component)new JLabel("Change Password: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        authenticationPanel.add((Component)this.passwordField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        authenticationPanel.add((Component)this.changePassBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.1, 13, 2, new Insets(0, 5, 0, 0), 0, 0));
        authenticationPanel.add((Component)new JLabel("Last Changed: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        authenticationPanel.add((Component)this.lastChangePassDate, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        authenticationPanel.add((Component)passwordChangeCheck, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.1, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        authenticationPanel.add((Component)this.passwordChangeCard, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.1, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        authenticationPanel.add((Component)this.certificatesPanel, new GridBagConstraints(0, 4, 3, 1, 0.1, 0.1, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        JPanel activityPanel = new JPanel(new GridBagLayout());
        activityPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Activity Statistics "));
        activityPanel.add((Component)new JLabel("Successful Logon Count: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        activityPanel.add((Component)this.successLogonCount, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 17, 1, new Insets(0, 5, 0, 0), 0, 0));
        activityPanel.add((Component)new JLabel("Last Logon On: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        activityPanel.add((Component)this.successLogonDate, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        activityPanel.add((Component)new JLabel("Failed Logon Count: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        activityPanel.add((Component)this.failedLogonCount, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        activityPanel.add((Component)new JLabel("Last Logon On: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        activityPanel.add((Component)this.failedLogonDate, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.1, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        ViewProfileAction viewProfile = new ViewProfileAction(control, this);
        control.addActionControl(viewProfile);
        userAccount.add((Component)accountPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        userAccount.add((Component)userParentsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        userAccount.add((Component)authenticationPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        userAccount.add((Component)activityPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)userAccount, "USER");
        this.add((Component)groupAccount, "GROUP");
        this.add((Component)noneAccount, "NONE");
        ((CardLayout)this.getLayout()).show(this, "NONE");
        this.editting = false;
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.dateIsChanged = true;
        this.changeForce(this.nextPassChangeField.getValue(), false);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.passwordField) {
            try {
                this.changePassword(this.passwordField.getPassword());
                Object var3_2 = null;
                this.refreshUserProperties();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.refreshUserProperties();
                throw throwable;
            }
        }
        if (e.getSource() == this.nextPassChangeField) {
            try {
                this.changeForce(this.nextPassChangeField.getValue(), true);
                Object var5_5 = null;
                this.refreshUserProperties();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.refreshUserProperties();
                throw throwable;
            }
        }
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            try {
                if (e.getSource() == this.passwordField) {
                    this.changePassword(this.passwordField.getPassword());
                } else if (e.getSource() == this.nextPassChangeField) {
                    this.changeForce(this.nextPassChangeField.getValue(), true);
                }
                Object var3_2 = null;
                this.refreshUserProperties();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.refreshUserProperties();
                throw throwable;
            }
        } else if (e.getSource() == this.passwordField) {
            this.passwordIsChanged = true;
            this.changePassBtn.setEnabled(this.passwordIsChanged);
        } else if (e.getSource() == this.nextPassChangeField) {
            this.dateIsChanged = true;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        try {
            block16: {
                String command = e.getActionCommand();
                if (command.equals(ADD_COMMAND)) {
                    this.addAction();
                } else if (command.equals(REMOVE_COMMAND)) {
                    this.removeAction();
                } else if (command.equals(VIEW_COMMAND)) {
                    this.viewAction();
                } else if (command.equals(LOCK_COMMAND)) {
                    this.lockAction();
                } else if (command.equals(PASS_CHANGE_COMMAND)) {
                    boolean noPassChange = this.passwordChangeRequired.isSelected();
                    ((CardLayout)this.passwordChangeCard.getLayout()).show(this.passwordChangeCard, "" + noPassChange);
                    try {
                        RemoteUserStoreInfo userInfo = UsersControlPanel.userContext.getUserInfo(this.accountName.getText());
                        if (noPassChange) {
                            userInfo.writeUserProperty(11, new Long(Long.MAX_VALUE));
                            break block16;
                        }
                        this.nextPassChangeField.setValue(3650);
                    }
                    catch (Exception ex) {
                        this.viewPassChangeCheckBox(true);
                        ExceptionHandler.error("Unable to set up user properties panel!", ex);
                    }
                } else if (command.equals(CHANGE_COMMAND)) {
                    this.changePassword(this.passwordField.getPassword());
                }
            }
            Object var6_6 = null;
            this.refreshUserProperties();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.refreshUserProperties();
            throw throwable;
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.entriesList)) {
            if (this.entriesList.getSelectedValue() != null) {
                this.removeButton.setEnabled(true);
                this.viewButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
                this.viewButton.setEnabled(false);
            }
        }
    }

    public void clearLabelValues() {
        ((CardLayout)this.getLayout()).show(this, "NONE");
        try {
            this.editting = true;
            this.createDate.setText("");
            this.modifyDate.setText("");
            this.failedLogonCount.setText("");
            this.failedLogonDate.setText("");
            this.successLogonCount.setText("");
            this.successLogonDate.setText("");
            this.validFromDate.setText("");
            this.validToDate.setText("");
            this.lastChangePassDate.setText("");
            ((JTextComponent)this.passwordField).setText("");
            this.nextPassChangeField.setValue(0);
            this.viewPassChangeCheckBox(false);
            this.userParentsList.setListData(new Object[0]);
            this.groupParentsList.setListData(new Object[0]);
            Object var2_1 = null;
            this.editting = false;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.editting = false;
            throw throwable;
        }
    }

    protected void setProperty(int id, String text) {
        this.editting = true;
        try {
            switch (id) {
                case 0: {
                    this.accountName.setText(text);
                    break;
                }
                case 1: {
                    this.createDate.setText(text);
                    break;
                }
                case 2: {
                    this.modifyDate.setText(text);
                    break;
                }
                case 3: {
                    this.failedLogonCount.setText(text);
                    break;
                }
                case 4: {
                    this.failedLogonDate.setText(text);
                    break;
                }
                case 5: {
                    this.successLogonCount.setText(text);
                    break;
                }
                case 6: {
                    this.successLogonDate.setText(text);
                    break;
                }
                case 7: {
                    this.validFromDate.setText(text);
                    break;
                }
                case 8: {
                    this.validToDate.setText(text);
                    break;
                }
                case 9: {
                    if (text == null) break;
                    this.lastChangePassDate.setText(text);
                    break;
                }
                case 10: {
                    long value;
                    try {
                        value = new Long(text);
                    }
                    catch (NumberFormatException nfe) {
                        value = 0L;
                    }
                    if (value < 0L) {
                        value = 0L;
                    }
                    if (value != Long.MAX_VALUE) {
                        this.nextPassChangeField.setValue((int)(value / 86400000L));
                        this.viewPassChangeCheckBox(false);
                        break;
                    }
                    this.viewPassChangeCheckBox(true);
                    break;
                }
                case 11: {
                    this.lockReason.setText(text);
                }
            }
            ((CardLayout)this.getLayout()).show(this, "USER");
            Object var7_5 = null;
            this.editting = false;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.editting = false;
            throw throwable;
        }
    }

    protected void initGroups(Object selectedNode) throws Exception {
        if (selectedNode instanceof RemoteUserStoreInfo) {
            this.userParentsList.setListData(this.getListData(((RemoteUserStoreInfo)selectedNode).getParentGroups()), null);
        } else {
            this.groupParentsList.setListData(this.getListData(((RemoteGroupInfo)selectedNode).getParentGroups()), null);
            ((CardLayout)this.getLayout()).show(this, "GROUP");
        }
    }

    private ArrayList getListData(RemoteIterator iterator) {
        ArrayList list = new ArrayList();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private void refreshUserProperties() {
        new ViewProfileAction(this.control, this).onSelectionChange(null);
    }

    private void viewPassChangeCheckBox(boolean flag) {
        this.passwordChangeRequired.setSelected(flag);
        ((CardLayout)this.passwordChangeCard.getLayout()).show(this.passwordChangeCard, "" + flag);
    }

    private void changePassword(char[] password) {
        if (this.passwordIsChanged) {
            this.passwordIsChanged = false;
            this.changePassBtn.setEnabled(this.passwordIsChanged);
            ConfirmPasswordDialog dialog = new ConfirmPasswordDialog(this.control.frame);
            dialog.setLocationRelativeTo(this.control.frame);
            ((Component)dialog).setVisible(true);
            char[] confirmedPassword = dialog.getPassword();
            if (confirmedPassword != null && this.equalArrays(confirmedPassword, password)) {
                try {
                    RemoteUserStoreInfo userInfo = UsersControlPanel.userContext.getUserInfo(this.accountName.getText());
                    userInfo.writeUserProperty(9, password);
                    JOptionPane.showMessageDialog(this.control.frame, "Password successfully changed.", "Successful change", 1);
                }
                catch (Exception e) {
                    ExceptionHandler.error("Unable to change password!", e);
                }
            } else {
                JOptionPane.showMessageDialog(this.control.frame, "Two passwords differ!", "Password change is unsuccessful!", 0);
            }
            ((JTextComponent)this.passwordField).setText("");
        }
    }

    private void changeForce(long value, boolean notifyOnSuccess) {
        if (this.dateIsChanged && !this.editting && this.nextPassChangeField.getValue() >= 0) {
            this.dateIsChanged = false;
            try {
                block5: {
                    try {
                        this.editting = true;
                        RemoteUserStoreInfo userInfo = UsersControlPanel.userContext.getUserInfo(this.accountName.getText());
                        userInfo.writeUserProperty(11, new Long(value * 24L * 60L * 60L * 1000L));
                        if (!notifyOnSuccess) break block5;
                        JOptionPane.showMessageDialog(this.control.frame, "User has to change password every " + value + " days.", "Successful change", 1);
                    }
                    catch (Exception e) {
                        this.nextPassChangeField.setValue(0);
                        ExceptionHandler.error("Unable to force password change!", e);
                        Object var6_6 = null;
                        this.editting = false;
                    }
                }
                Object var6_5 = null;
                this.editting = false;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.editting = false;
                throw throwable;
            }
        }
    }

    private void lockAction() {
        String status = this.lockButton.getText();
        try {
            RemoteUserStoreInfo info = UsersControlPanel.userContext.getUserInfo(this.accountName.getText());
            if (status.equals(STATUS_LOCK)) {
                info.writeUserProperty(12, new Integer(2));
                this.lockReason.setText(this.getLockReason(2));
                this.lockButton.setText(STATUS_UNLOCK);
            } else {
                info.writeUserProperty(12, new Integer(0));
                this.lockReason.setText(this.getLockReason(0));
                this.lockButton.setText(STATUS_LOCK);
                this.setProperty(3, info.readUserProperty(3).toString());
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to " + status.toLowerCase() + " user!", e);
        }
    }

    String getLockReason(int lockStatus) {
        switch (lockStatus) {
            case 0: {
                return "Unlocked";
            }
            case 1: {
                return "Locked automaticly after " + UsersControlPanel.userContext.getLockAfterInvalidAttempts() + " invalid login attempts.";
            }
            case 2: {
                return DEFAULT_LOCK_REASON;
            }
        }
        return "not supported";
    }

    private void addAction() {
        CertificatesDialog dialog = null;
        try {
            dialog = new CertificatesDialog(this.control.frame, "Add Certificates");
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to view certificates!", e);
            return;
        }
        try {
            dialog.setLocationRelativeTo(this.control.frame);
            if (dialog.isConfirmed()) {
                X509Certificate[] certificates = dialog.getCertificates();
                RemoteUserStoreInfo info = UsersControlPanel.userContext.getUserInfo(this.accountName.getText());
                X509Certificate[] certs = info.getCertificates();
                int count = 0;
                if (certificates != null && certificates.length > 0) {
                    int i = 0;
                    while (i < certificates.length) {
                        int j = 0;
                        while (j < certs.length) {
                            if (certificates[i].equals(certs[j])) {
                                certificates[i] = null;
                                ++count;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                X509Certificate[] newCerts = new X509Certificate[certs.length + certificates.length - count];
                System.arraycopy(certs, 0, newCerts, 0, certs.length);
                int i = 0;
                int j = 0;
                while (i < certificates.length) {
                    if (certificates[i] != null) {
                        newCerts[certs.length + j] = certificates[i];
                        ++j;
                    }
                    ++i;
                }
                info.setCertificates(newCerts);
                this.setListData(info);
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to add certificates!", e);
        }
    }

    private void removeAction() {
        Object commonName = this.entriesList.getSelectedValue();
        if (commonName != null) {
            try {
                RemoteUserStoreInfo userInfo = UsersControlPanel.userContext.getUserInfo(this.accountName.getText());
                X509Certificate[] certificates = userInfo.getCertificates();
                X509Certificate[] newCerts = null;
                int j = 0;
                while (j < certificates.length) {
                    if (certificates[j] != null && commonName.equals(certificates[j].getSubjectDN().getName())) {
                        newCerts = new X509Certificate[certificates.length - 1];
                        System.arraycopy(certificates, 0, newCerts, 0, j);
                        System.arraycopy(certificates, j + 1, newCerts, j, newCerts.length - j);
                        break;
                    }
                    ++j;
                }
                userInfo.setCertificates(newCerts);
                this.setListData(userInfo);
            }
            catch (Exception e) {
                ExceptionHandler.error("Unable to remove certificates!", e);
            }
        }
    }

    private void viewAction() {
        Object commonName = this.entriesList.getSelectedValue();
        if (commonName != null) {
            try {
                RemoteUserStoreInfo userInfo = UsersControlPanel.userContext.getUserInfo(this.accountName.getText());
                X509Certificate[] certificates = userInfo.getCertificates();
                int j = 0;
                while (j < certificates.length) {
                    if (certificates[j] != null && commonName.equals(certificates[j].getSubjectDN().getName())) {
                        JDialog dialog = new JDialog(this.control.frame, "Certificate", true);
                        ((Component)dialog).setSize(500, 300);
                        dialog.setLocationRelativeTo(this.control.frame);
                        JTextArea textArea = new JTextArea(this.getCertificateInfo(certificates[j]));
                        dialog.getContentPane().add(new JScrollPane(textArea));
                        ((Component)dialog).setVisible(true);
                        break;
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                ExceptionHandler.error("Unable to remove certificates!", e);
            }
        }
    }

    public void initCertificates() {
        try {
            RemoteUserStoreInfo userInfo = UsersControlPanel.userContext.getUserInfo(this.accountName.getText());
            this.setListData(userInfo);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to initialize certificates!", e);
        }
    }

    private void setListData(RemoteUserStoreInfo userInfo) throws Exception {
        this.removeButton.setEnabled(false);
        this.viewButton.setEnabled(false);
        this.removeButton.repaint();
        this.viewButton.repaint();
        X509Certificate[] result = userInfo.getCertificates();
        String[] names = new String[result.length];
        int i = 0;
        while (i < result.length) {
            names[i] = result[i].getSubjectDN().getName();
            ++i;
        }
        this.entriesList.setListData(names);
    }

    private String getCertificateInfo(X509Certificate xcert) throws Exception {
        String result = "";
        String offset = "      ";
        try {
            result = result + "CERTIFICATE";
            result = result + "\n" + offset + "[ DN ]: " + xcert.getSubjectDN();
            result = result + "\n" + offset + "[ issuerDN ]: " + xcert.getIssuerDN();
            result = result + "\n" + offset + "[ validNotBefore ]: " + xcert.getNotBefore();
            result = result + "\n" + offset + "[ validNotAfter ]: " + xcert.getNotAfter();
            result = result + "\n" + offset + "[ signAlgorithm ]: " + xcert.getSigAlgName();
            try {
                Method getFingerPrintMethod = xcert.getClass().getMethod("getFingerprint", new Class[0]);
                byte[] fingerprint = (byte[])getFingerPrintMethod.invoke((Object)xcert, new Object[0]);
                result = result + "\n" + offset + "[ fingerprint ]: " + UserPropertiesPanel.stringValue(fingerprint);
            }
            catch (Exception e) {
                ExceptionHandler.debug("No fingerprint available for certificate!", e);
                result = result + "\n" + offset + "[ fingerprint ]: N/A";
            }
            result = result + "\n" + offset + "[ publicKey ]: " + this.getKeyInfo(offset + offset, xcert.getPublicKey());
        }
        catch (Exception e) {
            return e.toString();
        }
        return result;
    }

    private static String stringValue(byte[] byteArray) {
        return UserPropertiesPanel.stringValue(byteArray, 0, byteArray.length, ":");
    }

    private static String stringValue(byte[] byteArray, int off, int len, String delimiter) {
        if (byteArray.length < off + len) {
            len = byteArray.length - off;
        }
        StringBuffer sb = new StringBuffer(2 * len);
        boolean first = true;
        int i = 0;
        while (i < len) {
            if (first) {
                first = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(UserPropertiesPanel.stringValue(byteArray[off + i]));
            ++i;
        }
        return sb.toString();
    }

    private static String stringValue(byte b) {
        StringBuffer sb = new StringBuffer(2);
        int h = (b & 0xF0) >> 4;
        int l = b & 0xF;
        sb.append(new Character(h > 9 ? (char)(65 + h - 10) : (char)(48 + h)));
        sb.append(new Character(l > 9 ? (char)(65 + l - 10) : (char)(48 + l)));
        return sb.toString();
    }

    private String getKeyInfo(String offset, Key key) {
        String result = "";
        result = result + "\n" + offset + "[ algorithm ]: " + key.getAlgorithm();
        result = result + "\n" + offset + "[ format ]: " + key.getFormat();
        return result;
    }

    private boolean equalArrays(char[] data1, char[] data2) {
        if (data1 == null || data2 == null) {
            return false;
        }
        if (data1.length != data2.length) {
            return false;
        }
        int i = 0;
        while (i < data1.length) {
            if (data1[i] != data2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

