/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.usermanagement.ActionControl;
import com.sap.engine.services.security.gui.userstore.usermanagement.UsersControlPanel;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class UngroupAction
implements ActionControl {
    private UsersControlPanel control = null;
    private JButton button = null;

    public UngroupAction(UsersControlPanel control) {
        this.control = control;
        this.button = new JButton("Ungroup");
        this.button.addActionListener(this);
        this.button.setEnabled(false);
    }

    public JButton getButton() {
        return this.button;
    }

    public void onSelectionChange(Object root) {
        this.button.setEnabled(UsersControlPanel.groupContext != null && this.control.getSelectedUser() != null && this.control.hasSelectedUserParent());
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String name = this.control.getSelectedUser();
            String parent = this.control.getSelectedUserParent();
            if (parent != null) {
                if (this.control.isUserSelected()) {
                    UsersControlPanel.groupContext.removeUserFromGroup(name, parent);
                } else {
                    UsersControlPanel.groupContext.removeGroupFromParent(name, parent);
                }
                this.control.refreshUsersTree();
            }
        }
        catch (Exception exception) {
            ExceptionHandler.error("Unable to ungroup user/user group!", exception);
        }
    }
}

