/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.usermanagement.ActionControl;
import com.sap.engine.services.security.gui.userstore.usermanagement.RemoveDialog;
import com.sap.engine.services.security.gui.userstore.usermanagement.UsersControlPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class RemoveAction
implements ActionControl {
    private UsersControlPanel control = null;
    private JButton button = null;

    public RemoveAction(UsersControlPanel control) {
        this.control = control;
        this.button = new JButton("Remove");
        this.button.addActionListener(this);
        this.button.setEnabled(false);
    }

    public JButton getButton() {
        return this.button;
    }

    public void onSelectionChange(Object root) {
        this.button.setEnabled(this.control.getSelectedUser() != null);
        if (this.button.isEnabled()) {
            this.button.setText(this.control.isUserSelected() ? "Remove User" : "Remove Group");
        }
    }

    public void actionPerformed(ActionEvent e) {
        Frame frame = this.control.getControl().getFrame();
        String account = this.control.getSelectedUser();
        if (account != null) {
            RemoveDialog dialog = new RemoveDialog(frame, account);
            dialog.setLocationRelativeTo(frame);
            ((Component)dialog).setVisible(true);
            if (dialog.isConfirmed()) {
                try {
                    if (this.control.isUserSelected()) {
                        UsersControlPanel.userContext.deleteUser(account);
                    } else {
                        UsersControlPanel.groupContext.deleteGroup(account);
                    }
                }
                catch (Exception exception) {
                    ExceptionHandler.error("Unable to remove user/user group!", exception);
                }
            }
        }
        this.control.refreshUsersTree();
    }
}

