/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.CScrollField;
import com.sap.engine.services.security.remote.RemoteFilterPassword;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PasswordFilterDialog
extends CEscapeDialog
implements ActionListener {
    JPanel dialogPane = new JPanel(new BorderLayout());
    JPanel centerPane = new JPanel(new GridBagLayout());
    JPanel southPane = new JPanel(new FlowLayout());
    JRadioButton boxDigits;
    JRadioButton boxNoDigits;
    ButtonGroup bgrDigits = new ButtonGroup();
    JRadioButton boxForbid;
    JRadioButton boxNoForbid;
    ButtonGroup bgrForbid = new ButtonGroup();
    JLabel minLabel = new JLabel();
    JLabel maxLabel = new JLabel();
    CScrollField minLength = new CScrollField();
    CScrollField maxLength = new CScrollField();
    JButton okButt = new JButton();
    JButton cancelButt = new JButton();
    private RemoteFilterPassword filter = null;
    private Exception exception = null;

    public PasswordFilterDialog(Frame frame, String title, boolean modal, RemoteFilterPassword filter) {
        super(frame, title, modal);
        this.filter = filter;
        this.minLength.setMinimumValue(0);
        this.minLength.setMaximumValue(40);
        this.maxLength.setMinimumValue(0);
        this.maxLength.setMaximumValue(40);
        this.minLength.setValue(filter.getRestriction(3));
        this.maxLength.setValue(filter.getRestriction(2));
        boolean digits = filter.getRestriction(1) != 1;
        this.boxDigits = new JRadioButton("Require digits in password", digits);
        this.boxNoDigits = new JRadioButton("Do not require digits", !digits);
        boolean spaces = filter.getRestriction(4) != 1;
        this.boxForbid = new JRadioButton("Forbid spaces in password", !spaces);
        this.boxNoForbid = new JRadioButton("Allow spaces in password", spaces);
        this.init();
        this.pack();
    }

    void init() {
        this.minLabel.setText("Minimal length of password: ");
        this.maxLabel.setText("Maximal length of password : ");
        this.okButt.setText("  OK  ");
        this.cancelButt.setText("Cancel");
        this.okButt.setActionCommand("OK_CMD");
        this.okButt.addActionListener(this);
        this.cancelButt.setActionCommand("CANCEL_CMD");
        this.cancelButt.addActionListener(this);
        this.boxDigits.setActionCommand("DIGITS_CMD");
        this.boxDigits.addActionListener(this);
        this.boxNoDigits.setActionCommand("NoDigits_CMD");
        this.boxNoDigits.addActionListener(this);
        this.boxForbid.setActionCommand("FORBID_CMD");
        this.boxForbid.addActionListener(this);
        this.boxNoForbid.setActionCommand("NoForbid_CMD");
        this.boxNoForbid.addActionListener(this);
        this.bgrDigits.add(this.boxDigits);
        this.bgrDigits.add(this.boxNoDigits);
        this.bgrForbid.add(this.boxForbid);
        this.bgrForbid.add(this.boxNoForbid);
        this.centerPane.add((Component)this.minLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.maxLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.minLength, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.maxLength, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.boxDigits, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.boxNoDigits, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.boxNoForbid, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.boxForbid, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.southPane.add(this.okButt);
        this.southPane.add(this.cancelButt);
        this.dialogPane.add((Component)this.centerPane, "Center");
        this.dialogPane.add((Component)this.southPane, "South");
        this.getContentPane().add(this.dialogPane);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }

    private void okAction() {
        ((Component)this).setVisible(false);
        this.exception = null;
        try {
            this.filter.setRestriction(3, this.minLength.getValue());
            this.filter.setRestriction(2, this.maxLength.getValue());
            if (this.boxDigits.isSelected()) {
                this.filter.setRestriction(1, 3);
            } else {
                this.filter.setRestriction(1, 1);
            }
            if (this.boxNoForbid.isSelected()) {
                this.filter.setRestriction(4, 0);
            } else {
                this.filter.setRestriction(4, 1);
            }
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    private void cancelAction() {
        ((Component)this).setVisible(false);
    }

    public RemoteFilterPassword getFilter() {
        return this.filter;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("OK_CMD")) {
            this.okAction();
        } else if (cmd.equals("CANCEL_CMD")) {
            this.cancelAction();
        }
    }

    public void validateFilter() throws Exception {
        if (this.exception != null) {
            throw this.exception;
        }
    }
}

