/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.util.SortedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ParentsDialog
extends CEscapeDialog
implements ActionListener {
    private final String CANCEL_ACTION_COMMAND = "CANCEL_ACTION_COMMAND";
    private final String OK_ACTION_COMMAND = "OK_ACTION_COMMAND";
    Frame frame = null;
    private SortedList list = new SortedList();
    ArrayList parents = new ArrayList(0);
    String parent = null;
    private boolean processing = false;
    private boolean confirmed = false;

    public ParentsDialog(Frame frame, ArrayList parents) {
        super(frame, "Choose Parent", true);
        this.frame = frame;
        this.parents = parents;
        try {
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to set up parent selection dialog!", ex);
        }
    }

    private void init() throws Exception {
        try {
            this.list.setSelectionMode(2);
            this.list.setListData(this.parents, null);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to set up parent selection dialog!", e);
            this.list.setEnabled(false);
        }
        JButton okButt = new JButton("  OK  ");
        okButt.setActionCommand("OK_ACTION_COMMAND");
        okButt.addActionListener(this);
        JButton cancelButt = new JButton("Cancel");
        cancelButt.setActionCommand("CANCEL_ACTION_COMMAND");
        cancelButt.addActionListener(this);
        JPanel southPane = new JPanel(new FlowLayout());
        southPane.add(okButt);
        southPane.add(cancelButt);
        JPanel dialogPane = new JPanel(new BorderLayout());
        dialogPane.add((Component)new JScrollPane(this.list), "Center");
        dialogPane.add((Component)southPane, "South");
        this.getContentPane().add(dialogPane);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("OK_ACTION_COMMAND")) {
            this.okAction();
        } else if (command.equals("CANCEL_ACTION_COMMAND")) {
            ((Component)this).setVisible(false);
        }
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public String getSelectedParent() {
        return this.parent;
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        ((Component)this).setVisible(false);
    }

    private void okAction() {
        if (!this.processing) {
            try {
                try {
                    this.processing = true;
                    this.parent = (String)this.list.getSelectedValue();
                    this.confirmed = true;
                    ((Component)this).setVisible(false);
                }
                catch (Exception e) {
                    ExceptionHandler.error("Unable to choose parent!", e);
                    this.confirmed = false;
                    ((Component)this).setVisible(false);
                    Object var3_2 = null;
                    this.processing = false;
                }
                Object var3_1 = null;
                this.processing = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.processing = false;
                throw throwable;
            }
        }
    }
}

