/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.CScrollField;
import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.usermanagement.UMHash;
import com.sap.engine.services.security.gui.userstore.usermanagement.UsersControlPanel;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.UserTreePanel;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.lang.reflect.Method;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class NewUserDialog
extends CEscapeDialog
implements ActionListener,
ItemListener {
    private static final X509Certificate[] X509CERTIFICATES = new X509Certificate[0];
    private final String CANCEL_ACTION_COMMAND = "CANCEL_ACTION_COMMAND";
    private final String OK_ACTION_COMMAND = "OK_ACTION_COMMAND";
    private final String RANDOM_PASSWORD_ACTION_COMMAND = "RANDOM_PASSWORD_ACTION_COMMAND";
    private final String PASS_CHANGE_COMMAND = "REQUIRE_PASS_CHANGE";
    UsersControlPanel control = null;
    Frame frame = null;
    UserTreePanel userTree = null;
    JTextField userNameField = new JTextField("", 10);
    JPasswordField passwordField = new JPasswordField("", 10);
    JPasswordField confirmPasswordField = new JPasswordField("", 10);
    JCheckBox randomPasswordBox = new JCheckBox("Random password");
    JCheckBox passwordChangeRequired = new JCheckBox();
    JPanel passwordChangeCard = null;
    CScrollField nextPassChangeField = new CScrollField();
    private JComboBox views = null;
    private JList entries = null;
    private String selectedView = null;
    private boolean processing = false;
    private boolean confirmed = false;
    private Object keystoreManagement = null;
    static /* synthetic */ Class class$java$lang$String;

    public NewUserDialog(UsersControlPanel control) {
        super(control.getControl().getFrame(), "Create New User", true);
        this.frame = control.getControl().getFrame();
        this.control = control;
        try {
            this.userTree = new UserTreePanel(UsersControlPanel.userContext, UsersControlPanel.groupContext);
            this.userTree.setFrame(this.frame);
            this.userTree.setUsersVisible(false);
            this.userTree.refresh(UMHash.getRoot(UsersControlPanel.selectedStore));
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to set up user creation dialog!", ex);
        }
    }

    private void init() throws Exception {
        this.randomPasswordBox.setActionCommand("RANDOM_PASSWORD_ACTION_COMMAND");
        this.randomPasswordBox.addActionListener(this);
        this.passwordChangeRequired.addActionListener(this);
        this.passwordChangeRequired.setActionCommand("REQUIRE_PASS_CHANGE");
        this.nextPassChangeField.setValue(3650);
        this.nextPassChangeField.setMinimumValue(0);
        this.nextPassChangeField.setMaximumValue(10950);
        this.nextPassChangeField.setPreferredSize(new Dimension(100, 10));
        JPanel certificatesPanel = new JPanel(new GridBagLayout());
        try {
            this.entries = new JList();
            this.entries.setSelectionMode(2);
            this.entries.setVisibleRowCount(5);
            this.views = new JComboBox();
            try {
                Object keystore = this.getKeystore();
                if (keystore != null) {
                    Method aliasesMethod = keystore.getClass().getMethod("getKeystoreViewAliases", new Class[0]);
                    String[] viewAliases = (String[])aliasesMethod.invoke(keystore, new Object[0]);
                    int i = 0;
                    while (i < viewAliases.length) {
                        this.views.addItem(viewAliases[i]);
                        ++i;
                    }
                    this.views.setEditable(false);
                    if (this.views.getItemCount() == 0) {
                        // empty if block
                    }
                    this.selectedView = (String)this.views.getItemAt(0);
                    this.loadEntries();
                } else {
                    this.entries.setEnabled(false);
                    this.views.setEnabled(false);
                }
            }
            catch (Exception re) {
                ExceptionHandler.debug(null, re);
                this.entries.setEnabled(false);
                this.views.setEnabled(false);
            }
            this.entries.setMinimumSize(this.views.getSize());
            this.views.addItemListener(this);
            certificatesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Associate Certificates to Account:  "));
            JLabel label = new JLabel("Select view: ");
            certificatesPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            certificatesPanel.add((Component)this.views, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            certificatesPanel.add((Component)new JScrollPane(this.entries), new GridBagConstraints(0, 1, 2, 5, 0.1, 0.1, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to set up user creation dialog!", e);
        }
        JPanel leftSplit = new JPanel(new GridBagLayout());
        leftSplit.add((Component)new JLabel("User name : "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.1, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        leftSplit.add((Component)new JLabel("Password : "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.1, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        leftSplit.add((Component)new JLabel("Confirm password : "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.1, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        leftSplit.add((Component)this.userNameField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        leftSplit.add((Component)this.passwordField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        leftSplit.add((Component)this.confirmPasswordField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        leftSplit.add((Component)this.randomPasswordBox, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        leftSplit.add((Component)new JPanel(), new GridBagConstraints(0, 5, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        leftSplit.add((Component)certificatesPanel, new GridBagConstraints(0, 6, 2, 4, 0.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scrollingRightSplit = new JScrollPane();
        scrollingRightSplit.getViewport().add((Component)this.userTree, "Center");
        this.userTree.setPreferredSize(new Dimension(200, this.userTree.getPreferredSize().height));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setLeftComponent(leftSplit);
        splitPane.setRightComponent(scrollingRightSplit);
        JButton okButt = new JButton("  OK  ");
        okButt.setActionCommand("OK_ACTION_COMMAND");
        okButt.addActionListener(this);
        JButton cancelButt = new JButton("Cancel");
        cancelButt.setActionCommand("CANCEL_ACTION_COMMAND");
        cancelButt.addActionListener(this);
        JPanel southPane = new JPanel(new FlowLayout());
        southPane.add(okButt);
        southPane.add(cancelButt);
        JPanel dialogPane = new JPanel(new BorderLayout());
        dialogPane.add((Component)splitPane, "Center");
        dialogPane.add((Component)southPane, "South");
        this.getContentPane().add(dialogPane);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("OK_ACTION_COMMAND")) {
            this.okAction();
        } else if (command.equals("CANCEL_ACTION_COMMAND")) {
            ((Component)this).setVisible(false);
        } else if (command.equals("RANDOM_PASSWORD_ACTION_COMMAND")) {
            if (this.randomPasswordBox.isSelected()) {
                ((JTextComponent)this.passwordField).setText("");
                ((JTextComponent)this.confirmPasswordField).setText("");
                this.passwordField.setEditable(false);
                this.confirmPasswordField.setEditable(false);
            } else {
                this.passwordField.setEditable(true);
                this.confirmPasswordField.setEditable(true);
            }
        } else if (command.equals("REQUIRE_PASS_CHANGE")) {
            boolean noPassChange = this.passwordChangeRequired.isSelected();
            ((CardLayout)this.passwordChangeCard.getLayout()).show(this.passwordChangeCard, "" + noPassChange);
            if (!noPassChange) {
                this.nextPassChangeField.setValue(3650);
            }
        }
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public String getUserName() {
        return this.userNameField.getText();
    }

    public char[] getPassword() {
        if (this.randomPasswordBox.isSelected()) {
            return null;
        }
        return this.passwordField.getPassword();
    }

    public long getPasswordChangePeriod() {
        if (this.passwordChangeRequired.isSelected()) {
            return Long.MAX_VALUE;
        }
        return (long)this.nextPassChangeField.getValue() * 24L * 60L * 60L * 1000L;
    }

    public String[] getSelectedGroups() {
        Object[] users = this.userTree.getSelectedUsers();
        String[] groups = new String[users.length];
        int i = 0;
        while (i < users.length) {
            try {
                if (users[i] instanceof RemoteUserStoreInfo) {
                    groups[i] = ((RemoteUserStoreInfo)users[i]).getName();
                } else if (users[i] instanceof RemoteGroupInfo) {
                    groups[i] = ((RemoteGroupInfo)users[i]).getName();
                }
            }
            catch (Exception e) {
                ExceptionHandler.error("Unable to get selected groups!", e);
            }
            ++i;
        }
        return groups;
    }

    protected void performEscapeAction(KeyEvent e) {
        ((Component)this).setVisible(false);
    }

    private void okAction() {
        if (!this.processing) {
            try {
                block9: {
                    try {
                        this.processing = true;
                        if (this.getUserName() == null || this.getUserName().equals("")) {
                            this.userNameField.requestFocus();
                            ExceptionHandler.error("User name may not be empty!", null);
                            break block9;
                        }
                        if (!this.randomPasswordBox.isSelected() && !new String(this.getPassword()).equals(new String(this.confirmPasswordField.getPassword()))) {
                            this.passwordField.requestFocus();
                            ExceptionHandler.error("Passwords do not match!", null);
                            ((JTextComponent)this.passwordField).setText("");
                            ((JTextComponent)this.confirmPasswordField).setText("");
                            break block9;
                        }
                        if (this.getPassword() != null) {
                            if (!UsersControlPanel.userContext.getFilterPassword().filterPassword(this.getPassword())) {
                                ExceptionHandler.error("Unacceptable password! See current Password Filter.", null);
                                ((JTextComponent)this.passwordField).setText("");
                                ((JTextComponent)this.confirmPasswordField).setText("");
                                break block9;
                            }
                        }
                        this.confirmed = true;
                        ((Component)this).setVisible(false);
                    }
                    catch (Exception e) {
                        ExceptionHandler.error("Unable to create user!", e);
                        this.confirmed = false;
                        ((Component)this).setVisible(false);
                        Object var3_2 = null;
                        this.processing = false;
                    }
                }
                Object var3_1 = null;
                this.processing = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.processing = false;
                throw throwable;
            }
        }
    }

    public synchronized void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.selectedView = (String)e.getItem();
            try {
                this.loadEntries();
            }
            catch (Exception re) {
                ExceptionHandler.error("Unable to retrieve certificate entries!", re);
            }
        }
    }

    public X509Certificate[] getCertificates() throws Exception {
        Object[] selectedEntries = this.entries.getSelectedValues();
        Vector<Certificate> certificates = new Vector<Certificate>();
        Object keystore = this.getKeystore();
        if (keystore != null) {
            Method readEntryMethod = keystore.getClass().getMethod("readEntry", class$java$lang$String == null ? (class$java$lang$String = NewUserDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NewUserDialog.class$("java.lang.String")) : class$java$lang$String);
            if (selectedEntries != null) {
                int i = 0;
                while (i < selectedEntries.length) {
                    try {
                        Object entry = readEntryMethod.invoke(keystore, this.selectedView, selectedEntries[i]);
                        Method method = entry.getClass().getMethod("getCertificate", new Class[0]);
                        Certificate certificate = (Certificate)method.invoke(entry, new Object[0]);
                        if (certificate != null && certificate instanceof X509Certificate) {
                            certificates.add(certificate);
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.error("Cannot read certificate entry '" + selectedEntries[i] + "' from keystore.", e);
                    }
                    ++i;
                }
            }
        }
        return certificates.toArray(X509CERTIFICATES);
    }

    private void loadEntries() throws Exception {
        if (this.selectedView == null) {
            return;
        }
        Object keystore = this.getKeystore();
        if (keystore == null) {
            return;
        }
        Method aliasesMethod = keystore.getClass().getMethod("aliases", class$java$lang$String == null ? (class$java$lang$String = NewUserDialog.class$("java.lang.String")) : class$java$lang$String);
        Method isKeyEntryMethod = keystore.getClass().getMethod("isKeyEntry", class$java$lang$String == null ? (class$java$lang$String = NewUserDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = NewUserDialog.class$("java.lang.String")) : class$java$lang$String);
        String[] entryAliases = (String[])aliasesMethod.invoke(keystore, this.selectedView);
        Vector<String> values = new Vector<String>();
        int i = 0;
        while (i < entryAliases.length) {
            if (!((Boolean)isKeyEntryMethod.invoke(keystore, this.selectedView, entryAliases[i])).booleanValue()) {
                values.add(entryAliases[i]);
            }
            ++i;
        }
        this.entries.removeAll();
        this.entries.setListData(values);
        this.entries.repaint();
    }

    private Object getKeystore() throws Exception {
        if (this.keystoreManagement != null) {
            return this.keystoreManagement;
        }
        try {
            return ClusterTreeGenerator.managementInterfaceProxyFactory.generateCurrentManagementInterfaceProxy("keystore");
        }
        catch (Exception e) {
            ExceptionHandler.debug("Unable to retrieve keystore interface!", e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

