/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.usermanagement.ActionControl;
import com.sap.engine.services.security.gui.userstore.usermanagement.NewUserDialog;
import com.sap.engine.services.security.gui.userstore.usermanagement.UsersControlPanel;
import com.sap.engine.services.security.remote.RemoteFilterPassword;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.security.cert.X509Certificate;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class NewUserAction
implements ActionControl {
    private UsersControlPanel control = null;
    private JButton button = null;

    public NewUserAction(UsersControlPanel control) {
        this.control = control;
        this.button = new JButton("Create User");
        this.button.addActionListener(this);
    }

    public JButton getButton() {
        return this.button;
    }

    public void onSelectionChange(Object root) {
    }

    public void actionPerformed(ActionEvent e) {
        NewUserDialog dialog = null;
        Frame frame = this.control.getControl().getFrame();
        try {
            dialog = new NewUserDialog(this.control);
            dialog.setLocationRelativeTo(frame);
            ((Component)dialog).setVisible(true);
            if (dialog.isConfirmed()) {
                this.createUser(dialog.getUserName(), dialog.getPassword(), dialog.getSelectedGroups(), dialog.getCertificates());
            }
        }
        catch (Exception exception) {
            ExceptionHandler.error(frame, "Error in initialization of user creation dialog!", exception);
        }
        this.control.refreshUsersTree();
    }

    private void createUser(String userName, char[] password, String[] groups, X509Certificate[] certificates) {
        RemoteUserStoreInfo userInfo = null;
        try {
            userInfo = UsersControlPanel.userContext.createUser(userName);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to create the user!", e);
            return;
        }
        int i = 0;
        try {
            while (i < groups.length) {
                UsersControlPanel.groupContext.addUserToGroup(userName, groups[i]);
                ++i;
            }
        }
        catch (Exception e) {
            ExceptionHandler.warning("Unable to add the new user to group <" + groups[i] + ">!", e);
        }
        try {
            if (password == null) {
                RemoteFilterPassword filter = UsersControlPanel.userContext.getFilterPassword();
                password = filter.generatePassword();
                userInfo.writeUserProperty(9, password);
                Frame frame = this.control.getControl().getFrame();
                JOptionPane.showMessageDialog(frame, "User password is : \"" + new String(password) + "\"", "Info", 1);
            } else {
                userInfo.writeUserProperty(9, password);
            }
        }
        catch (Exception e) {
            ExceptionHandler.warning("Unable to set user's password!", e);
        }
        if (certificates != null && certificates.length > 0) {
            try {
                userInfo.setCertificates(certificates);
            }
            catch (Exception e) {
                ExceptionHandler.warning("Unable to set certificates for the new user account!", e);
            }
        }
    }
}

