/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.usermanagement.UMHash;
import com.sap.engine.services.security.gui.userstore.usermanagement.UsersControlPanel;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.UserTreePanel;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class NewGroupDialog
extends CEscapeDialog
implements ActionListener {
    Frame frame = null;
    JPanel dialogPane = new JPanel(new BorderLayout());
    JPanel northPane = new JPanel(new GridBagLayout());
    JPanel centerPane = new JPanel(new GridBagLayout());
    JPanel southPane = new JPanel(new FlowLayout());
    UserTreePanel parentTree = null;
    UserTreePanel childTree = null;
    UserTreePanel userTree = null;
    JTextField grTxt = new JTextField("", 10);
    JButton okButt = new JButton();
    JButton cancelButt = new JButton();
    Border border = BorderFactory.createEtchedBorder(Color.white, new Color(134, 134, 134));
    private boolean processing = false;
    private boolean isOK = false;
    private String groupName = null;
    private String[] selectedParentGrs = null;
    private String[] selectedChildGrs = null;
    private String[] selectedUsers = null;

    public NewGroupDialog(Frame frame) {
        super(frame, "Create New Group", true);
        this.frame = frame;
        try {
            this.parentTree = new UserTreePanel(UsersControlPanel.userContext, UsersControlPanel.groupContext);
            this.parentTree.setFrame(frame);
            this.childTree = new UserTreePanel(UsersControlPanel.userContext, UsersControlPanel.groupContext);
            this.childTree.setFrame(frame);
            this.userTree = new UserTreePanel(UsersControlPanel.userContext, UsersControlPanel.groupContext);
            this.userTree.setFrame(frame);
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to set up group creation dialog!", ex);
        }
    }

    void init() throws Exception {
        this.groupName = null;
        this.isOK = false;
        this.okButt.setText("  OK  ");
        this.cancelButt.setText("Cancel");
        this.okButt.setActionCommand("OK_CMD");
        this.okButt.addActionListener(this);
        this.cancelButt.setActionCommand("CANCEL_CMD");
        this.cancelButt.addActionListener(this);
        this.southPane.add(this.okButt);
        this.southPane.add(this.cancelButt);
        this.northPane.add((Component)new JLabel("Group name: "), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.northPane.add((Component)this.grTxt, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parentTree.setUsersVisible(false);
        this.parentTree.refresh(UMHash.getRoot(UsersControlPanel.selectedStore));
        this.parentTree.setBorder(new TitledBorder(this.border, "Parent groups "));
        this.centerPane.add((Component)this.parentTree, new GridBagConstraints(0, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.childTree.setUsersVisible(false);
        this.childTree.refresh(UMHash.getRoot(UsersControlPanel.selectedStore));
        this.childTree.setBorder(new TitledBorder(this.border, "Child groups "));
        this.centerPane.add((Component)this.childTree, new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.userTree.setUsersVisible(true);
        this.userTree.setGroupsVisible(false);
        this.userTree.refresh(UMHash.getRoot(UsersControlPanel.selectedStore));
        this.userTree.setBorder(new TitledBorder(this.border, "Users "));
        this.centerPane.add((Component)this.userTree, new GridBagConstraints(2, 0, 1, 1, 0.1, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.dialogPane.add((Component)this.northPane, "North");
        this.dialogPane.add((Component)this.centerPane, "Center");
        this.dialogPane.add((Component)this.southPane, "South");
        this.getContentPane().add(this.dialogPane);
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }

    private void okAction() {
        if (!this.processing) {
            this.processing = true;
            try {
                block9: {
                    try {
                        if (this.grTxt.getText() == null || this.grTxt.getText().equals("")) {
                            this.grTxt.requestFocus();
                            ExceptionHandler.error("Group name may not be empty!", null);
                            break block9;
                        }
                        Object[] o = null;
                        this.groupName = this.grTxt.getText();
                        o = this.parentTree.getSelectedUsers();
                        this.selectedParentGrs = new String[o.length];
                        int i = 0;
                        while (i < o.length) {
                            this.selectedParentGrs[i] = ((RemoteGroupInfo)o[i]).getName();
                            ++i;
                        }
                        o = this.childTree.getSelectedUsers();
                        this.selectedChildGrs = new String[o.length];
                        int i2 = 0;
                        while (i2 < o.length) {
                            this.selectedChildGrs[i2] = ((RemoteGroupInfo)o[i2]).getName();
                            ++i2;
                        }
                        o = this.userTree.getSelectedUsers();
                        this.selectedUsers = new String[o.length];
                        int i3 = 0;
                        while (i3 < o.length) {
                            this.selectedUsers[i3] = ((RemoteUserStoreInfo)o[i3]).getName();
                            ++i3;
                        }
                        this.isOK = true;
                        ((Component)this).setVisible(false);
                    }
                    catch (Exception e) {
                        ExceptionHandler.debug("Unable to create the group!", e);
                        Object var6_7 = null;
                        this.processing = false;
                    }
                }
                Object var6_6 = null;
                this.processing = false;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.processing = false;
                throw throwable;
            }
        }
    }

    private void cancelAction() {
        this.isOK = false;
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK_CMD")) {
            this.okAction();
        } else if (e.getActionCommand().equals("CANCEL_CMD")) {
            this.cancelAction();
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String[] getSelectedParentGrs() {
        if (this.selectedParentGrs == null) {
            return new String[0];
        }
        return this.selectedParentGrs;
    }

    public String[] getSelectedChildGrs() {
        if (this.selectedChildGrs == null) {
            return new String[0];
        }
        return this.selectedChildGrs;
    }

    public String[] getSelectedUsers() {
        if (this.selectedUsers == null) {
            return new String[0];
        }
        return this.selectedUsers;
    }
}

