/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.usermanagement.ActionControl;
import com.sap.engine.services.security.gui.userstore.usermanagement.NewGroupDialog;
import com.sap.engine.services.security.gui.userstore.usermanagement.UsersControlPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class NewGroupAction
implements ActionControl {
    private UsersControlPanel control = null;
    private JButton button = null;

    public NewGroupAction(UsersControlPanel control) {
        this.control = control;
        this.button = new JButton("Create Group");
        this.button.addActionListener(this);
    }

    public JButton getButton() {
        return this.button;
    }

    public void onSelectionChange(Object root) {
        this.button.setEnabled(UsersControlPanel.groupContext != null);
    }

    public void actionPerformed(ActionEvent e) {
        Frame frame = this.control.getControl().getFrame();
        try {
            NewGroupDialog dialog = new NewGroupDialog(frame);
            dialog.setLocationRelativeTo(frame);
            ((Component)dialog).setVisible(true);
            if (dialog.isOK()) {
                UsersControlPanel.groupContext.createGroup(dialog.getGroupName());
                String[] parents = dialog.getSelectedParentGrs();
                int i = 0;
                while (i < parents.length) {
                    UsersControlPanel.groupContext.addGroupToParent(dialog.getGroupName(), parents[i]);
                    ++i;
                }
                String[] childUsers = dialog.getSelectedUsers();
                int i2 = 0;
                while (i2 < childUsers.length) {
                    UsersControlPanel.groupContext.addUserToGroup(childUsers[i2], dialog.getGroupName());
                    ++i2;
                }
                String[] childGroups = dialog.getSelectedChildGrs();
                int i3 = 0;
                while (i3 < childGroups.length) {
                    UsersControlPanel.groupContext.addGroupToParent(childGroups[i3], dialog.getGroupName());
                    ++i3;
                }
            }
        }
        catch (Exception exception) {
            ExceptionHandler.error("Group configuration not complete!", exception);
        }
        this.control.refreshUsersTree();
    }
}

