/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.usermanagement.UMHash;
import com.sap.engine.services.security.gui.userstore.usermanagement.UsersControlPanel;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.UserTreePanel;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GroupsSelectionPanel
extends CEscapeDialog
implements ActionListener {
    JPanel dialogPane = new JPanel(new BorderLayout());
    JPanel southPane = new JPanel(new FlowLayout());
    UserTreePanel userTree = null;
    JLabel itemLbl = new JLabel();
    JButton okButt = new JButton();
    JButton cancelButt = new JButton();
    private boolean isOK = false;
    private String[] selectedParents = null;
    private Frame frame = null;

    public GroupsSelectionPanel(Frame frame) {
        super(frame, "Choose parent groups", true);
        try {
            this.userTree = new UserTreePanel(UsersControlPanel.userContext, UsersControlPanel.groupContext);
            this.userTree.setFrame(frame);
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ExceptionHandler.error(frame, "Unable to set up group selection panel!", ex);
        }
    }

    void init() throws Exception {
        this.okButt.setText("  OK  ");
        this.okButt.setActionCommand("OK_CMD");
        this.okButt.addActionListener(this);
        this.cancelButt.setText("Cancel");
        this.cancelButt.setActionCommand("CANCEL_CMD");
        this.cancelButt.addActionListener(this);
        this.southPane.add(this.okButt);
        this.southPane.add(this.cancelButt);
        this.userTree.setUsersVisible(false);
        this.userTree.refresh(UMHash.getRoot(UsersControlPanel.selectedStore));
        this.dialogPane.add((Component)this.userTree, "Center");
        this.dialogPane.add((Component)this.southPane, "South");
        this.getContentPane().add(this.dialogPane);
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }

    private void okAction() {
        try {
            this.isOK = true;
            Object[] o = this.userTree.getSelectedUsers();
            this.selectedParents = new String[o.length];
            int i = 0;
            while (i < o.length) {
                this.selectedParents[i] = ((RemoteGroupInfo)o[i]).getName();
                ++i;
            }
            ((Component)this).setVisible(false);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to set up group selection panel!", e);
        }
    }

    private void cancelAction() {
        this.isOK = false;
        ((Component)this).setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK_CMD")) {
            this.okAction();
        } else if (e.getActionCommand().equals("CANCEL_CMD")) {
            this.cancelAction();
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public String[] getSelectedParents() {
        if (this.selectedParents == null) {
            return new String[0];
        }
        return this.selectedParents;
    }
}

