/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.usermanagement.ActionControl;
import com.sap.engine.services.security.gui.userstore.usermanagement.GroupsSelectionPanel;
import com.sap.engine.services.security.gui.userstore.usermanagement.UsersControlPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class GroupAction
implements ActionControl {
    private UsersControlPanel control = null;
    private JButton button = null;

    public GroupAction(UsersControlPanel control) {
        this.control = control;
        this.button = new JButton("Group");
        this.button.addActionListener(this);
        this.button.setEnabled(false);
    }

    public JButton getButton() {
        return this.button;
    }

    public void onSelectionChange(Object root) {
        this.button.setEnabled(UsersControlPanel.groupContext != null && this.control.getSelectedUser() != null);
    }

    public void actionPerformed(ActionEvent e) {
        Frame frame = this.control.getControl().getFrame();
        try {
            String[] parents = null;
            String name = this.control.getSelectedUser();
            GroupsSelectionPanel dialog = new GroupsSelectionPanel(frame);
            dialog.setLocationRelativeTo(frame);
            ((Component)dialog).setVisible(true);
            parents = dialog.getSelectedParents();
            int i = 0;
            while (i < parents.length) {
                if (this.control.isUserSelected()) {
                    UsersControlPanel.groupContext.addUserToGroup(name, parents[i]);
                } else {
                    UsersControlPanel.groupContext.addGroupToParent(name, parents[i]);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            ExceptionHandler.error("Unable to group user/user group!", exception);
        }
        this.control.refreshUsersTree();
    }
}

