/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.usermanagement;

import com.sap.engine.services.adminadapter.gui.ClusterTreeGenerator;
import com.sap.engine.services.security.gui.ExceptionHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CertificatesDialog
extends JDialog
implements ActionListener,
ItemListener {
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JComboBox views = null;
    private JList entries = null;
    private String selectedView = null;
    private String[] selectedEntries = null;
    private boolean confirmed = false;
    private Object keystoreManagement = null;
    static /* synthetic */ Class class$java$lang$String;

    public CertificatesDialog(Frame frame, String title) throws Exception {
        super(frame, title, true);
        JPanel mainPanel = new JPanel();
        JPanel listPanel = new JPanel();
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridBagLayout());
        buttonsPanel.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 2, new Insets(5, 1, 5, 1), 0, 0));
        buttonsPanel.add((Component)this.cancelButton, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 13, 2, new Insets(5, 1, 5, 1), 0, 0));
        this.okButton.setActionCommand("OK");
        this.okButton.setEnabled(false);
        this.cancelButton.setActionCommand("CANCEL");
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.entries = new JList();
        this.entries.setSelectionMode(0);
        listPanel.setLayout(new GridBagLayout());
        listPanel.add((Component)new JScrollPane(this.entries), new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        listPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Select entries:  "));
        this.views = new JComboBox();
        Object keystore = this.getKeystore();
        if (keystore == null) {
            throw new SecurityException("Cannot get keystore interface.");
        }
        Method aliasesMethod = keystore.getClass().getMethod("getKeystoreViewAliases", new Class[0]);
        String[] viewAliases = (String[])aliasesMethod.invoke(keystore, new Object[0]);
        int i = 0;
        while (i < viewAliases.length) {
            this.views.addItem(viewAliases[i]);
            ++i;
        }
        this.views.setEditable(false);
        if (this.views.getItemCount() != 0) {
            this.selectedView = (String)this.views.getItemAt(0);
            this.loadEntries();
        }
        this.entries.setVisibleRowCount(5);
        this.entries.setMinimumSize(this.views.getSize());
        this.views.addItemListener(this);
        JLabel label = new JLabel("Select view: ");
        mainPanel.setLayout(new GridBagLayout());
        mainPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.01, 0.01, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.views, new GridBagConstraints(1, 0, 1, 1, 0.01, 0.01, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)buttonsPanel, new GridBagConstraints(0, 1, 1, 2, 0.01, 0.01, 11, 0, new Insets(5, 0, 5, 0), 0, 0));
        mainPanel.add((Component)listPanel, new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add(mainPanel);
        ((Component)this).setSize(500, 200);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int posX = (int)((double)d.width - this.getSize().getWidth());
        int posY = (int)((double)d.height - this.getSize().getHeight());
        ((Component)this).setLocation(posX / 2, posY / 2);
        ((Component)this).setVisible(true);
    }

    public synchronized void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            this.selectedView = (String)this.views.getSelectedItem();
            Object[] positions = this.entries.getSelectedValues();
            this.selectedEntries = new String[positions.length];
            int i = 0;
            while (i < positions.length) {
                this.selectedEntries[i] = (String)positions[i];
                ++i;
            }
            if (positions.length == 0) {
                this.selectedView = null;
                this.selectedEntries = null;
            } else {
                this.confirmed = true;
            }
        } else if (e.getActionCommand().equals("CANCEL")) {
            this.selectedView = null;
            this.selectedEntries = null;
        }
        ((Component)this).setVisible(false);
    }

    public synchronized String getSelectedView() {
        return this.selectedView;
    }

    public synchronized String[] getSelectedEntries() {
        return this.selectedEntries;
    }

    public synchronized void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.selectedView = (String)e.getItem();
            try {
                this.loadEntries();
            }
            catch (Exception re) {
                ExceptionHandler.error("Unable to load certificate entries!", re);
            }
        }
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public X509Certificate[] getCertificates() throws Exception {
        Vector<Certificate> certificates = new Vector<Certificate>();
        Object keystore = this.getKeystore();
        if (keystore != null) {
            Method readEntryMethod = keystore.getClass().getMethod("readEntry", class$java$lang$String == null ? (class$java$lang$String = CertificatesDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CertificatesDialog.class$("java.lang.String")) : class$java$lang$String);
            if (this.selectedEntries != null) {
                int i = 0;
                while (i < this.selectedEntries.length) {
                    try {
                        Object entry = readEntryMethod.invoke(keystore, this.selectedView, this.selectedEntries[i]);
                        Method method = entry.getClass().getMethod("getCertificate", new Class[0]);
                        Certificate certificate = (Certificate)method.invoke(entry, new Object[0]);
                        if (certificate != null && certificate instanceof X509Certificate) {
                            certificates.add(certificate);
                        }
                    }
                    catch (Exception e) {
                        ExceptionHandler.error("Cannot read certificate entry '" + this.selectedEntries[i] + "' from keystore.", e);
                    }
                    ++i;
                }
            }
        }
        return certificates.toArray(new X509Certificate[0]);
    }

    private void loadEntries() throws Exception {
        if (this.selectedView == null) {
            return;
        }
        Object keystore = this.getKeystore();
        if (keystore == null) {
            return;
        }
        Method aliasesMethod = keystore.getClass().getMethod("aliases", class$java$lang$String == null ? (class$java$lang$String = CertificatesDialog.class$("java.lang.String")) : class$java$lang$String);
        Method isKeyEntryMethod = keystore.getClass().getMethod("isKeyEntry", class$java$lang$String == null ? (class$java$lang$String = CertificatesDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CertificatesDialog.class$("java.lang.String")) : class$java$lang$String);
        String[] entryAliases = (String[])aliasesMethod.invoke(keystore, this.selectedView);
        Vector<String> values = new Vector<String>();
        int i = 0;
        while (i < entryAliases.length) {
            if (!((Boolean)isKeyEntryMethod.invoke(keystore, this.selectedView, entryAliases[i])).booleanValue()) {
                values.add(entryAliases[i]);
                this.okButton.setEnabled(true);
            }
            ++i;
        }
        this.entries.removeAll();
        this.entries.setListData(values);
        this.entries.repaint();
    }

    private Object getKeystore() throws Exception {
        if (this.keystoreManagement != null) {
            return this.keystoreManagement;
        }
        try {
            return ClusterTreeGenerator.managementInterfaceProxyFactory.generateCurrentManagementInterfaceProxy("keystore");
        }
        catch (Exception e) {
            ExceptionHandler.debug("Unable to retrieve keystore interface!", e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

