/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores.wizard;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.UserStoreControl;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import com.sap.engine.services.security.gui.userstore.stores.wizard.AdministratorPasswordCheckWizard;
import com.sap.engine.services.security.gui.userstore.stores.wizard.AnonymousPrincipalConfirmWizard;
import com.sap.engine.services.security.gui.userstore.stores.wizard.AuthenticationConfirmWizard;
import com.sap.engine.services.security.gui.userstore.stores.wizard.AuthenticationTemplatesWizard;
import com.sap.engine.services.security.gui.userstore.stores.wizard.AuthorizationConfirmWizard;
import com.sap.engine.services.security.gui.userstore.stores.wizard.AuthorizationWizard;
import com.sap.engine.services.security.gui.userstore.stores.wizard.LastCheckWizard;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardStep;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class WizardPanel
extends JPanel
implements ActionListener,
WindowListener {
    private static final String BACK_COMMAND = "BACK_COMMAND";
    private static final String CANCEL_COMMAND = "CANCEL_COMMAND";
    private static final String NEXT_COMMAND = "NEXT_COMMAND";
    private String userStore = null;
    private UserStoresPanel control = null;
    int step = 0;
    WizardStep[] steps = null;
    private JDialog dialog = null;
    private JPanel wizard = null;
    private JButton backButton = null;
    private JButton cancelButton = null;
    private JButton nextButton = null;

    public WizardPanel(UserStoresPanel control, String userStore) {
        this.control = control;
        this.userStore = userStore;
        JPanel buttonPanel = new JPanel();
        this.backButton = new JButton("Back");
        this.backButton.setActionCommand(BACK_COMMAND);
        this.backButton.setEnabled(false);
        this.backButton.addActionListener(this);
        buttonPanel.add(this.backButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand(CANCEL_COMMAND);
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cancelButton);
        this.nextButton = new JButton("Next");
        this.nextButton.setActionCommand(NEXT_COMMAND);
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(this);
        buttonPanel.add(this.nextButton);
        this.steps = new WizardStep[7];
        this.steps[0] = new AuthenticationTemplatesWizard(this, control.getControl().getControl(), userStore);
        this.steps[1] = new AuthenticationConfirmWizard(this, control.getControl().getControl(), userStore);
        this.steps[2] = new AuthorizationWizard(this, control.getControl().getControl(), userStore);
        this.steps[3] = new AuthorizationConfirmWizard(this, control.getControl().getControl(), userStore);
        this.steps[4] = new AnonymousPrincipalConfirmWizard(this, control.getControl().getControl(), userStore);
        this.steps[5] = new AdministratorPasswordCheckWizard(this, control.getControl().getControl(), userStore);
        this.steps[6] = new LastCheckWizard(this, control.getControl().getControl(), userStore);
        this.wizard = new JPanel();
        this.wizard.setLayout(new CardLayout());
        int i = 0;
        while (i < this.steps.length) {
            this.wizard.add((Component)((Object)this.steps[i]), this.steps[i].getName());
            ++i;
        }
        JPanel dialogPanel = new JPanel(new BorderLayout());
        dialogPanel.add((Component)this.wizard, "Center");
        dialogPanel.add((Component)buttonPanel, "South");
        UserStoreControl frame = control.getControl();
        this.dialog = new JDialog(control.getControl().getFrame(), "User Store Activation Wizard", true);
        this.dialog.setContentPane(dialogPanel);
        ((Component)this.dialog).setBounds((int)frame.getLocationOnScreen().getX(), (int)frame.getLocationOnScreen().getY(), ((Component)frame).getWidth(), ((Component)frame).getHeight());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(this);
        this.step = -1;
        this.showNextStep();
        ((Component)this.dialog).setVisible(true);
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals(BACK_COMMAND)) {
            boolean successful = false;
            CardLayout cards = (CardLayout)this.wizard.getLayout();
            --this.step;
            this.steps[this.step].update();
            successful = this.steps[this.step].isSuccessful();
            cards.previous(this.wizard);
            while (successful && !this.steps[this.step].isNeeded() && this.step > 0) {
                --this.step;
                this.steps[this.step].update();
                successful = this.steps[this.step].isSuccessful();
                cards.previous(this.wizard);
            }
            this.nextButton.setText("Next");
            this.nextButton.setEnabled(true);
            this.dialog.setTitle(this.steps[this.step].getTitle());
            if (this.step == 0) {
                this.backButton.setEnabled(false);
            }
        }
        if (cmd.equals(CANCEL_COMMAND)) {
            ((Component)this.dialog).setVisible(false);
        }
        if (cmd.equals(NEXT_COMMAND)) {
            if (this.step == this.steps.length - 1) {
                try {
                    this.control.getControl().getControl().getSecurityInterface().getRemoteUserStoreFactory().setActiveUserStore(this.userStore);
                }
                catch (Exception e) {
                    ExceptionHandler.error("Unable to activate user store", e);
                }
                this.control.onSelectionChange(this.control.getSelectedConfiguration());
                ((Component)this.dialog).setVisible(false);
            } else {
                this.showNextStep();
                this.backButton.setEnabled(true);
            }
        }
        this.dialog.validate();
        this.dialog.repaint();
    }

    public void update() {
        this.nextButton.setEnabled(this.steps[this.step].isSuccessful());
    }

    public void windowClosing(WindowEvent we) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    private void showNextStep() {
        boolean successful = false;
        ++this.step;
        this.steps[this.step].update();
        successful = this.steps[this.step].isSuccessful();
        while (successful && !this.steps[this.step].isNeeded()) {
            ++this.step;
            this.steps[this.step].update();
            successful = this.steps[this.step].isSuccessful();
        }
        ((CardLayout)this.wizard.getLayout()).show(this.wizard, this.steps[this.step].getName());
        this.backButton.setEnabled(true);
        if (this.step == this.steps.length - 1) {
            this.nextButton.setText("Finish");
        }
        if (this.step == this.steps.length - 1) {
            this.nextButton.setText("Finish");
        }
        this.dialog.setTitle(this.steps[this.step].getTitle());
        this.nextButton.setEnabled(successful);
    }
}

