/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores.wizard;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.roles.IdentityMapPanelLogical;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardPanel;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardStep;
import com.sap.engine.services.security.gui.util.SortedComponentsList;
import com.sap.engine.services.security.remote.RemoteAuthorization;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.roles.RemoteSecurityRoles;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AuthorizationWizard
extends JPanel
implements WizardStep,
ActionListener,
ListSelectionListener {
    private RemoteSecurity security = null;
    boolean noSelection = false;
    boolean isSuccessful = false;
    private String newUserStore = null;
    private JButton ready = new JButton("ready");
    private JList list = new JList();
    private JLabel message = new JLabel();
    private IdentityMapPanelLogical login = null;
    private WizardPanel wizard = null;

    public AuthorizationWizard(WizardPanel wizard, SecurityControl security, String newUserStore) {
        this.security = security.getSecurityInterface();
        this.newUserStore = newUserStore;
        this.wizard = wizard;
        this.login = new IdentityMapPanelLogical(security, newUserStore);
        this.list = new SortedComponentsList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Unconfigured Components"));
        scroll.setPreferredSize(new Dimension(100, 40));
        JPanel left = new JPanel(new BorderLayout());
        left.add((Component)scroll, "Center");
        left.add((Component)this.ready, "South");
        this.ready.addActionListener(this);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(left);
        splitPane.setRightComponent(this.login);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(0.1);
        splitPane.setResizeWeight(0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        this.add((Component)this.message, "South");
    }

    public String getName() {
        return "Authorization";
    }

    public String getTitle() {
        return "Step 3: Change Security Roles' Mappings";
    }

    public boolean isNeeded() {
        return false;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public void update() {
        this.findTemplates();
    }

    public void actionPerformed(ActionEvent e) {
        this.isSuccessful = true;
        this.update();
    }

    public void valueChanged(ListSelectionEvent e) {
        try {
            if (this.noSelection || e.getValueIsAdjusting() || this.list.getSelectedValue() == null) {
                return;
            }
            this.showSelected();
        }
        catch (Exception exception) {
            ExceptionHandler.error("Unable to update authorization step dialog!", exception);
        }
    }

    private void showSelected() {
        this.login.onComponentChange((String)this.list.getSelectedValue());
    }

    private void findTemplates() {
        this.noSelection = true;
        try {
            try {
                String[] policies = this.security.listPolicyConfigurations();
                Vector<String> result = new Vector<String>();
                RemoteAuthorization authorization = null;
                RemoteSecurityRoles remoteRoles = null;
                SecurityRole[] oldRoles = null;
                SecurityRole[] newRoles = null;
                int i = 0;
                while (i < policies.length) {
                    block20: {
                        try {
                            authorization = this.security.getPolicyConfiguration(policies[i]).getAuthorization();
                            oldRoles = authorization.getSecurityRoles().listSecurityRoles();
                            remoteRoles = authorization.getSecurityRoles(this.newUserStore);
                            newRoles = remoteRoles.listSecurityRoles();
                            if (oldRoles == null || oldRoles.length <= 0) break block20;
                            if (newRoles == null || newRoles.length == 0) {
                                boolean onlyReferences = true;
                                int r = 0;
                                while (r < oldRoles.length) {
                                    if (oldRoles[r].getReference().length == 2) {
                                        remoteRoles.addSecurityRoleReference(oldRoles[r].getName(), oldRoles[r].getReference()[0], oldRoles[r].getReference()[1]);
                                    } else {
                                        SecurityRole role = remoteRoles.addSecurityRole(oldRoles[r].getName());
                                        role.setDescription(oldRoles[r].getDescription());
                                        remoteRoles.modifySecurityRole(role);
                                        if (onlyReferences && oldRoles[r].getUsers().length + oldRoles[r].getGroups().length > 0) {
                                            onlyReferences = false;
                                        }
                                    }
                                    ++r;
                                }
                                if (!onlyReferences) {
                                    result.add(policies[i]);
                                }
                                break block20;
                            }
                            if (newRoles.length <= 0) break block20;
                            int r = 0;
                            while (r < oldRoles.length) {
                                if (oldRoles[r].getReference().length != 2 && oldRoles[r].getUsers().length + oldRoles[r].getGroups().length > 0 && newRoles[r].getUsers().length + newRoles[r].getGroups().length == 0) {
                                    result.add(policies[i]);
                                    break;
                                }
                                ++r;
                            }
                        }
                        catch (Exception ee) {
                            ExceptionHandler.debug("Unable to obtain authorization configuration!", ee);
                        }
                    }
                    ++i;
                }
                Object selection = this.list.getSelectedValue();
                this.list.setListData(result);
                try {
                    this.list.setSelectedValue(selection, true);
                }
                catch (Exception e) {
                    ExceptionHandler.debug("Unable to change selected value!", e);
                }
                if (!this.isSuccessful) {
                    boolean bl = this.isSuccessful = result.size() == 0;
                }
                if (this.isSuccessful) {
                    this.message.setText(" All authorization components are configured. Click 'Next'!");
                } else {
                    this.message.setText(" Set security roles from the user store for the component '" + result.elementAt(0) + "'.");
                }
                this.wizard.update();
            }
            catch (Exception e) {
                ExceptionHandler.debug("Error in set up of authorization wizard step!", e);
                Object var12_17 = null;
                this.noSelection = false;
                this.showSelected();
            }
            Object var12_16 = null;
            this.noSelection = false;
            this.showSelected();
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            this.noSelection = false;
            this.showSelected();
            throw throwable;
        }
    }
}

