/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores.wizard;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.roles.IdentityMapPanelLogical;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardPanel;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardStep;
import com.sap.engine.services.security.gui.util.SortedComponentsList;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AuthorizationConfirmWizard
extends JPanel
implements WizardStep,
ListSelectionListener {
    private RemoteSecurity security = null;
    boolean isSuccessful = false;
    private JList list = new JList();
    private JLabel message = new JLabel();
    private IdentityMapPanelLogical login = null;
    private WizardPanel wizard = null;

    public AuthorizationConfirmWizard(WizardPanel wizard, SecurityControl security, String newUserStore) {
        this.security = security.getSecurityInterface();
        this.wizard = wizard;
        this.message.setText(" Check that all components are configured properly and click 'Next'!");
        this.login = new IdentityMapPanelLogical(security, newUserStore);
        this.list = new SortedComponentsList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "All Components"));
        scroll.setPreferredSize(new Dimension(100, 40));
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(scroll);
        splitPane.setRightComponent(this.login);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(0.1);
        splitPane.setResizeWeight(0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        this.add((Component)this.message, "South");
    }

    public String getName() {
        return "Authorization Confirmation";
    }

    public String getTitle() {
        return "Step 4: Confirm Authorization Modules";
    }

    public boolean isNeeded() {
        return true;
    }

    public boolean isSuccessful() {
        return true;
    }

    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getValueIsAdjusting() || this.list.getSelectedValue() == null) {
                return;
            }
            this.login.onComponentChange((String)this.list.getSelectedValue());
        }
        catch (Exception exception) {
            ExceptionHandler.error("Unable to update confirmation step dialog!", exception);
        }
    }

    public void update() {
        try {
            this.list.setListData(this.security.listPolicyConfigurations());
        }
        catch (Exception exception) {
            ExceptionHandler.error("Unable to update confirmation step dialog!", exception);
        }
    }
}

