/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores.wizard;

import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.jaas.LoginModuleControl;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardPanel;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardStep;
import com.sap.engine.services.security.gui.util.SortedComponentsList;
import com.sap.engine.services.security.remote.RemoteAuthentication;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.authentication.RemoteAppConfigurationEntry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AuthenticationTemplatesWizard
extends JPanel
implements WizardStep,
ActionListener,
ListSelectionListener {
    private RemoteSecurity security = null;
    boolean noSelection = false;
    boolean isSuccessful = false;
    private String newUserStore = null;
    private JButton ready = new JButton("ready");
    private JList list = new JList();
    private JLabel message = new JLabel();
    private LoginModuleControl login = null;
    private WizardPanel wizard = null;

    public AuthenticationTemplatesWizard(WizardPanel wizard, SecurityControl security, String newUserStore) {
        this.security = security.getSecurityInterface();
        this.newUserStore = newUserStore;
        this.wizard = wizard;
        this.login = new LoginModuleControl(security, newUserStore);
        this.list = new SortedComponentsList();
        this.list.setSelectionMode(0);
        this.list.addListSelectionListener(this);
        JScrollPane scroll = new JScrollPane(this.list);
        scroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Unconfigured Templates"));
        scroll.setPreferredSize(new Dimension(100, 40));
        JPanel left = new JPanel(new BorderLayout());
        left.add((Component)scroll, "Center");
        left.add((Component)this.ready, "South");
        this.ready.addActionListener(this);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(left);
        splitPane.setRightComponent(this.login);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(0.1);
        splitPane.setResizeWeight(0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        this.add((Component)this.message, "South");
    }

    public String getName() {
        return "Authentication";
    }

    public String getTitle() {
        return "Step 1: Mandatory Authentication Modules Change";
    }

    public boolean isNeeded() {
        return false;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public void update() {
        this.findTemplates();
    }

    public void actionPerformed(ActionEvent e) {
        this.isSuccessful = true;
        this.update();
    }

    public void valueChanged(ListSelectionEvent e) {
        try {
            if (this.noSelection || e.getValueIsAdjusting() || this.list.getSelectedValue() == null) {
                return;
            }
            this.showSelected();
        }
        catch (Exception exception) {
            ExceptionHandler.error("Unable to update authentication step dialog!", exception);
        }
    }

    private void showSelected() {
        this.login.onComponentChange((String)this.list.getSelectedValue());
    }

    private void findTemplates() {
        this.noSelection = true;
        try {
            try {
                String[] policies = this.security.listPolicyConfigurations();
                Vector<String> result = new Vector<String>();
                RemoteAuthentication authentication = null;
                int i = 0;
                while (i < policies.length) {
                    try {
                        authentication = this.security.getPolicyConfiguration(policies[i]).getAuthentication();
                        if (authentication.getTemplate() == null && authentication.getLoginModules().length != 0 && authentication.getLoginModules(this.newUserStore).length == 0 && !this.attemptFitTemplate(authentication)) {
                            result.add(policies[i]);
                        }
                    }
                    catch (Exception ee) {
                        ExceptionHandler.debug("Unable to obtain login module stack!", ee);
                    }
                    ++i;
                }
                Object selection = this.list.getSelectedValue();
                this.list.setListData(result);
                try {
                    this.list.setSelectedValue(selection, true);
                }
                catch (Exception e) {
                    ExceptionHandler.debug("Unable to determine selected value!", e);
                }
                if (!this.isSuccessful) {
                    boolean bl = this.isSuccessful = result.size() == 0;
                }
                if (this.isSuccessful) {
                    this.message.setText(" All authentication components are configured. Click 'Next'!");
                } else {
                    this.message.setText(" Set login modules from the user store for the component '" + result.elementAt(0) + "'.");
                }
                this.wizard.update();
            }
            catch (Exception e) {
                ExceptionHandler.debug("Unable to set up authentication templates!", e);
                Object var8_10 = null;
                this.noSelection = false;
                this.showSelected();
            }
            Object var8_9 = null;
            this.noSelection = false;
            this.showSelected();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.noSelection = false;
            this.showSelected();
            throw throwable;
        }
    }

    private boolean attemptFitTemplate(RemoteAuthentication authentication) {
        try {
            RemoteAppConfigurationEntry[] modules = authentication.getLoginModules();
            int[] index = new int[modules.length];
            LoginModuleConfiguration[] newModules = this.security.getRemoteUserStoreFactory().getUserStore(this.newUserStore).getConfiguration().getLoginModules();
            int i = 0;
            while (i < modules.length) {
                index[i] = -1;
                int j = 0;
                while (j < newModules.length) {
                    if (modules[i].getLoginModuleName().equals(newModules[j].getName())) {
                        index[i] = j;
                        break;
                    }
                    ++j;
                }
                if (index[i] < 0) {
                    return false;
                }
                ++i;
            }
            authentication.setLoginModules(this.newUserStore, modules);
            return true;
        }
        catch (Exception exception) {
            ExceptionHandler.debug("Unable to fit authentication templates!", exception);
            return false;
        }
    }
}

