/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores.wizard;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardPanel;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardStep;
import com.sap.engine.services.security.gui.userstore.usermanagement.UMHash;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.UserTreePanel;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.RemoteUserStore;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class AnonymousPrincipalConfirmWizard
extends JPanel
implements WizardStep,
TreeSelectionListener,
ListSelectionListener {
    private RemoteSecurity security = null;
    boolean isSuccessful = false;
    private String newUserStore = null;
    private JLabel principal = new JLabel();
    private JLabel message = new JLabel();
    private RemoteUserStore userStore = null;
    private UserTreePanel users = null;
    private WizardPanel wizard = null;

    public AnonymousPrincipalConfirmWizard(WizardPanel wizard, SecurityControl security, String newUserStore) {
        this.wizard = wizard;
        this.security = security.getSecurityInterface();
        this.newUserStore = newUserStore;
        try {
            this.userStore = this.security.getRemoteUserStoreFactory().getUserStore(this.newUserStore);
            this.users = new UserTreePanel(this.userStore);
            this.users.setFrame(security.getFrame());
            this.users.setUsersVisible(true);
            this.users.setGroupsVisible(false);
            this.users.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Users "));
            this.users.addTreeSelectionListener(this);
            this.users.addListSelectionListener(this);
            this.users.refresh(UMHash.getRoot(newUserStore));
        }
        catch (RemoteException re) {
            ExceptionHandler.error("Unable to initialize users panel!", re);
        }
        JPanel text = new JPanel();
        text.add(new JLabel("Anonymous User: "));
        text.add(this.principal);
        this.setLayout(new BorderLayout());
        this.add((Component)text, "North");
        this.add((Component)this.users, "Center");
        this.add((Component)this.message, "South");
    }

    public String getName() {
        return "Anonymous Principal Confirmation";
    }

    public String getTitle() {
        return "Step 5: Confirm Anonymous Principal";
    }

    public boolean isNeeded() {
        return true;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    public void update() {
        String userName = null;
        this.isSuccessful = false;
        try {
            userName = this.getSelectedPrincipal();
            this.principal.setText(userName);
            try {
                this.isSuccessful = this.userStore.getUserContext().getUserInfo(userName) != null;
            }
            catch (Exception e) {
                ExceptionHandler.debug("Test if username is found failed!", e);
                this.isSuccessful = false;
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to retrieve information of selected user!", e);
        }
        if (this.isSuccessful) {
            this.message.setText(" The user is eligable to be anonymous principal of the system.");
        } else {
            this.message.setText(" This name does not denote a valid user in the user store!");
        }
        this.wizard.update();
    }

    public void valueChanged(TreeSelectionEvent e) {
        Object selection = this.users.getSelectedUser();
        if (selection instanceof RemoteUserStoreInfo) {
            this.principal.setText(((RemoteUserStoreInfo)this.users.getSelectedUser()).getName());
            try {
                Properties properties = this.userStore.getConfiguration().getUserStoreProperties();
                properties.setProperty("anonymous-user", this.principal.getText().trim());
                this.userStore.setUserStoreProperties(properties);
            }
            catch (Exception exception) {
                ExceptionHandler.error("Unable to set up anonymous user!", exception);
            }
            this.update();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        Object selection = this.users.getSelectedUser();
        if (selection instanceof RemoteUserStoreInfo) {
            this.principal.setText(((RemoteUserStoreInfo)this.users.getSelectedUser()).getName());
            try {
                Properties properties = this.userStore.getConfiguration().getUserStoreProperties();
                properties.setProperty("anonymous-user", this.principal.getText().trim());
                this.userStore.setUserStoreProperties(properties);
            }
            catch (Exception exception) {
                ExceptionHandler.error("Unable to set up anonymous user!", exception);
            }
            this.update();
        }
    }

    private String getSelectedPrincipal() {
        try {
            return this.userStore.getConfiguration().getUserStoreProperties().getProperty("anonymous-user");
        }
        catch (RemoteException e) {
            ExceptionHandler.debug("Unable to get anonymous user!", e);
            return null;
        }
    }
}

