/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores.wizard;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardPanel;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardStep;
import com.sap.engine.services.security.remote.RemoteGroupContext;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteIterator;
import com.sap.engine.services.security.remote.RemotePolicyConfiguration;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.RemoteUserStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class AdministratorPasswordCheckWizard
extends JPanel
implements KeyListener,
WizardStep {
    private RemoteSecurity security = null;
    boolean isSuccessful = false;
    private String newUserStore = null;
    private JTextField user = new JTextField("", 20);
    private JPasswordField password = new JPasswordField("", 20);
    private JLabel message = new JLabel();
    private RemoteUserStore userStore = null;
    private WizardPanel wizard = null;

    public AdministratorPasswordCheckWizard(WizardPanel wizard, SecurityControl security, String newUserStore) {
        this.wizard = wizard;
        this.security = security.getSecurityInterface();
        this.newUserStore = newUserStore;
        JPanel accountPanel = new JPanel();
        JPanel account = new JPanel(new GridLayout(2, 2));
        account.add(new JLabel("Administrator Account: "));
        account.add(this.user);
        account.add(new JLabel("             Password: "));
        account.add(this.password);
        accountPanel.add(account);
        this.message.setText(" Check the password of an administrator!");
        this.setLayout(new BorderLayout());
        this.add((Component)accountPanel, "Center");
        this.add((Component)this.message, "South");
        this.user.addKeyListener(this);
        this.password.addKeyListener(this);
    }

    public String getName() {
        return "Check Password Of An Administrator";
    }

    public String getTitle() {
        return "Step 6: Test Administrator Of New User Store";
    }

    public boolean isNeeded() {
        return true;
    }

    public boolean isSuccessful() {
        String userName = this.user.getText().trim();
        RemoteGroupContext groupContext = null;
        if (userName.length() == 0) {
            return false;
        }
        try {
            this.userStore = this.security.getRemoteUserStoreFactory().getUserStore(this.newUserStore);
            groupContext = this.userStore.getGroupContext();
            if (this.isInRole(groupContext, userName, "SAP-J2EE-Engine", "administrators") && this.isInAllRoles(groupContext, userName, "service.naming")) {
                return this.checkPassword(userName);
            }
            return false;
        }
        catch (Exception e) {
            this.message.setText(" Authentication did not succeed !");
            ExceptionHandler.error(" Authentication did not succeed !", e);
            return false;
        }
    }

    public void update() {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent event) {
        if (event.getKeyCode() == 10) {
            this.wizard.update();
        }
    }

    private boolean checkPassword(String userName) {
        boolean result = false;
        try {
            char[] password = this.password.getPassword();
            result = this.userStore.getUserContext().getUserInfo(userName).checkUserProperty(9, password);
        }
        catch (Exception e) {
            ExceptionHandler.debug("Password check failed.", e);
            result = false;
        }
        if (!result) {
            this.message.setText(" Incorrect password !");
        } else {
            this.message.setText(" Authentication is successful !");
        }
        return result;
    }

    private boolean isInAllRoles(RemoteGroupContext groupContext, String userName, String policyName) throws Exception {
        RemotePolicyConfiguration policy = this.security.getPolicyConfiguration(policyName);
        SecurityRole[] roles = policy.getAuthorization().getSecurityRoles(this.newUserStore).listSecurityRoles();
        int i = 0;
        while (i < roles.length) {
            if (!this.isInRole(groupContext, userName, policyName, roles[i])) {
                this.message.setText(" User is not an administrator! Not in role <" + roles[i].getName() + "> of policy configuration <" + policyName + ">");
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isInRole(RemoteGroupContext groupContext, String userName, String policyName, String roleName) throws Exception {
        RemotePolicyConfiguration policy = this.security.getPolicyConfiguration(policyName);
        SecurityRole[] roles = policy.getAuthorization().getSecurityRoles(this.newUserStore).listSecurityRoles();
        int i = 0;
        while (i < roles.length) {
            if (roleName.equals(roles[i].getName())) {
                if (this.isInRole(groupContext, userName, policyName, roles[i])) {
                    return true;
                }
                this.message.setText(" User is not an administrator! Not in role <" + roleName + "> of policy configuration <" + policyName + ">");
                return false;
            }
            ++i;
        }
        this.message.setText(" Required role <" + roleName + "> of policy configuration <" + policyName + "> is missing!");
        return false;
    }

    private boolean isInRole(RemoteGroupContext groupContext, String userName, String policyName, SecurityRole role) throws Exception {
        String[] users = role.getUsers();
        int i = 0;
        while (i < users.length) {
            if (users[i].equals(userName)) {
                return true;
            }
            ++i;
        }
        String[] groups = role.getGroups();
        if (groupContext != null) {
            int i2 = 0;
            while (i2 < groups.length) {
                if (this.isInGroup(groupContext, userName, groupContext.getGroupInfo(groups[i2]))) {
                    return true;
                }
                ++i2;
            }
        }
        this.message.setText(" User is not an administrator! Not in role <" + role.getName() + "> of policy configuration <" + policyName + ">");
        return false;
    }

    private boolean isInGroup(RemoteGroupContext groupContext, String userName, RemoteGroupInfo group) throws Exception {
        RemoteIterator users = group.getUsersInGroup();
        while (users.hasNext()) {
            if (!userName.equals(users.next())) continue;
            return true;
        }
        RemoteIterator groups = group.getChildGroups();
        while (groups.hasNext()) {
            if (!this.isInGroup(groupContext, userName, groupContext.getGroupInfo((String)groups.next()))) continue;
            return true;
        }
        return false;
    }
}

