/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.UserStoreControl;
import com.sap.engine.services.security.gui.userstore.stores.ActiveUserStoreWizard;
import com.sap.engine.services.security.gui.userstore.stores.AddLoginModuleAction;
import com.sap.engine.services.security.gui.userstore.stores.GoToActiveStoreAction;
import com.sap.engine.services.security.gui.userstore.stores.ModifyConfigurationAction;
import com.sap.engine.services.security.gui.userstore.stores.NewUserStoreAction;
import com.sap.engine.services.security.gui.userstore.stores.PropertiesAction;
import com.sap.engine.services.security.gui.userstore.stores.RemoveLoginModuleAction;
import com.sap.engine.services.security.gui.userstore.stores.RemoveUserStoreAction;
import com.sap.engine.services.security.gui.userstore.stores.UserStoreConfigurationPanel;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresList;
import com.sap.engine.services.security.remote.RemoteUserStoreFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class UserStoresPanel
extends JPanel {
    private RemoteUserStoreFactory runtime = null;
    private UserStoreControl control = null;
    private UserStoreConfiguration selectedConfiguration = null;
    private UserStoreConfigurationPanel configuration = null;
    private UserStoresList list = null;
    private ActiveUserStoreWizard activeStoreWizard = null;
    private RemoveUserStoreAction removeAction = null;
    private AddLoginModuleAction addLoginModuleAction = null;
    private RemoveLoginModuleAction removeLoginModuleAction = null;
    private PropertiesAction propertiesAction = null;
    private ModifyConfigurationAction configurationAction = null;

    public UserStoresPanel(UserStoreControl control) {
        try {
            this.control = control;
            this.setLayout(new BorderLayout());
            this.configuration = new UserStoreConfigurationPanel(this);
            GoToActiveStoreAction activeStoreAction = new GoToActiveStoreAction(this);
            NewUserStoreAction userStoreAction = new NewUserStoreAction(this);
            this.activeStoreWizard = new ActiveUserStoreWizard(this);
            this.removeAction = new RemoveUserStoreAction(this);
            this.addLoginModuleAction = new AddLoginModuleAction(this);
            this.removeLoginModuleAction = new RemoveLoginModuleAction(this, this.configuration);
            this.propertiesAction = new PropertiesAction(this, this.configuration);
            this.configurationAction = new ModifyConfigurationAction(this);
            JPanel pane = new JPanel(new GridBagLayout());
            pane.add((Component)userStoreAction.getButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.removeAction.getButton(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.activeStoreWizard.getButton(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.configurationAction.getButton(), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)activeStoreAction.getButton(), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.addLoginModuleAction.getButton(), new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.removeLoginModuleAction.getButton(), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
            pane.add((Component)this.propertiesAction.getButton(), new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 15, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.list = new UserStoresList(this);
            this.add((Component)this.list, "West");
            this.add((Component)this.configuration, "Center");
            this.add((Component)pane, "East");
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to initialize user stores panel!", e);
        }
    }

    public UserStoreControl getControl() {
        return this.control;
    }

    public void update(RemoteUserStoreFactory service) {
        try {
            this.runtime = service;
            this.list.init(this.runtime);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to update user stores panel!", e);
        }
    }

    public UserStoreConfiguration getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    public void onSelectionChange(UserStoreConfiguration selection) {
        this.selectedConfiguration = selection;
        this.configuration.onSelectionChange(selection);
        this.activeStoreWizard.onSelectionChange(selection);
        this.removeAction.onSelectionChange(selection);
        this.addLoginModuleAction.onSelectionChange(selection);
        this.removeLoginModuleAction.onSelectionChange(selection);
        this.propertiesAction.onSelectionChange(selection);
    }

    public void refreshUserStores() {
        this.list.refresh();
    }

    public UserStoreConfigurationPanel getUserStoreConfigurationPanel() {
        return this.configuration;
    }
}

