/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import com.sap.engine.services.security.remote.RemoteUserStore;
import com.sap.engine.services.security.remote.RemoteUserStoreFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UserStoresList
extends JPanel
implements ListSelectionListener {
    private JList storesList;
    private RemoteUserStoreFactory remote = null;
    private UserStoresPanel control = null;
    private String[] stores = null;

    public UserStoresList(UserStoresPanel control) throws Exception {
        this.control = control;
        this.init(null);
    }

    private String[] getUserStoreNames() throws RemoteException {
        RemoteUserStore[] stores = this.remote != null ? this.remote.listUserStores() : new RemoteUserStore[]{};
        String[] names = new String[stores.length];
        int i = 0;
        while (i < names.length) {
            names[i] = stores[i].getConfiguration().getName();
            ++i;
        }
        return names;
    }

    public void init(RemoteUserStoreFactory remote) throws RemoteException {
        this.remote = remote;
        if (this.storesList == null) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " User Stores "));
            this.stores = this.getUserStoreNames();
            this.storesList = new JList<String>(this.stores);
            this.storesList.setSelectionMode(0);
            if (remote != null && remote.getActiveUserStore() != null) {
                this.storesList.setSelectedValue(remote.getActiveUserStore().getConfiguration().getName(), true);
            }
            this.storesList.addListSelectionListener(this);
            JScrollPane scroll = new JScrollPane(this.storesList);
            scroll.setPreferredSize(new Dimension(140, 40));
            this.add((Component)scroll, "Center");
        } else if (remote != null && remote.getActiveUserStore() != null) {
            this.stores = this.getUserStoreNames();
            this.storesList.setListData(this.stores);
            this.storesList.repaint();
            this.storesList.setSelectedValue(remote.getActiveUserStore().getConfiguration().getName(), true);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        try {
            String storeName = (String)this.storesList.getSelectedValue();
            if (storeName != null) {
                this.control.onSelectionChange(this.remote.getUserStore(storeName).getConfiguration());
            }
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to update selected user store!", ex);
        }
    }

    public void refresh() {
        try {
            this.stores = this.getUserStoreNames();
            this.storesList.setListData(this.stores);
            this.storesList.repaint();
            this.storesList.setSelectedValue(this.remote.getActiveUserStore().getConfiguration().getName(), true);
        }
        catch (RemoteException re) {
            ExceptionHandler.error("Unable to refresh user stores panel!", re);
        }
    }
}

