/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.interfaces.security.userstore.config.ConfigurationEditor;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.stores.DefaultConfigurationEditor;
import com.sap.engine.services.security.gui.userstore.stores.DefaultLoginModuleEditor;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UserStoreConfigurationPanel
extends JPanel {
    private UserStoresPanel control;
    private JPanel configuration = null;
    private JPanel lmPanel = null;
    private JTextArea description = null;
    private ConfigurationEditor editor = null;

    public UserStoreConfigurationPanel(UserStoresPanel control) {
        this.control = control;
        this.init();
    }

    public UserStoresPanel getControl() {
        return this.control;
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(400, 300));
        this.add((Component)this.getDescriptionPanel(), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getConfigurationPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getLoginModulePanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onSelectionChange(UserStoreConfiguration selection) {
        this.description.setText(selection.getDescription());
        this.getConfigurationPanel();
        this.getLoginModulePanel();
    }

    public JPanel getCurrentLoginModulePannel() {
        return this.lmPanel;
    }

    private JPanel getDescriptionPanel() {
        UserStoreConfiguration configuration = this.control.getSelectedConfiguration();
        String descriptionText = configuration == null ? "No user store!" : configuration.getDescription();
        this.description = new JTextArea(descriptionText);
        this.description.setEditable(false);
        JScrollPane scroll = new JScrollPane(this.description);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Description "));
        panel.add((Component)scroll, "Center");
        this.description.setBackground(panel.getBackground());
        return panel;
    }

    private Component getConfigurationPanel() {
        if (this.configuration == null) {
            this.configuration = new JPanel(new BorderLayout());
            this.configuration.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Configuration "));
        } else {
            this.configuration.remove(0);
        }
        this.configuration.add((Component)new JScrollPane(this.updateConfigurationPanel()), "Center");
        this.configuration.validate();
        return this.configuration;
    }

    private Component getLoginModulePanel() {
        if (this.lmPanel == null) {
            this.lmPanel = new JPanel(new BorderLayout());
            this.lmPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Login Modules "));
        } else {
            this.lmPanel.remove(0);
        }
        this.lmPanel.add((Component)new JScrollPane(this.updateLoginModulePanel()), "Center");
        this.lmPanel.validate();
        return this.lmPanel;
    }

    private Component updateConfigurationPanel() {
        String className;
        UserStoreConfiguration configuration = this.control.getSelectedConfiguration();
        if (configuration != null && (className = configuration.getConfigurationEditorClassName()) != null) {
            try {
                this.editor = (ConfigurationEditor)Class.forName(className).newInstance();
            }
            catch (Throwable t) {
                ExceptionHandler.debug("Unable to load configuration editor!", t);
                this.editor = null;
            }
        }
        if (this.editor == null) {
            this.editor = new DefaultConfigurationEditor();
        }
        if (configuration != null) {
            this.editor.setConfiguration(this.control.getSelectedConfiguration());
        }
        return (Component)((Object)this.editor);
    }

    private JPanel updateLoginModulePanel() {
        UserStoreConfiguration configuration = this.control.getSelectedConfiguration();
        DefaultLoginModuleEditor editor = null;
        if (configuration != null) {
            editor = new DefaultLoginModuleEditor();
            editor.setConfiguration(configuration.getLoginModules());
        }
        return editor;
    }

    protected ConfigurationEditor getConfigurationEditor() {
        return this.editor;
    }
}

