/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.SecurityServerFrame;
import com.sap.engine.services.security.gui.ExceptionHandler;
import java.lang.reflect.Method;
import java.util.Properties;

public class RuntimeUserStoreConfiguration
implements UserStoreConfiguration {
    public static final long serialVersionUID = 2697243797387521990L;
    private String anonymous = null;
    private String name = null;
    private String description = null;
    private String userSpi = null;
    private String groupSpi = null;
    private String editor = null;
    private Properties properties = null;
    private UserStoreConfiguration configuration = null;
    private LoginModuleConfiguration[] loginModules = null;

    public RuntimeUserStoreConfiguration(UserStoreConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getAnonymousUser() {
        return this.anonymous;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        if (this.configuration != null) {
            return this.configuration.getDescription();
        }
        return null;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.configuration != null) {
            return this.configuration.getName();
        }
        return null;
    }

    public LoginModuleConfiguration[] getLoginModules() {
        if (this.loginModules != null) {
            return this.loginModules;
        }
        if (this.configuration != null) {
            return this.configuration.getLoginModules();
        }
        return new LoginModuleConfiguration[0];
    }

    public String getUserSpiClassName() {
        if (this.userSpi != null) {
            return this.userSpi;
        }
        if (this.configuration != null) {
            return this.configuration.getUserSpiClassName();
        }
        return null;
    }

    public String getGroupSpiClassName() {
        if (this.groupSpi != null) {
            return this.groupSpi;
        }
        if (this.configuration != null) {
            return this.configuration.getGroupSpiClassName();
        }
        return null;
    }

    public Properties getUserStoreProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        if (this.configuration != null) {
            return this.configuration.getUserStoreProperties();
        }
        return null;
    }

    public String getConfigurationEditorClassName() {
        if (this.editor != null) {
            return this.editor;
        }
        if (this.configuration != null) {
            return this.configuration.getConfigurationEditorClassName();
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUserStoreProperties(Properties properties) {
        this.properties = properties;
    }

    public void setLoginModules(LoginModuleConfiguration[] loginModules) {
        this.loginModules = loginModules;
    }

    public void setUserSpiClassName(String className) {
        this.userSpi = className;
    }

    public void setGroupSpiClassName(String className) {
        this.groupSpi = className;
    }

    public void setConfigurationEditorClassName(String editor) {
        this.editor = editor;
    }

    public void setAnonymousUser(String anonymous) {
        this.anonymous = anonymous;
    }

    public void clearStartupConfiguration() {
        if (this.configuration == null) {
            return;
        }
        try {
            Method method = this.configuration.getClass().getMethod("clearStartupConfiguration", null);
            if (method != null) {
                method.invoke((Object)this.configuration, null);
            }
        }
        catch (Throwable e) {
            if (SystemProperties.getBoolean("server")) {
                SecurityServerFrame.getLogger().logThrowable((byte)3, e);
            }
            ExceptionHandler.debug("Unable to forward clearStartupConfiguration request to wrapped configuration!", e);
        }
    }
}

