/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.stores.ActionControl;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import com.sap.engine.services.security.remote.RemoteUserStore;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class RemoveUserStoreAction
implements ActionControl {
    private UserStoresPanel control = null;
    private JButton button = null;
    private String selectedStore = null;

    public RemoveUserStoreAction(UserStoresPanel control) {
        this.control = control;
        this.button = new JButton("Remove User Store");
        this.button.addActionListener(this);
    }

    public JButton getButton() {
        return this.button;
    }

    public void onSelectionChange(UserStoreConfiguration selection) {
        try {
            if (selection != null) {
                RemoteUserStore activeUserStore = this.control.getControl().getUserStoreFactory().getActiveUserStore();
                String activeUserStoreName = activeUserStore.getConfiguration().getName();
                this.selectedStore = selection.getName();
                this.button.setEnabled(!this.selectedStore.equals(activeUserStoreName));
            } else {
                this.button.setEnabled(false);
            }
        }
        catch (Exception e) {
            ExceptionHandler.debug("Unable to process selection change!", e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (this.selectedStore != null) {
            try {
                this.control.getControl().getUserStoreFactory().unregisterUserStore(this.selectedStore);
                this.control.refreshUserStores();
            }
            catch (Exception ex) {
                ExceptionHandler.error("Unable to remove user store!", ex);
            }
        }
    }
}

