/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.stores.ActionControl;
import com.sap.engine.services.security.gui.userstore.stores.DefaultLoginModuleEditor;
import com.sap.engine.services.security.gui.userstore.stores.RuntimeUserStoreConfiguration;
import com.sap.engine.services.security.gui.userstore.stores.UserStoreConfigurationPanel;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JScrollPane;

public class RemoveLoginModuleAction
implements ActionControl {
    private UserStoresPanel control = null;
    private UserStoreConfigurationPanel userStorePannel = null;
    private JButton button = null;
    private String selectedStore = null;

    public RemoveLoginModuleAction(UserStoresPanel control, UserStoreConfigurationPanel userStorePannel) {
        this.control = control;
        this.userStorePannel = userStorePannel;
        this.button = new JButton("Remove Login Module");
        this.button.addActionListener(this);
    }

    public JButton getButton() {
        return this.button;
    }

    public void onSelectionChange(UserStoreConfiguration selection) {
        this.selectedStore = selection.getName();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.selectedStore != null) {
            try {
                LoginModuleConfiguration[] loginModules = this.control.getSelectedConfiguration().getLoginModules();
                String[] selectedModules = ((DefaultLoginModuleEditor)((JScrollPane)this.userStorePannel.getCurrentLoginModulePannel().getComponent(0)).getViewport().getView()).getSelectedNames();
                if (selectedModules != null) {
                    LoginModuleConfiguration[] newModules = new LoginModuleConfiguration[loginModules.length - selectedModules.length];
                    RuntimeUserStoreConfiguration config = new RuntimeUserStoreConfiguration(this.control.getSelectedConfiguration());
                    int i = 0;
                    int j = 0;
                    while (i < loginModules.length) {
                        int k = 0;
                        while (k < selectedModules.length) {
                            if (loginModules[i].getName().equals(selectedModules[k])) break;
                            ++k;
                        }
                        if (k >= selectedModules.length) {
                            newModules[j] = loginModules[i];
                            ++j;
                        }
                        ++i;
                    }
                    config.setLoginModules(newModules);
                    this.control.getControl().getUserStoreFactory().updateUserStore(config);
                    this.control.onSelectionChange(config);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.error("Unable to remove Login Module!", ex);
            }
        }
    }
}

