/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.stores.ActionControl;
import com.sap.engine.services.security.gui.userstore.stores.DefaultLoginModuleEditor;
import com.sap.engine.services.security.gui.userstore.stores.LoginModuleDialog;
import com.sap.engine.services.security.gui.userstore.stores.RuntimeLoginModuleConfiguration;
import com.sap.engine.services.security.gui.userstore.stores.RuntimeUserStoreConfiguration;
import com.sap.engine.services.security.gui.userstore.stores.UserStoreConfigurationPanel;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import com.sap.engine.services.security.remote.RemoteAuthentication;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.authentication.RemoteAppConfigurationEntry;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.swing.JButton;
import javax.swing.JScrollPane;

public class PropertiesAction
implements ActionControl {
    private UserStoresPanel control = null;
    private JButton button = null;
    private String selectedStore = null;
    private UserStoreConfigurationPanel userStorePannel = null;

    public PropertiesAction(UserStoresPanel control, UserStoreConfigurationPanel userStorePannel) {
        this.control = control;
        this.userStorePannel = userStorePannel;
        this.button = new JButton("View / Change Properties");
        this.button.addActionListener(this);
    }

    public JButton getButton() {
        return this.button;
    }

    public void onSelectionChange(UserStoreConfiguration selection) {
        this.selectedStore = selection.getName();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.selectedStore != null) {
            String action = "show properties of";
            try {
                LoginModuleConfiguration[] loginModules = this.control.getSelectedConfiguration().getLoginModules();
                String[] selectedModules = ((DefaultLoginModuleEditor)((JScrollPane)this.userStorePannel.getCurrentLoginModulePannel().getComponent(0)).getViewport().getView()).getSelectedNames();
                if (selectedModules != null && selectedModules.length > 0) {
                    LoginModuleDialog editor = null;
                    int k = 0;
                    while (k < loginModules.length) {
                        if (loginModules[k].getName().equals(selectedModules[0])) {
                            editor = new LoginModuleDialog(this.control, "Edit Login Module", true, false, loginModules[k].getOptionsEditor());
                            editor.setClassName(loginModules[k].getLoginModuleClassName());
                            editor.setEditableClassName(false);
                            editor.setDescription(loginModules[k].getDescription());
                            editor.setName(loginModules[k].getName());
                            editor.setEditableDisplayName(false);
                            editor.setOptionsEditor(loginModules[k].getOptionsEditor());
                            editor.setOptions(loginModules[k].getOptions());
                            editor.setSuitableAuth(loginModules[k].getSuitableAuthenticationMechanisms());
                            editor.setNotSuitableAuth(loginModules[k].getNotSuitableAuthenticationMechanisms());
                            ((Component)editor).setSize(550, 510);
                            editor.setModal(true);
                            editor.setLocationRelativeTo(this.control);
                            ((Component)editor).setVisible(true);
                            break;
                        }
                        ++k;
                    }
                    if (editor != null && editor.isOK()) {
                        action = "edit";
                        String name = editor.getName();
                        String className = editor.getClassName();
                        Map options = editor.getOptions();
                        RemoteSecurity security = this.control.getControl().getControl().getSecurityInterface();
                        String[] policyConfigurations = security.listPolicyConfigurations();
                        if (policyConfigurations != null) {
                            int i = 0;
                            while (i < policyConfigurations.length) {
                                RemoteAuthentication authentication = security.getPolicyConfiguration(policyConfigurations[i]).getAuthentication();
                                RemoteAppConfigurationEntry[] entries = authentication.getLoginModules();
                                if (entries != null) {
                                    int j = 0;
                                    while (j < entries.length) {
                                        if (entries[j].getLoginModuleName().equals(name)) {
                                            entries[j] = new RemoteAppConfigurationEntry(new AppConfigurationEntry(className, entries[j].getControlFlag(), options), name);
                                            break;
                                        }
                                        ++j;
                                    }
                                    authentication.setLoginModules(entries);
                                }
                                ++i;
                            }
                        }
                        RuntimeUserStoreConfiguration config = new RuntimeUserStoreConfiguration(this.control.getSelectedConfiguration());
                        loginModules[k] = new RuntimeLoginModuleConfiguration(name, editor.getDescription(), className, options, editor.getSuitableAuth(), editor.getNotSuitableAuth(), editor.getOptionsEditor());
                        config.setLoginModules(loginModules);
                        this.control.getControl().getUserStoreFactory().updateUserStore(config);
                        this.control.onSelectionChange(config);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.error("Unable to " + action + " Login Module!", ex);
            }
        }
    }
}

