/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OptionsEditorDialog
extends CEscapeDialog
implements ActionListener {
    private static final String CHECK_CMD = "CHECK_CMD";
    private static final String OK_CMD = "OK_CMD";
    private static final String CANCEL_CMD = "CANCEL_CMD";
    private JPanel dialogPane = new JPanel(new BorderLayout());
    private JPanel centerPane = new JPanel(new GridBagLayout());
    private JPanel southPane = new JPanel(new FlowLayout());
    private JCheckBox checkBox = null;
    private JLabel label = null;
    private JTextField textField = null;
    private JButton okButt;
    private JButton cancelButt;
    private boolean isOK = false;

    public OptionsEditorDialog(UserStoresPanel control, String title, boolean modal) {
        super(control.getControl().getFrame(), title, modal);
        try {
            this.checkBox = new JCheckBox("Use a specific editor for the login module options.", false);
            this.checkBox.setActionCommand(CHECK_CMD);
            this.checkBox.addActionListener(this);
            this.label = new JLabel("Editor class name: ");
            this.textField = new JTextField();
            this.textField.setPreferredSize(new Dimension(400, 10));
            this.textField.setEditable(false);
            this.centerPane.add((Component)this.checkBox, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.centerPane.add((Component)this.label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.centerPane.add((Component)this.textField, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.okButt = new JButton("   OK  ");
            this.cancelButt = new JButton("Cancel");
            this.okButt.setActionCommand(OK_CMD);
            this.okButt.addActionListener(this);
            this.cancelButt.setActionCommand(CANCEL_CMD);
            this.cancelButt.addActionListener(this);
            this.southPane.add(this.okButt);
            this.southPane.add(this.cancelButt);
            this.dialogPane.add((Component)this.centerPane, "Center");
            this.dialogPane.add((Component)this.southPane, "South");
            this.getContentPane().add(this.dialogPane);
            this.pack();
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to visualize options editor!", ex);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(CHECK_CMD)) {
            this.checkAction();
        } else if (e.getActionCommand().equals(CANCEL_CMD)) {
            this.cancelAction();
        } else if (e.getActionCommand().equals(OK_CMD)) {
            this.okAction();
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public String getEditorClassName() {
        return this.textField.getText();
    }

    public void setEditorClassName(String editor) {
        this.textField.setText(editor);
    }

    private void checkAction() {
        if (this.checkBox.isSelected()) {
            this.textField.setEditable(true);
            this.repaint();
        } else {
            this.textField.setText("");
            this.textField.setEditable(false);
            this.repaint();
        }
    }

    private void cancelAction() {
        this.isOK = false;
        this.textField.setText("");
        ((Component)this).setVisible(false);
    }

    private void okAction() {
        this.isOK = true;
        ((Component)this).setVisible(false);
    }
}

