/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.gui.CFileChooser;
import com.sap.engine.interfaces.security.userstore.config.ConfigurationEditor;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.security.exceptions.BaseSecurityException;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.stores.DefaultConfigurationEditor;
import com.sap.engine.services.security.gui.userstore.stores.DefaultLoginModuleEditor;
import com.sap.engine.services.security.gui.userstore.stores.RuntimeUserStoreConfiguration;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import com.sap.engine.services.security.userstore.descriptor.DefaultUserStoreConfiguration;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NewUserStoreDialog
extends CEscapeDialog
implements ActionListener {
    private final String CANCEL0_ACTION_COMMAND = "CANCEL0_ACTION_COMMAND";
    private final String CANCEL_ACTION_COMMAND = "CANCEL_ACTION_COMMAND";
    private final String OK_ACTION_COMMAND = "OK_ACTION_COMMAND";
    private final String LOCATE_ACTION_COMMAND = "LOCATE_ACTION_COMMAND";
    private final String LOAD_ACTION_COMMAND = "LOAD_ACTION_COMMAND";
    private final String SKIP_ACTION_COMMAND = "SKIP_ACTION_COMMAND";
    private Frame frame = null;
    private boolean isOk = false;
    ConfigurationEditor propsPanel = new DefaultConfigurationEditor();
    JPanel lmPanel = new DefaultLoginModuleEditor();
    JPanel cards = null;
    JTextField configurationField = new JTextField("userstore.xml", 40);
    JTextField userSpiField = new JTextField("", 20);
    JTextField groupSpiField = new JTextField("", 20);
    JTextField displayField = new JTextField("", 20);
    JTextField descriptionField = new JTextField("", 20);
    UserStoresPanel control = null;
    UserStoreConfiguration configuration = null;
    RuntimeUserStoreConfiguration runtimeConfiguration = null;

    public NewUserStoreDialog(Frame frame, UserStoresPanel control) {
        super(frame, "Add New User Store", true);
        this.control = control;
        this.frame = frame;
        try {
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to visualize user store input dialog", ex);
        }
    }

    private void init() {
        this.cards = new JPanel(new CardLayout());
        JPanel configPanel = new JPanel(new GridBagLayout());
        configPanel.add((Component)new JLabel("User Store Display Name: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        configPanel.add((Component)new JLabel("UserContextSpi class: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        configPanel.add((Component)new JLabel("GroupContextSpi class: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        configPanel.add((Component)new JLabel("Description: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 0), 0, 0));
        configPanel.add((Component)this.displayField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        configPanel.add((Component)this.userSpiField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        configPanel.add((Component)this.groupSpiField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        configPanel.add((Component)this.descriptionField, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JButton okButt = new JButton("  OK  ");
        okButt.setActionCommand("OK_ACTION_COMMAND");
        okButt.addActionListener(this);
        JButton cancelButt = new JButton("Cancel");
        cancelButt.setActionCommand("CANCEL_ACTION_COMMAND");
        cancelButt.addActionListener(this);
        JPanel southPane = new JPanel(new FlowLayout());
        southPane.add(okButt);
        southPane.add(cancelButt);
        JPanel dialogPane = new JPanel(new BorderLayout());
        dialogPane.add((Component)configPanel, "North");
        JScrollPane scroll1 = new JScrollPane((Component)((Object)this.propsPanel));
        scroll1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " User Store Properties "));
        scroll1.setPreferredSize(new Dimension(100, 200));
        dialogPane.add((Component)scroll1, "Center");
        dialogPane.add((Component)southPane, "South");
        JButton locateButt = new JButton("...");
        locateButt.setActionCommand("LOCATE_ACTION_COMMAND");
        locateButt.addActionListener(this);
        locateButt.setPreferredSize(new Dimension((int)locateButt.getPreferredSize().getWidth(), (int)this.configurationField.getPreferredSize().getHeight()));
        JPanel findPanel = new JPanel(new BorderLayout());
        JPanel locationPanel = new JPanel(new GridBagLayout());
        locationPanel.add((Component)new JLabel(" Locate A User Store Configuration: "), new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        locationPanel.add((Component)this.configurationField, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        locationPanel.add((Component)locateButt, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
        locationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " User Store Configuration Location "));
        findPanel.add((Component)locationPanel, "Center");
        JButton loadButt = new JButton("Load File");
        loadButt.setActionCommand("LOAD_ACTION_COMMAND");
        loadButt.addActionListener(this);
        JButton skipButt = new JButton("Not From A File");
        skipButt.setActionCommand("SKIP_ACTION_COMMAND");
        skipButt.addActionListener(this);
        JButton cancel0Butt = new JButton("Cancel");
        cancel0Butt.setActionCommand("CANCEL0_ACTION_COMMAND");
        cancel0Butt.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(loadButt);
        buttonPanel.add(skipButt);
        buttonPanel.add(cancel0Butt);
        findPanel.add((Component)buttonPanel, "South");
        this.cards.add((Component)findPanel, "Locate");
        this.cards.add((Component)dialogPane, "Confirm");
        ((CardLayout)this.cards.getLayout()).show(this.cards, "Locate");
        this.getContentPane().add(this.cards);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("OK_ACTION_COMMAND")) {
            this.isOk = true;
            this.okAction();
        } else if (command.equals("CANCEL_ACTION_COMMAND")) {
            this.isOk = false;
            ((Component)this).setVisible(false);
        } else if (command.equals("LOCATE_ACTION_COMMAND")) {
            this.locateAction();
        } else if (command.equals("LOAD_ACTION_COMMAND")) {
            this.loadAction();
        } else if (command.equals("SKIP_ACTION_COMMAND")) {
            this.skipAction();
        } else if (command.equals("CANCEL0_ACTION_COMMAND")) {
            this.cancelAction();
        }
    }

    private void okAction() {
        if (this.displayField.getText().trim().length() == 0) {
            ExceptionHandler.error("Give a name to the user store!", null);
            return;
        }
        if (this.groupSpiField.getText().trim().length() == 0 && this.userSpiField.getText().trim().length() == 0) {
            ExceptionHandler.error("At least one SPI implementation is needed!", null);
            return;
        }
        this.runtimeConfiguration = new RuntimeUserStoreConfiguration(this.configuration);
        this.runtimeConfiguration.setName(this.displayField.getText());
        if (this.groupSpiField.getText().trim().length() != 0) {
            this.runtimeConfiguration.setGroupSpiClassName(this.groupSpiField.getText());
        }
        if (this.userSpiField.getText().trim().length() != 0) {
            this.runtimeConfiguration.setUserSpiClassName(this.userSpiField.getText());
        }
        this.runtimeConfiguration.setUserStoreProperties(this.propsPanel.getConfiguration());
        this.runtimeConfiguration.setDescription(this.descriptionField.getText());
        ((Component)this).setVisible(false);
    }

    private void locateAction() {
        CFileChooser fileChooser = new CFileChooser(this.frame);
        fileChooser.addFileFilter("User Store Configuration (*.xml)", "xml");
        String[] files = fileChooser.showFileDialog("Locate User Store Configuration", false);
        if (files != null && files.length > 0) {
            this.configurationField.setText(files[0]);
        }
    }

    private void skipAction() {
        ((CardLayout)this.cards.getLayout()).show(this.cards, "Confirm");
    }

    private void cancelAction() {
        ((Component)this).setVisible(false);
    }

    private void loadAction() {
        try {
            this.configuration = this.parse(new FileInputStream(this.configurationField.getText().trim()));
            if (this.configuration == null) {
                throw new BaseSecurityException("security_0502");
            }
            this.displayField.setText(this.configuration.getName());
            this.userSpiField.setText(this.configuration.getUserSpiClassName());
            this.groupSpiField.setText(this.configuration.getGroupSpiClassName());
            this.descriptionField.setText(this.configuration.getDescription());
            this.propsPanel.setConfiguration(this.configuration);
            ((CardLayout)this.cards.getLayout()).show(this.cards, "Confirm");
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to load user store configuration from the file!", e);
        }
    }

    public UserStoreConfiguration getUserStoreConfiguration() {
        if (this.isOk) {
            return this.runtimeConfiguration;
        }
        return null;
    }

    private UserStoreConfiguration parse(InputStream in) throws Exception {
        System.setProperty("server.parser.inqmy", "yes");
        StandardDOMParser parser = new StandardDOMParser();
        Document document = parser.parse(in);
        Node descriptor = null;
        NodeList descriptorList = document.getChildNodes();
        int i = 0;
        while (i < descriptorList.getLength()) {
            descriptor = descriptorList.item(i);
            if (descriptor.getNodeType() == 1) break;
            ++i;
        }
        if (descriptor != null) {
            NodeList storesList = descriptor.getChildNodes();
            int i2 = 0;
            while (i2 < storesList.getLength()) {
                Node userstoreElement = storesList.item(i2);
                if (userstoreElement.getNodeType() == 1) {
                    return new DefaultUserStoreConfiguration(storesList.item(i2));
                }
                ++i2;
            }
        }
        return null;
    }
}

