/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.LoginModuleOptionsEditor;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.stores.AuthenticationMechanismsTableModel;
import com.sap.engine.services.security.gui.userstore.stores.DefaultOptionsEditor;
import com.sap.engine.services.security.gui.userstore.stores.NonEditableTableModel;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class LoginModuleDialog
extends CEscapeDialog
implements ActionListener {
    private static final String[] MECHANISMS = new String[]{"BASIC", "FORM", "CLIENT_CERT", "DIGEST"};
    private JPanel dialogPane = new JPanel(new BorderLayout());
    private JPanel centerPane = new JPanel(new GridBagLayout());
    private JPanel southPane = new JPanel(new FlowLayout());
    private JPanel suitablePane = new JPanel();
    private JPanel notSuitablePane = new JPanel();
    private JTextField moduleNameField;
    private JTextField moduleClassNameField;
    private JTextField descriptionField;
    private JTextField editorField;
    private JScrollPane scrollOptions;
    private JTable mechanismsTable;
    private JTable suitableTable;
    private JScrollPane scrollMechanisms;
    private JScrollPane scrollSuitable;
    private JTable notSuitableTable;
    private JScrollPane scrollNotSuitable;
    private DefaultTableModel mechanismsModel;
    private DefaultTableModel suitableModel;
    private DefaultTableModel notSuitableModel;
    private LoginModuleOptionsEditor optionsEditor;
    private JLabel moduleNameLabel = new JLabel("Display Name: ");
    private JLabel moduleClassNameLabel = new JLabel("Class Name: ");
    private JLabel descriptionLabel = new JLabel("Description: ");
    private JLabel editorLabel = new JLabel("Options editor: ");
    private JButton addSuitableButton;
    private JButton removeSuitableButton;
    private JButton addNotSuitableButton;
    private JButton removeNotSuitableButton;
    private JButton okButt;
    private JButton cancelButt;
    private boolean isOK = false;
    private boolean isForAdding = false;
    private UserStoresPanel control = null;

    public LoginModuleDialog(UserStoresPanel control, String title, boolean modal, boolean isForAdding, String editorName) {
        super(control.getControl().getFrame(), title, modal);
        this.isForAdding = isForAdding;
        try {
            this.init(control, editorName);
            this.pack();
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to visualize login module dialog!", ex);
        }
    }

    public LoginModuleDialog() {
        super((Frame)null, "", false);
    }

    void init(UserStoresPanel control, String editorName) throws Exception {
        this.control = control;
        this.isOK = false;
        this.moduleNameField = new JTextField();
        this.moduleNameField.setPreferredSize(new Dimension(450, 10));
        this.moduleClassNameField = new JTextField();
        this.moduleClassNameField.setPreferredSize(new Dimension(450, 10));
        this.descriptionField = new JTextField();
        this.descriptionField.setPreferredSize(new Dimension(450, 10));
        this.editorField = new JTextField();
        this.editorField.setPreferredSize(new Dimension(450, 10));
        this.editorField.setText(editorName);
        if (editorName != null && !editorName.equals("")) {
            try {
                this.optionsEditor = (LoginModuleOptionsEditor)Class.forName(editorName).newInstance();
            }
            catch (Exception e) {
                ExceptionHandler.warning("The specified editor cannot be loaded! The default one will be used.", e);
            }
        }
        if (this.optionsEditor == null || !(this.optionsEditor instanceof Component)) {
            this.optionsEditor = new DefaultOptionsEditor();
        }
        this.scrollOptions = new JScrollPane((Component)((Object)this.optionsEditor));
        this.scrollOptions.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Options"));
        this.mechanismsModel = new AuthenticationMechanismsTableModel(new String[][]{{""}}, new String[]{""});
        this.mechanismsTable = new JTable(this.mechanismsModel);
        int i = 0;
        while (i < MECHANISMS.length) {
            this.mechanismsModel.setValueAt(MECHANISMS[i], i, 0);
            ++i;
        }
        this.mechanismsTable.setBorder(BorderFactory.createEtchedBorder());
        TableColumn keysColumn = this.mechanismsTable.getColumnModel().getColumn(0);
        keysColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        this.scrollMechanisms = new JScrollPane(this.mechanismsTable);
        this.scrollMechanisms.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Authentication Mechanisms"));
        this.suitableModel = new NonEditableTableModel(new String[][]{{""}}, new String[]{""});
        this.suitableTable = new JTable(this.suitableModel);
        this.suitableTable.setBorder(BorderFactory.createEtchedBorder());
        keysColumn = this.suitableTable.getColumnModel().getColumn(0);
        keysColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        this.scrollSuitable = new JScrollPane(this.suitableTable);
        this.scrollSuitable.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Suitable Authentication Mechanisms"));
        this.notSuitableModel = new NonEditableTableModel(new String[][]{{""}}, new String[]{""});
        this.notSuitableTable = new JTable(this.notSuitableModel);
        this.notSuitableTable.setBorder(BorderFactory.createEtchedBorder());
        keysColumn = this.notSuitableTable.getColumnModel().getColumn(0);
        keysColumn.setCellEditor(new DefaultCellEditor(new JTextField()));
        this.scrollNotSuitable = new JScrollPane(this.notSuitableTable);
        this.scrollNotSuitable.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Non-Suitable Authentication Mechanisms"));
        this.addSuitableButton = new JButton("Add");
        this.addSuitableButton.setActionCommand("ADD_SUITABLE_CMD");
        this.addSuitableButton.addActionListener(this);
        this.removeSuitableButton = new JButton("Remove");
        this.removeSuitableButton.setActionCommand("REMOVE_SUITABLE_CMD");
        this.removeSuitableButton.addActionListener(this);
        this.addNotSuitableButton = new JButton("Add");
        this.addNotSuitableButton.setActionCommand("ADD_NOT_SUITABLE_CMD");
        this.addNotSuitableButton.addActionListener(this);
        this.removeNotSuitableButton = new JButton("Remove");
        this.removeNotSuitableButton.setActionCommand("REMOVE_NOT_SUITABLE_CMD");
        this.removeNotSuitableButton.addActionListener(this);
        this.okButt = new JButton("   OK  ");
        this.cancelButt = new JButton("Cancel");
        this.okButt.setActionCommand("OK_CMD");
        this.okButt.addActionListener(this);
        this.cancelButt.setActionCommand("CANCEL_CMD");
        this.cancelButt.addActionListener(this);
        this.southPane.add(this.okButt);
        this.southPane.add(this.cancelButt);
        this.suitablePane.setLayout(new BorderLayout());
        JPanel suitableBtns = new JPanel(new GridBagLayout());
        suitableBtns.add((Component)this.addSuitableButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(10, 0, 5, 10), 0, 0));
        suitableBtns.add((Component)this.removeSuitableButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.suitablePane.add((Component)suitableBtns, "West");
        this.suitablePane.add((Component)this.scrollSuitable, "Center");
        this.notSuitablePane.setLayout(new BorderLayout());
        JPanel notSuitableBtns = new JPanel(new GridBagLayout());
        notSuitableBtns.add((Component)this.addNotSuitableButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(10, 0, 5, 10), 0, 0));
        notSuitableBtns.add((Component)this.removeNotSuitableButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.notSuitablePane.add((Component)notSuitableBtns, "West");
        this.notSuitablePane.add((Component)this.scrollNotSuitable, "Center");
        this.centerPane.add((Component)this.moduleClassNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.moduleClassNameField, new GridBagConstraints(1, 0, 4, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.moduleNameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.moduleNameField, new GridBagConstraints(1, 1, 4, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPane.add((Component)this.descriptionLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 10, 5), 0, 0));
        this.centerPane.add((Component)this.descriptionField, new GridBagConstraints(1, 2, 4, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
        this.centerPane.add((Component)this.editorLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 10, 5), 0, 0));
        this.centerPane.add((Component)this.editorField, new GridBagConstraints(1, 3, 4, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 10, 5), 0, 0));
        this.centerPane.add((Component)this.scrollOptions, new GridBagConstraints(0, 4, 5, 6, 0.1, 1.0, 10, 1, new Insets(10, 5, 10, 5), 0, 0));
        this.centerPane.add((Component)this.scrollMechanisms, new GridBagConstraints(0, 11, 2, 4, 0.6, 0.0, 10, 1, new Insets(41, 5, 47, 5), 0, 0));
        this.centerPane.add((Component)this.suitablePane, new GridBagConstraints(2, 10, 3, 2, 1.0, 0.0, 10, 1, new Insets(10, 5, 10, 5), 0, 0));
        this.centerPane.add((Component)this.notSuitablePane, new GridBagConstraints(2, 13, 3, 2, 1.0, 0.0, 10, 1, new Insets(10, 5, 10, 5), 0, 0));
        this.dialogPane.add((Component)this.centerPane, "Center");
        this.dialogPane.add((Component)this.southPane, "South");
        this.getContentPane().add(this.dialogPane);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ADD_SUITABLE_CMD")) {
            this.addSuitableAction();
        } else if (e.getActionCommand().equals("REMOVE_SUITABLE_CMD")) {
            this.removeSuitableAction();
        } else if (e.getActionCommand().equals("ADD_NOT_SUITABLE_CMD")) {
            this.addNotSuitableAction();
        } else if (e.getActionCommand().equals("REMOVE_NOT_SUITABLE_CMD")) {
            this.removeNotSuitableAction();
        } else if (e.getActionCommand().equals("CANCEL_CMD")) {
            this.cancelAction();
        } else if (e.getActionCommand().equals("OK_CMD")) {
            this.okAction();
        }
    }

    public Map getOptions() {
        return this.optionsEditor.getOptions();
    }

    public void setOptions(Map options) {
        this.optionsEditor.setOptions(options);
    }

    public String[] getSuitableAuth() {
        int rows = this.suitableModel.getRowCount();
        Vector<Object> mechanisms = new Vector<Object>();
        int i = 0;
        while (i < rows) {
            Object value = this.suitableModel.getValueAt(i, 0);
            if (value != null && !"".equals(value.toString())) {
                mechanisms.add(value);
            }
            ++i;
        }
        Object[] array = mechanisms.toArray();
        String[] result = new String[array.length];
        int i2 = 0;
        while (i2 < array.length) {
            result[i2] = (String)array[i2];
            ++i2;
        }
        return result;
    }

    public String[] getNotSuitableAuth() {
        int rows = this.notSuitableModel.getRowCount();
        Vector<Object> mechanisms = new Vector<Object>();
        int i = 0;
        while (i < rows) {
            Object value = this.notSuitableModel.getValueAt(i, 0);
            if (value != null && !"".equals(value.toString())) {
                mechanisms.add(value);
            }
            ++i;
        }
        Object[] array = mechanisms.toArray();
        String[] result = new String[array.length];
        int i2 = 0;
        while (i2 < array.length) {
            result[i2] = (String)array[i2];
            ++i2;
        }
        return result;
    }

    public boolean isOK() {
        return this.isOK;
    }

    public String getName() {
        return this.moduleNameField.getText();
    }

    public String getClassName() {
        return this.moduleClassNameField.getText();
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public String getOptionsEditor() {
        return this.editorField.getText();
    }

    public void setName(String name) {
        this.moduleNameField.setText(name);
    }

    public void setEditableClassName(boolean editable) {
        this.moduleClassNameField.setEditable(editable);
    }

    public void setEditableDisplayName(boolean editable) {
        this.moduleNameField.setEditable(editable);
    }

    public void setClassName(String name) {
        this.moduleClassNameField.setText(name);
    }

    public void setDescription(String description) {
        this.descriptionField.setText(description);
    }

    public void setOptionsEditor(String editor) {
        this.editorField.setText(editor);
    }

    public void setSuitableAuth(String[] mechanisms) {
        int count = this.suitableModel.getRowCount();
        int i = 0;
        while (i < count) {
            this.suitableModel.removeRow(0);
            ++i;
        }
        if (mechanisms != null && mechanisms.length > 0) {
            int i2 = 0;
            while (i2 < mechanisms.length) {
                this.suitableModel.addRow(new String[]{mechanisms[i2]});
                ++i2;
            }
        } else {
            this.suitableModel.addRow(new String[]{""});
        }
    }

    public void setNotSuitableAuth(String[] mechanisms) {
        int count = this.notSuitableModel.getRowCount();
        int i = 0;
        while (i < count) {
            this.notSuitableModel.removeRow(0);
            ++i;
        }
        if (mechanisms != null && mechanisms.length > 0) {
            int i2 = 0;
            while (i2 < mechanisms.length) {
                this.notSuitableModel.addRow(new String[]{mechanisms[i2]});
                ++i2;
            }
        } else {
            this.notSuitableModel.addRow(new String[]{""});
        }
    }

    protected void performEnterAction(KeyEvent e) {
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }

    private void addSuitableAction() {
        int[] addingRows = this.mechanismsTable.getSelectedRows();
        int count = this.suitableModel.getRowCount();
        if (this.suitableModel.getValueAt(count - 1, 0) == null || this.suitableModel.getValueAt(count - 1, 0).equals("")) {
            this.suitableModel.removeRow(--count);
        }
        int newCount = addingRows.length + count;
        int i = count;
        int j = 0;
        while (i < newCount) {
            Object value = this.mechanismsModel.getValueAt(addingRows[j], 0);
            if (value != null) {
                int k = 0;
                while (k < count) {
                    if (value.equals(this.suitableModel.getValueAt(k, 0))) break;
                    ++k;
                }
                if (k >= count) {
                    this.suitableModel.addRow(new Object[]{value});
                    int rows = this.notSuitableModel.getRowCount();
                    int l = 0;
                    while (l < rows) {
                        if (value.equals(this.notSuitableModel.getValueAt(l, 0))) {
                            this.notSuitableModel.removeRow(l);
                            break;
                        }
                        ++l;
                    }
                    if (this.notSuitableModel.getRowCount() == 0) {
                        this.notSuitableModel.addRow(new String[]{""});
                    }
                }
            }
            ++i;
            ++j;
        }
    }

    private void removeSuitableAction() {
        int[] removingRows = this.suitableTable.getSelectedRows();
        int i = 0;
        while (i < removingRows.length) {
            this.suitableModel.removeRow(removingRows[i] - i);
            ++i;
        }
        if (this.suitableModel.getRowCount() == 0) {
            this.suitableModel.addRow(new String[]{""});
        }
    }

    private void addNotSuitableAction() {
        int[] addingRows = this.mechanismsTable.getSelectedRows();
        int count = this.notSuitableModel.getRowCount();
        if (this.notSuitableModel.getValueAt(count - 1, 0) == null || this.notSuitableModel.getValueAt(count - 1, 0).equals("")) {
            this.notSuitableModel.removeRow(--count);
        }
        int newCount = addingRows.length + count;
        int i = count;
        int j = 0;
        while (i < newCount) {
            Object value = this.mechanismsModel.getValueAt(addingRows[j], 0);
            if (value != null) {
                int k = 0;
                while (k < count) {
                    if (value.equals(this.notSuitableModel.getValueAt(k, 0))) break;
                    ++k;
                }
                if (k >= count) {
                    this.notSuitableModel.addRow(new Object[]{value});
                    int rows = this.suitableModel.getRowCount();
                    int l = 0;
                    while (l < rows) {
                        if (value.equals(this.suitableModel.getValueAt(l, 0))) {
                            this.suitableModel.removeRow(l);
                            break;
                        }
                        ++l;
                    }
                    if (this.suitableModel.getRowCount() == 0) {
                        this.suitableModel.addRow(new String[]{""});
                    }
                }
            }
            ++i;
            ++j;
        }
    }

    private void removeNotSuitableAction() {
        int[] removingRows = this.notSuitableTable.getSelectedRows();
        int i = 0;
        while (i < removingRows.length) {
            this.notSuitableModel.removeRow(removingRows[i] - i);
            ++i;
        }
        if (this.notSuitableModel.getRowCount() == 0) {
            this.notSuitableModel.addRow(new String[]{""});
        }
    }

    private void okAction() {
        if (this.isForAdding) {
            if (this.moduleClassNameField.getText() == null || this.moduleClassNameField.getText().trim().length() == 0) {
                ExceptionHandler.error("Specify a class name for the login module!", null);
                return;
            }
            if (this.moduleNameField.getText() == null || this.moduleNameField.getText().trim().length() == 0) {
                ExceptionHandler.error("Give a display name to the login module!", null);
                return;
            }
            if (this.existsDisplayName(this.moduleNameField.getText())) {
                ExceptionHandler.error("The display name must be unique!", null);
                return;
            }
        }
        this.stopEditingTable(this.mechanismsTable);
        this.isOK = true;
        ((Component)this).setVisible(false);
    }

    private void cancelAction() {
        this.isOK = false;
        ((Component)this).setVisible(false);
    }

    private boolean existsDisplayName(String name) {
        LoginModuleConfiguration[] modules = this.control.getSelectedConfiguration().getLoginModules();
        if (modules != null) {
            int i = 0;
            while (i < modules.length) {
                if (modules[i].getName().equals(name)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void stopEditingTable(JTable table) {
        if (table.getCellEditor() != null) {
            table.getCellEditor().stopCellEditing();
            ChangeEvent chan = new ChangeEvent(table);
            table.editingStopped(chan);
        }
    }
}

