/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.interfaces.security.userstore.config.LoginModuleConfiguration;
import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.stores.ActionControl;
import com.sap.engine.services.security.gui.userstore.stores.LoginModuleDialog;
import com.sap.engine.services.security.gui.userstore.stores.OptionsEditorDialog;
import com.sap.engine.services.security.gui.userstore.stores.RuntimeLoginModuleConfiguration;
import com.sap.engine.services.security.gui.userstore.stores.RuntimeUserStoreConfiguration;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class AddLoginModuleAction
implements ActionControl {
    private UserStoresPanel control = null;
    private JButton button = null;
    private String selectedStore = null;

    public AddLoginModuleAction(UserStoresPanel control) {
        this.control = control;
        this.button = new JButton("Add Login Module");
        this.button.addActionListener(this);
    }

    public JButton getButton() {
        return this.button;
    }

    public void onSelectionChange(UserStoreConfiguration selection) {
        this.selectedStore = selection.getName();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.selectedStore != null) {
            try {
                OptionsEditorDialog optionsEditorDialog = new OptionsEditorDialog(this.control, "Choose editor for login module options", true);
                ((Component)optionsEditorDialog).setSize(400, 180);
                optionsEditorDialog.setModal(true);
                optionsEditorDialog.setLocationRelativeTo(this.control);
                ((Component)optionsEditorDialog).setVisible(true);
                LoginModuleConfiguration[] loginModules = this.control.getSelectedConfiguration().getLoginModules();
                LoginModuleDialog editor = new LoginModuleDialog(this.control, "Add Login Module", true, true, optionsEditorDialog.getEditorClassName());
                ((Component)editor).setSize(550, 510);
                editor.setModal(true);
                editor.setLocationRelativeTo(this.control);
                ((Component)editor).setVisible(true);
                if (editor.isOK()) {
                    LoginModuleConfiguration[] newModules = new LoginModuleConfiguration[loginModules.length + 1];
                    RuntimeUserStoreConfiguration config = new RuntimeUserStoreConfiguration(this.control.getSelectedConfiguration());
                    System.arraycopy(loginModules, 0, newModules, 0, loginModules.length);
                    newModules[loginModules.length] = new RuntimeLoginModuleConfiguration(editor.getName(), editor.getDescription(), editor.getClassName(), editor.getOptions(), editor.getSuitableAuth(), editor.getNotSuitableAuth(), editor.getOptionsEditor());
                    config.setLoginModules(newModules);
                    this.control.getControl().getUserStoreFactory().updateUserStore(config);
                    this.control.onSelectionChange(config);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.error("Unable to add login module!", ex);
            }
        }
    }
}

