/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore.stores;

import com.sap.engine.interfaces.security.userstore.config.UserStoreConfiguration;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.stores.ActionControl;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import com.sap.engine.services.security.gui.userstore.stores.wizard.WizardPanel;
import com.sap.engine.services.security.remote.RemoteUserStore;
import java.awt.event.ActionEvent;
import javax.swing.JButton;

public class ActiveUserStoreWizard
implements ActionControl {
    private UserStoresPanel control = null;
    private JButton button = null;
    private String selectedUserStoreName = null;

    public ActiveUserStoreWizard(UserStoresPanel control) {
        this.control = control;
        this.button = new JButton("Activate User Store");
        this.button.addActionListener(this);
        this.button.setEnabled(false);
    }

    public JButton getButton() {
        return this.button;
    }

    public void onSelectionChange(UserStoreConfiguration selection) {
        try {
            if (selection != null) {
                RemoteUserStore activeUserStore = this.control.getControl().getUserStoreFactory().getActiveUserStore();
                String activeUserStoreName = activeUserStore.getConfiguration().getName();
                this.selectedUserStoreName = selection.getName();
                this.button.setEnabled(!this.selectedUserStoreName.equals(activeUserStoreName));
            } else {
                this.button.setEnabled(false);
            }
        }
        catch (Exception e) {
            ExceptionHandler.debug("Unable to process selection change in ActiveUserSToreWizard", e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.control.getControl().getUserManagementControl().onSelectedStoreChanged();
        new WizardPanel(this.control, this.selectedUserStoreName);
    }
}

