/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.userstore;

import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.userstore.stores.UserStoresPanel;
import com.sap.engine.services.security.gui.userstore.usermanagement.UsersControlPanel;
import com.sap.engine.services.security.remote.RemoteUserStoreFactory;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UserStoreControl
extends JPanel {
    public static final String LOADING_PAGE = "loading-page";
    public static final String USERS_PAGE = "users-page";
    public static final String STORES_PAGE = "stores-page";
    private boolean prepared = false;
    private RemoteUserStoreFactory runtime = null;
    private UsersControlPanel users = null;
    private UserStoresPanel domains = null;
    private SecurityControl security = null;

    public UserStoreControl(SecurityControl security) {
        this.security = security;
        this.users = new UsersControlPanel(this);
        this.domains = new UserStoresPanel(this);
        this.setLayout(new CardLayout());
        this.add((Component)new JLabel("Wait! Loading ..."), LOADING_PAGE);
        this.add((Component)this.users, USERS_PAGE);
        this.add((Component)this.domains, STORES_PAGE);
        this.showPage(LOADING_PAGE);
    }

    public Frame getFrame() {
        return this.security.getFrame();
    }

    public void update() {
        if (!this.prepared) {
            try {
                this.runtime = this.security.getSecurityInterface().getRemoteUserStoreFactory();
                this.domains.update(this.runtime);
                this.users.prepare();
                this.users.show(this.runtime);
                this.showPage(USERS_PAGE);
                this.prepared = true;
            }
            catch (Exception e) {
                ExceptionHandler.error("Unable to update user store panel", e);
            }
        }
    }

    public UsersControlPanel getUserManagementControl() {
        return this.users;
    }

    public void showPage(String page) {
        if (USERS_PAGE.equals(page)) {
            this.users.onSelectedStoreChanged();
            ((CardLayout)this.getLayout()).show(this, USERS_PAGE);
        }
        if (STORES_PAGE.equals(page)) {
            ((CardLayout)this.getLayout()).show(this, STORES_PAGE);
        }
    }

    public SecurityControl getControl() {
        return this.security;
    }

    public String getSelectedStore() {
        if (this.domains.getSelectedConfiguration() == null) {
            return null;
        }
        return this.domains.getSelectedConfiguration().getName();
    }

    public RemoteUserStoreFactory getUserStoreFactory() {
        return this.runtime;
    }
}

