/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.roles;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.userstore.usermanagement.UMHash;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.UserTreePanel;
import com.sap.engine.services.security.remote.RemoteSecurity;
import com.sap.engine.services.security.remote.RemoteUserStore;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JPanel;

public class UserGroupSelectionDialog
extends CEscapeDialog
implements ActionListener {
    private JPanel dialogPane = new JPanel(new BorderLayout());
    private JPanel southPane = new JPanel(new FlowLayout());
    private UserTreePanel userPanel = null;
    private JButton okButt = new JButton();
    private JButton cancelButt = new JButton();
    private boolean isOK = false;
    private Object selectedUser = null;
    private Frame frame = null;

    public UserGroupSelectionDialog(RemoteSecurity security, Frame frame) {
        super(frame, "Choose Users or Groups", true);
        this.frame = frame;
        try {
            this.userPanel = new UserTreePanel(security);
            this.userPanel.setFrame(frame);
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ExceptionHandler.error(frame, "Unable to set up user/group selection panel!", ex);
        }
    }

    public UserGroupSelectionDialog(RemoteUserStore userstore, Frame frame) {
        super(frame, "Choose Users or Groups", true);
        this.frame = frame;
        try {
            this.userPanel = new UserTreePanel(userstore);
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ExceptionHandler.error(frame, "Unable to set up user/group selection panel!", ex);
        }
    }

    void init() throws Exception {
        this.okButt.setText("  OK  ");
        this.okButt.setActionCommand("OK_CMD");
        this.okButt.addActionListener(this);
        this.cancelButt.setText("Cancel");
        this.cancelButt.setActionCommand("CANCEL_CMD");
        this.cancelButt.addActionListener(this);
        this.southPane.add(this.okButt);
        this.southPane.add(this.cancelButt);
        this.userPanel.setUsersVisible(false);
        this.dialogPane.add((Component)this.userPanel, "Center");
        this.dialogPane.add((Component)this.southPane, "South");
        this.getContentPane().add(this.dialogPane);
        this.userPanel.refresh(null);
    }

    public void setUsersVisible() {
        this.userPanel.setUsersVisible(true);
        this.userPanel.setGroupsVisible(false);
    }

    public void setGroupsVisible() {
        this.userPanel.setUsersVisible(false);
        this.userPanel.setGroupsVisible(true);
    }

    protected void performEnterAction(KeyEvent e) {
        if (this.userPanel.getSelectedUser() != null) {
            this.okAction();
        }
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }

    private void okAction() {
        try {
            this.isOK = true;
            this.selectedUser = this.userPanel.getSelectedUser();
            this.setVisible(false);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to set up group selection panel!", e);
        }
    }

    private void cancelAction() {
        this.isOK = false;
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK_CMD")) {
            this.okAction();
        } else if (e.getActionCommand().equals("CANCEL_CMD")) {
            this.cancelAction();
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public Object getSelectedUser() {
        return this.selectedUser;
    }

    public void refresh(String userStoreName) {
        if (UMHash.getRoot(userStoreName) == null) {
            this.userPanel.refresh(null);
            UMHash.addRoot(userStoreName, this.userPanel.getRoot());
        } else {
            this.userPanel.refresh(UMHash.getRoot(userStoreName));
        }
    }

    public void setVisible(boolean flag) {
        if (flag) {
            this.setLocationRelativeTo(this.frame);
        }
        super.setVisible(flag);
    }
}

