/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.roles;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.roles.IdentityMapPanelLogical;
import com.sap.engine.services.security.gui.roles.UserGroupSelectionDialog;
import com.sap.engine.services.security.gui.util.SortedList;
import com.sap.engine.services.security.remote.RemoteGroupInfo;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SecurityRoleMappingPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final String ADD_USER_CMD = "ADD_USER_CMD";
    public static final String REMOVE_USER_CMD = "REMOVE_USER_CMD";
    public static final String ADD_GROUP_CMD = "ADD_GROUP_CMD";
    public static final String REMOVE_GROUP_CMD = "REMOVE_GROUP_CMD";
    private JButton addUserButton = new JButton();
    private JButton removeUserButton = new JButton();
    private JButton addGroupButton = new JButton();
    private JButton removeGroupButton = new JButton();
    private SortedList usersList = new SortedList();
    private SortedList groupsList = new SortedList();
    private IdentityMapPanelLogical parent = null;

    public SecurityRoleMappingPanel(IdentityMapPanelLogical mapPanel) {
        this.parent = mapPanel;
        this.init();
    }

    private void init() {
        this.addUserButton.setText("Add");
        this.addUserButton.setActionCommand(ADD_USER_CMD);
        this.addUserButton.addActionListener(this);
        this.addUserButton.setEnabled(false);
        this.removeUserButton.setText("Remove");
        this.removeUserButton.setActionCommand(REMOVE_USER_CMD);
        this.removeUserButton.addActionListener(this);
        this.removeUserButton.setEnabled(false);
        this.addGroupButton.setText("Add");
        this.addGroupButton.setActionCommand(ADD_GROUP_CMD);
        this.addGroupButton.addActionListener(this);
        this.addGroupButton.setEnabled(false);
        this.removeGroupButton.setText("Remove");
        this.removeGroupButton.setActionCommand(REMOVE_GROUP_CMD);
        this.removeGroupButton.addActionListener(this);
        this.removeGroupButton.setEnabled(false);
        this.usersList.addListSelectionListener(this);
        this.usersList.setSelectionMode(0);
        this.groupsList.addListSelectionListener(this);
        this.groupsList.setSelectionMode(0);
        JScrollPane usersPane = new JScrollPane(this.usersList);
        usersPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Users "));
        JScrollPane groupsPane = new JScrollPane(this.groupsList);
        groupsPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Groups "));
        this.setLayout(new GridBagLayout());
        this.add((Component)usersPane, new GridBagConstraints(0, 0, 2, 4, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.addUserButton, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.1, 14, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.removeUserButton, new GridBagConstraints(2, 2, 1, 1, 0.1, 0.1, 12, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)groupsPane, new GridBagConstraints(0, 4, 2, 4, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.addGroupButton, new GridBagConstraints(2, 5, 1, 1, 0.1, 0.1, 14, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.removeGroupButton, new GridBagConstraints(2, 6, 1, 1, 0.1, 0.1, 12, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(ADD_USER_CMD)) {
            this.addAction(ADD_USER_CMD);
        } else if (cmd.equals(REMOVE_USER_CMD)) {
            this.removeAction(REMOVE_USER_CMD);
        } else if (cmd.equals(ADD_GROUP_CMD)) {
            this.addAction(ADD_GROUP_CMD);
        } else if (cmd.equals(REMOVE_GROUP_CMD)) {
            this.removeAction(REMOVE_GROUP_CMD);
        }
    }

    public void addAction(String cmd) {
        try {
            UserGroupSelectionDialog selectionDialog = this.parent.getUserGroupSelectionDialog();
            if (cmd.equals(ADD_USER_CMD)) {
                selectionDialog.setUsersVisible();
            } else {
                selectionDialog.setGroupsVisible();
            }
            selectionDialog.setVisible(true);
            if (!selectionDialog.isOK()) {
                return;
            }
            Object info = selectionDialog.getSelectedUser();
            SecurityRole role = this.parent.getSelectedRole();
            if (info instanceof RemoteUserStoreInfo) {
                String userName = ((RemoteUserStoreInfo)info).getName();
                role.addUser(userName);
                this.parent.modifySecurityRole(role);
            } else if (info instanceof RemoteGroupInfo) {
                String groupName = ((RemoteGroupInfo)info).getName();
                role.addGroup(groupName);
                this.parent.modifySecurityRole(role);
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to add user / user group to role!", e);
        }
        this.parent.updateView(false);
    }

    public void removeAction(String cmd) {
        try {
            SecurityRole role = this.parent.getSelectedRole();
            if (cmd.equals(REMOVE_USER_CMD) && !this.usersList.isSelectionEmpty()) {
                String userName = (String)this.usersList.getSelectedValue();
                role.removeUser(userName);
                this.parent.modifySecurityRole(role);
            } else if (cmd.equals(REMOVE_GROUP_CMD) && !this.groupsList.isSelectionEmpty()) {
                String groupName = (String)this.groupsList.getSelectedValue();
                role.removeGroup(groupName);
                this.parent.modifySecurityRole(role);
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to remove user / user group from role!", e);
        }
        this.parent.updateView(false);
    }

    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (src == this.usersList) {
            if (((JList)src).isSelectionEmpty()) {
                this.removeUserButton.setEnabled(false);
            } else {
                this.removeUserButton.setEnabled(true);
            }
        } else if (src == this.groupsList) {
            if (((JList)src).isSelectionEmpty()) {
                this.removeGroupButton.setEnabled(false);
            } else {
                this.removeGroupButton.setEnabled(true);
            }
        }
    }

    public void valueChanged(SecurityRole role) {
        if (role != null) {
            this.usersList.setListData(role.getUsers());
            this.groupsList.setListData(role.getGroups());
            this.addUserButton.setEnabled(true);
            this.addGroupButton.setEnabled(true);
        } else {
            this.usersList.setListData(new Object[0]);
            this.groupsList.setListData(new Object[0]);
            this.addUserButton.setEnabled(false);
            this.removeUserButton.setEnabled(false);
            this.addGroupButton.setEnabled(false);
            this.removeGroupButton.setEnabled(false);
        }
    }
}

