/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.roles;

import com.sap.engine.services.security.gui.ComponentChangeListener;
import com.sap.engine.services.security.gui.PolicyConfigurationsControl;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.roles.IdentityMapPanelLogical;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JPanel;

public class RolePanel
extends JPanel
implements ComponentChangeListener {
    private IdentityMapPanelLogical mappingPanel = null;
    private SecurityControl security = null;
    private PolicyConfigurationsControl policyConfigurations = null;
    private int selectedRoleIndex = -1;

    public RolePanel(SecurityControl security, PolicyConfigurationsControl policyConfigurations) {
        this.security = security;
        this.policyConfigurations = policyConfigurations;
        this.setLayout(new BorderLayout());
    }

    public void setFrame(Frame frame) {
        if (this.mappingPanel != null) {
            this.mappingPanel.setFrame(frame);
        }
    }

    public void onComponentChange(String policyConfigurationId) {
        if (this.mappingPanel != null) {
            this.mappingPanel.onComponentChange(policyConfigurationId);
        }
    }

    public void update() {
        if (this.mappingPanel == null) {
            this.mappingPanel = new IdentityMapPanelLogical(this.security, this);
            this.add((Component)this.mappingPanel, "Center");
        }
        String componentName = this.policyConfigurations.getSelectedComponentName();
        this.onComponentChange(componentName);
    }

    protected int getSelectedRoleIndex() {
        return this.selectedRoleIndex;
    }

    protected void setSelectedRoleIndex(int selectedRoleIndex) {
        this.selectedRoleIndex = selectedRoleIndex;
    }
}

