/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.roles;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.roles.IdentityMapPanelLogical;
import com.sap.engine.services.security.gui.util.ComboBoxCellRenderer;
import com.sap.engine.services.security.gui.util.SortedComponentsList;
import com.sap.engine.services.security.gui.util.SortedList;
import com.sap.engine.services.security.remote.RemoteAuthorization;
import com.sap.engine.services.security.roles.SecurityRoleReference;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ReferenceRoleMappingPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
ItemListener {
    public static final String MODIFY_REFERENCE_CMD = "MODIFY_REFERENCE_CMD";
    public static final String SAVE_REFERENCE_CMD = "SAVE_REFERENCE_CMD";
    protected JButton modifyButton = new JButton();
    protected JButton saveButton = new JButton();
    private JComboBox policyConfigsCombo = new JComboBox();
    private SortedList secRolesList = new SortedList();
    private SortedList usersList = new SortedList();
    private SortedList groupsList = new SortedList();
    private IdentityMapPanelLogical parent = null;
    private String selectedPolicyConfiguration = null;

    public ReferenceRoleMappingPanel(IdentityMapPanelLogical mapPanel) {
        this.parent = mapPanel;
        this.init();
    }

    private void init() {
        this.modifyButton.setText("Modify");
        this.modifyButton.setActionCommand(MODIFY_REFERENCE_CMD);
        this.modifyButton.addActionListener(this);
        this.modifyButton.setEnabled(true);
        this.saveButton.setText("Save");
        this.saveButton.setActionCommand(SAVE_REFERENCE_CMD);
        this.saveButton.addActionListener(this);
        this.saveButton.setEnabled(false);
        this.usersList.setEnabled(false);
        this.groupsList.setEnabled(false);
        this.secRolesList.addListSelectionListener(this);
        JScrollPane usersPane = new JScrollPane(this.usersList);
        usersPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Users "));
        JScrollPane groupsPane = new JScrollPane(this.groupsList);
        groupsPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Groups "));
        JPanel rightPanel = new JPanel(new GridLayout(2, 1));
        rightPanel.add(usersPane);
        rightPanel.add(groupsPane);
        JScrollPane secRolesPane = new JScrollPane(this.secRolesList);
        secRolesPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Security Roles "));
        JPanel comboPanel = new JPanel(new BorderLayout());
        comboPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Policy Configurations "));
        comboPanel.add((Component)this.policyConfigsCombo, "Center");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)comboPanel, "North");
        leftPanel.add((Component)secRolesPane, "Center");
        JPanel centerPanel = new JPanel(new GridLayout(1, 2, 5, 5));
        centerPanel.add(leftPanel);
        centerPanel.add(rightPanel);
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.add(this.modifyButton);
        buttonsPanel.add(this.saveButton);
        this.setLayout(new BorderLayout());
        this.add((Component)centerPanel, "Center");
        this.add((Component)buttonsPanel, "South");
        this.policyConfigsCombo.setEditable(false);
        this.policyConfigsCombo.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(MODIFY_REFERENCE_CMD)) {
            this.modifyAction();
        } else if (cmd.equals(SAVE_REFERENCE_CMD)) {
            this.saveAction();
        }
    }

    public void modifyAction() {
        this.secRolesList.setEnabled(true);
        this.modifyButton.setEnabled(false);
        this.saveButton.setEnabled(true);
    }

    public void saveAction() {
        SecurityRole role = this.parent.getSelectedRole();
        if (role != null) {
            try {
                if (this.secRolesList.getSelectedValue() == null) {
                    if (!ExceptionHandler.confirmation("Select target security role or press \"Cancel\" to revert the changes!", "Warning")) {
                        this.parent.updateView(false);
                    }
                    return;
                }
                role = this.parent.convertRoleToReference(role, (String)this.policyConfigsCombo.getSelectedItem(), (String)this.secRolesList.getSelectedValue());
                this.secRolesList.setEnabled(false);
                this.secRolesList.setSelectedValue(role, true);
                this.modifyButton.setEnabled(true);
                this.saveButton.setEnabled(false);
            }
            catch (RemoteException e) {
                ExceptionHandler.error("Unable to save the specified role reference!", e);
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        String selectedRoleName = (String)this.secRolesList.getSelectedValue();
        SecurityRole role = null;
        try {
            RemoteAuthorization remote = this.parent.getSecurityControl().getSecurityInterface().getPolicyConfiguration((String)this.policyConfigsCombo.getSelectedItem()).getAuthorization();
            String userStoreName = this.parent.getUserStoreName();
            role = userStoreName != null ? remote.getSecurityRoles(userStoreName).getSecurityRole(selectedRoleName) : remote.getSecurityRoles().getSecurityRole(selectedRoleName);
            if (role == null) {
                this.usersList.setListData(new Object[0]);
                this.groupsList.setListData(new Object[0]);
            } else {
                this.usersList.setListData(role.getUsers());
                this.groupsList.setListData(role.getGroups());
            }
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to retrieve the selected security role's mappings!", ex);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.secRolesList.setListData(this.getPolicyConfigRoles((String)e.getItem()));
        }
    }

    public void valueChanged(SecurityRoleReference role) {
        if (role != null) {
            this.usersList.setListData(role.getUsers());
            this.groupsList.setListData(role.getGroups());
            this.secRolesList.setListData(this.getPolicyConfigRoles(role.getReference()[0]));
            this.secRolesList.setSelectedValue(role.getReference()[1], true);
            this.secRolesList.setEnabled(false);
            this.policyConfigsCombo.setSelectedItem(role.getReference()[0]);
            this.policyConfigsCombo.setEnabled(false);
            this.modifyButton.setEnabled(true);
            this.saveButton.setEnabled(false);
        } else {
            this.usersList.setListData(new Object[0]);
            this.groupsList.setListData(new Object[0]);
            this.secRolesList.setListData(new Object[0]);
            this.secRolesList.setEnabled(false);
            this.policyConfigsCombo.setSelectedItem("SAP-J2EE-Engine");
            this.policyConfigsCombo.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.saveButton.setEnabled(false);
        }
    }

    protected void setPolicyConfigurationsData(String selectedPolicyConfig) {
        this.selectedPolicyConfiguration = selectedPolicyConfig;
        try {
            this.policyConfigsCombo.removeAllItems();
            this.policyConfigsCombo.setRenderer(new ComboBoxCellRenderer());
            Object[] result = this.parent.getSecurityControl().getSecurityInterface().listPolicyConfigurations();
            SortedComponentsList.sortList(result);
            int i = 0;
            while (i < result.length) {
                this.policyConfigsCombo.addItem(result[i]);
                ++i;
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to set the available policy configurations!", e);
        }
    }

    private Object[] getPolicyConfigRoles(String policyConfigurationId) {
        if (policyConfigurationId.equals("")) {
            return new SecurityRole[0];
        }
        SecurityRole[] roles = new SecurityRole[]{};
        Vector<String> result = new Vector<String>();
        try {
            RemoteAuthorization remote = this.parent.getSecurityControl().getSecurityInterface().getPolicyConfiguration(policyConfigurationId).getAuthorization();
            String userStoreName = this.parent.getUserStoreName();
            roles = userStoreName != null ? remote.getSecurityRoles(userStoreName).listSecurityRoles() : remote.getSecurityRoles().listSecurityRoles();
            int i = 0;
            while (i < roles.length) {
                if (!(roles[i] instanceof SecurityRoleReference || "SAP-J2EE-Engine".equals(this.selectedPolicyConfiguration) && roles[i].getName().equals(this.parent.getSelectedRole().getName()))) {
                    result.addElement(roles[i].getName());
                }
                ++i;
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to retrieve the selected policy configuration's security roles!", e);
        }
        return result.toArray();
    }

    protected void initializeRoleReference() {
        this.usersList.setListData(new Object[0]);
        this.groupsList.setListData(new Object[0]);
        this.policyConfigsCombo.setSelectedItem("SAP-J2EE-Engine");
        this.policyConfigsCombo.setEnabled(false);
        this.secRolesList.setListData(this.getPolicyConfigRoles("SAP-J2EE-Engine"));
        this.secRolesList.setEnabled(true);
        this.modifyButton.setEnabled(false);
        this.saveButton.setEnabled(true);
    }
}

