/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.roles;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.roles.DescriptionPanel;
import com.sap.engine.services.security.gui.roles.NewRoleDialog;
import com.sap.engine.services.security.gui.roles.ReferenceRoleMappingPanel;
import com.sap.engine.services.security.gui.roles.RolePanel;
import com.sap.engine.services.security.gui.roles.SecurityRoleMappingPanel;
import com.sap.engine.services.security.gui.roles.UserGroupSelectionDialog;
import com.sap.engine.services.security.gui.util.SortedList;
import com.sap.engine.services.security.remote.RemoteAuthorization;
import com.sap.engine.services.security.remote.RemoteGroupContext;
import com.sap.engine.services.security.remote.RemoteIterator;
import com.sap.engine.services.security.remote.RemoteUserStoreInfo;
import com.sap.engine.services.security.remote.roles.RemoteSecurityRoles;
import com.sap.engine.services.security.roles.SecurityRoleReference;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class IdentityMapPanelLogical
extends JPanel
implements ActionListener,
ListSelectionListener {
    public static final String CHANGE_RUN_AS_CMD = "CHANGE_RUN_AS_CMD";
    public static final String CLEAR_RUN_AS_CMD = "CLEAR_RUN_AS_CMD";
    public static final String ADD_ROLE_CMD = "ADD_ROLE_CMD";
    public static final String REMOVE_ROLE_CMD = "REMOVE_ROLE_CMD";
    public static final String SECURITY_ROLE = "Security Role";
    public static final String ROLE_REFERENCE = "Role Reference";
    private JButton changeRunAsButton = new JButton();
    private JButton clearRunAsButton = new JButton();
    private JButton addRoleButton = new JButton();
    private JButton removeRoleButton = new JButton();
    private JTextField runAsIdentityField = new JTextField();
    private SortedList rolesList = new SortedList();
    private RemoteSecurityRoles roles = null;
    private String userStoreName = null;
    private SecurityControl security = null;
    private RolePanel securityRolePanel = null;
    private DescriptionPanel descriptionPanel = new DescriptionPanel();
    private JPanel mappingsPanel = new JPanel();
    private JRadioButton roleRadioBtn = new JRadioButton();
    private JRadioButton refRadioBtn = new JRadioButton();
    private SecurityRoleMappingPanel secRoleMappingPanel = null;
    private ReferenceRoleMappingPanel refRoleMappingPanel = null;
    private UserGroupSelectionDialog selectionDialog = null;

    public IdentityMapPanelLogical(SecurityControl security) {
        this.security = security;
        this.init();
        this.selectionDialog = new UserGroupSelectionDialog(security.getSecurityInterface(), security.getFrame());
    }

    public IdentityMapPanelLogical(SecurityControl security, String userStoreName) {
        this.security = security;
        this.userStoreName = userStoreName;
        this.init();
        try {
            this.selectionDialog = new UserGroupSelectionDialog(security.getSecurityInterface().getRemoteUserStoreFactory().getUserStore(userStoreName), security.getFrame());
        }
        catch (RemoteException re) {
            ExceptionHandler.error("Unable to initialize identity map panel for userstore !", re);
        }
    }

    public IdentityMapPanelLogical(SecurityControl security, RolePanel securityRolePanel) {
        this(security);
        this.securityRolePanel = securityRolePanel;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.changeRunAsButton.setText("Change");
        this.changeRunAsButton.setActionCommand(CHANGE_RUN_AS_CMD);
        this.changeRunAsButton.addActionListener(this);
        this.changeRunAsButton.setEnabled(true);
        this.clearRunAsButton.setText("Clear");
        this.clearRunAsButton.setActionCommand(CLEAR_RUN_AS_CMD);
        this.clearRunAsButton.addActionListener(this);
        this.clearRunAsButton.setEnabled(true);
        this.addRoleButton.setText("Add");
        this.addRoleButton.setActionCommand(ADD_ROLE_CMD);
        this.addRoleButton.addActionListener(this);
        this.addRoleButton.setEnabled(true);
        this.removeRoleButton.setText("Remove");
        this.removeRoleButton.setActionCommand(REMOVE_ROLE_CMD);
        this.removeRoleButton.addActionListener(this);
        this.removeRoleButton.setEnabled(false);
        JPanel roleButtonsPanel = new JPanel(new FlowLayout());
        roleButtonsPanel.add(this.addRoleButton);
        roleButtonsPanel.add(this.removeRoleButton);
        JPanel rolesPanel = new JPanel();
        rolesPanel.setLayout(new BorderLayout());
        rolesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Security Roles "));
        rolesPanel.add((Component)new JScrollPane(this.rolesList), "Center");
        rolesPanel.add((Component)roleButtonsPanel, "South");
        JPanel identityPanel = new JPanel();
        identityPanel.setLayout(new GridBagLayout());
        JPanel roleTypePanel = new JPanel(new GridBagLayout());
        roleTypePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Role Type "));
        this.roleRadioBtn.setText(SECURITY_ROLE);
        this.roleRadioBtn.setActionCommand(SECURITY_ROLE);
        this.roleRadioBtn.addActionListener(this);
        this.refRadioBtn.setText(ROLE_REFERENCE);
        this.refRadioBtn.setActionCommand(ROLE_REFERENCE);
        this.refRadioBtn.addActionListener(this);
        roleTypePanel.add((Component)this.roleRadioBtn, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        roleTypePanel.add((Component)this.refRadioBtn, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.1, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        ButtonGroup group = new ButtonGroup();
        group.add(this.roleRadioBtn);
        group.add(this.refRadioBtn);
        this.mappingsPanel = new JPanel();
        this.mappingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Mappings "));
        this.mappingsPanel.setLayout(new CardLayout());
        this.secRoleMappingPanel = new SecurityRoleMappingPanel(this);
        this.mappingsPanel.add((Component)this.secRoleMappingPanel, SECURITY_ROLE);
        this.refRoleMappingPanel = new ReferenceRoleMappingPanel(this);
        this.mappingsPanel.add((Component)this.refRoleMappingPanel, ROLE_REFERENCE);
        this.roleRadioBtn.setSelected(true);
        ((CardLayout)this.mappingsPanel.getLayout()).show(this.mappingsPanel, SECURITY_ROLE);
        JPanel runAsPanel = new JPanel();
        runAsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Run-As Identity "));
        runAsPanel.setLayout(new GridBagLayout());
        runAsPanel.add((Component)this.runAsIdentityField, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        runAsPanel.add((Component)this.changeRunAsButton, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        runAsPanel.add((Component)this.clearRunAsButton, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        identityPanel.add((Component)roleTypePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        identityPanel.add((Component)this.mappingsPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        identityPanel.add((Component)runAsPanel, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 15, 1, new Insets(0, 5, 0, 0), 0, 0));
        identityPanel.add((Component)this.descriptionPanel, new GridBagConstraints(0, 5, 3, 1, 1.0, 0.1, 10, 1, new Insets(5, 5, 5, 0), 0, 0));
        identityPanel.revalidate();
        identityPanel.repaint();
        JSplitPane mainSplitPane = new JSplitPane();
        mainSplitPane.add((Component)rolesPanel, "left");
        mainSplitPane.setDividerLocation(200);
        mainSplitPane.add((Component)identityPanel, "right");
        this.add((Component)mainSplitPane, "Center");
        this.rolesList.setSelectionMode(0);
        this.rolesList.addListSelectionListener(this);
        this.descriptionPanel.setEnabled(false);
        this.userStoreName = this.getUserStoreName();
    }

    public void setFrame(Frame frame) {
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(SECURITY_ROLE)) {
            this.securityRoleSelectedAction();
        } else if (cmd.equals(ROLE_REFERENCE)) {
            this.referenceRoleSelectedAction();
        } else if (cmd.equals(CLEAR_RUN_AS_CMD)) {
            this.clearRunAsIdentityAction();
        } else if (cmd.equals(CHANGE_RUN_AS_CMD)) {
            this.changeRunAsIdentityAction();
        } else if (cmd.equals(ADD_ROLE_CMD)) {
            this.addRoleAction();
        } else if (cmd.equals(REMOVE_ROLE_CMD)) {
            this.removeRoleAction();
        }
    }

    public void securityRoleSelectedAction() {
        SecurityRole role = this.getSelectedRole();
        if (role != null) {
            if (role instanceof SecurityRoleReference) {
                if (ExceptionHandler.confirmation("The selected role reference will be replaced by a new role in order to perform the mapping.", "Warning")) {
                    try {
                        role = this.convertReferenceToRole(role);
                    }
                    catch (Exception e) {
                        ExceptionHandler.error("Unable to switch the selected role reference to security role!", e);
                    }
                } else {
                    this.refRadioBtn.setSelected(true);
                }
            } else {
                ((CardLayout)this.mappingsPanel.getLayout()).show(this.mappingsPanel, SECURITY_ROLE);
            }
        }
    }

    public void referenceRoleSelectedAction() {
        SecurityRole role = this.getSelectedRole();
        if (role != null && !(role instanceof SecurityRoleReference)) {
            if (ExceptionHandler.confirmation("The selected security role will be replaced by a new role reference.\nThe new configuration will be saved after pressing the \"Save\" button.", "Warning")) {
                this.refRoleMappingPanel.initializeRoleReference();
                ((CardLayout)this.mappingsPanel.getLayout()).show(this.mappingsPanel, ROLE_REFERENCE);
            } else {
                this.roleRadioBtn.setSelected(true);
            }
        }
    }

    public void addRoleAction() {
        String roleName = null;
        Frame frame = this.security.getFrame();
        NewRoleDialog dialog = new NewRoleDialog(frame, "Add Security Role", true);
        dialog.setLocationRelativeTo(frame);
        ((Component)dialog).setVisible(true);
        roleName = dialog.getRoleName();
        SecurityRole role = null;
        if (roleName != null) {
            while (roleName != null && roleName.trim().equals("")) {
                ExceptionHandler.error("The name of the security role is not specified. Please enter a name!", null);
                dialog.clear();
                ((Component)dialog).setVisible(true);
                roleName = dialog.getRoleName();
            }
            try {
                role = this.roles.addSecurityRole(roleName);
                role.setDescription(dialog.getDescription().trim());
                this.roles.modifySecurityRole(role);
            }
            catch (Exception e) {
                role = null;
                ExceptionHandler.error("Unable to add security role!", e);
            }
        }
        if (role != null) {
            this.updateView(false);
            this.rolesList.setSelectedValue(role.getName(), true);
        }
    }

    public void removeRoleAction() {
        try {
            SecurityRole role = this.getSelectedRole();
            this.roles.removeSecurityRole(role.getName());
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to remove security role!", e);
        }
        this.updateView(false);
    }

    public void changeRunAsIdentityAction() {
        try {
            this.selectionDialog.setUsersVisible();
            this.selectionDialog.setVisible(true);
            if (!this.selectionDialog.isOK()) {
                return;
            }
            Object info = this.selectionDialog.getSelectedUser();
            SecurityRole role = this.getSelectedRole();
            if (!(info instanceof RemoteUserStoreInfo)) {
                JOptionPane.showMessageDialog(this, "The new ran_as identity must correspond to a valid user account!", "Warning", 0);
            } else if (!this.isUserFromRole(((RemoteUserStoreInfo)info).getName(), role)) {
                JOptionPane.showMessageDialog(this, "The new ran_as identity must belong to the role's users or groups!", "Warning", 0);
            } else {
                String runAsIdentity = ((RemoteUserStoreInfo)info).getName();
                role.setRunAsIdentity(runAsIdentity);
                this.roles.modifySecurityRole(role);
                this.runAsIdentityField.setText(runAsIdentity);
                this.clearRunAsButton.setEnabled(true);
            }
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to change the run_as identity of the role!", e);
        }
    }

    public void clearRunAsIdentityAction() {
        try {
            SecurityRole role = this.getSelectedRole();
            role.setRunAsIdentity("");
            this.roles.modifySecurityRole(role);
            this.runAsIdentityField.setText("");
            this.clearRunAsButton.setEnabled(false);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to change the run_as identity of the role!", e);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        SecurityRole role;
        if (this.securityRolePanel != null) {
            this.securityRolePanel.setSelectedRoleIndex(this.rolesList.getSelectedIndex());
        }
        if ((role = this.getSelectedRole()) != null) {
            this.roleRadioBtn.setEnabled(true);
            this.refRadioBtn.setEnabled(true);
            if (role instanceof SecurityRoleReference) {
                this.refRadioBtn.setSelected(true);
                this.refRoleMappingPanel.valueChanged((SecurityRoleReference)role);
                ((CardLayout)this.mappingsPanel.getLayout()).show(this.mappingsPanel, ROLE_REFERENCE);
            } else {
                this.roleRadioBtn.setSelected(true);
                this.secRoleMappingPanel.valueChanged(role);
                ((CardLayout)this.mappingsPanel.getLayout()).show(this.mappingsPanel, SECURITY_ROLE);
            }
            this.descriptionPanel.setText(role.getDescription());
            this.runAsIdentityField.setText(role.getRunAsIdentity(false));
            this.runAsIdentityField.setEnabled(false);
            this.changeRunAsButton.setEnabled(true);
            this.clearRunAsButton.setEnabled(!this.runAsIdentityField.getText().equals(""));
            this.removeRoleButton.setEnabled(true);
        } else {
            this.roleRadioBtn.setSelected(true);
            this.roleRadioBtn.setEnabled(false);
            this.refRadioBtn.setEnabled(false);
            this.secRoleMappingPanel.valueChanged((SecurityRole)null);
            ((CardLayout)this.mappingsPanel.getLayout()).show(this.mappingsPanel, SECURITY_ROLE);
            this.descriptionPanel.setText("");
            this.runAsIdentityField.setText("");
            this.runAsIdentityField.setEnabled(false);
            this.changeRunAsButton.setEnabled(false);
            this.clearRunAsButton.setEnabled(false);
            this.removeRoleButton.setEnabled(false);
        }
    }

    protected void updateView(boolean isTabChanged) {
        ListSelectionEvent emptyEvent = new ListSelectionEvent(new JLabel(""), 0, 0, false);
        if (this.roles == null) {
            return;
        }
        try {
            int selectedIndex = isTabChanged && this.securityRolePanel != null ? this.securityRolePanel.getSelectedRoleIndex() : this.rolesList.getSelectedIndex();
            String userStoreName = this.getUserStoreName();
            if (userStoreName == null) {
                return;
            }
            this.selectionDialog.refresh(userStoreName);
            SecurityRole[] allRoles = this.roles.listSecurityRoles();
            Object[] roleNames = new String[allRoles.length];
            int i = 0;
            while (i < allRoles.length) {
                roleNames[i] = allRoles[i].getName();
                ++i;
            }
            this.rolesList.setListData(roleNames);
            int size = this.rolesList.getModel().getSize();
            if (selectedIndex >= 0 && size > selectedIndex) {
                this.rolesList.setSelectedIndex(selectedIndex);
            } else if (this.rolesList.getFirstVisibleIndex() >= 0) {
                this.rolesList.setSelectedIndex(0);
            }
            if (this.securityRolePanel != null) {
                this.securityRolePanel.setSelectedRoleIndex(this.rolesList.getSelectedIndex());
            }
            this.valueChanged(emptyEvent);
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to update identity map panel!", e);
        }
    }

    public void onComponentChange(String policyConfigurationId) {
        if (policyConfigurationId == null) {
            this.rolesList.setListData(new Object[0]);
            this.roleRadioBtn.setSelected(true);
            this.roleRadioBtn.setEnabled(false);
            this.refRadioBtn.setEnabled(false);
            this.secRoleMappingPanel.valueChanged((SecurityRole)null);
            ((CardLayout)this.mappingsPanel.getLayout()).show(this.mappingsPanel, SECURITY_ROLE);
        } else {
            try {
                RemoteAuthorization remote = this.security.getSecurityInterface().getPolicyConfiguration(policyConfigurationId).getAuthorization();
                this.refRoleMappingPanel.setPolicyConfigurationsData(policyConfigurationId);
                this.roles = this.userStoreName != null ? remote.getSecurityRoles(this.userStoreName) : remote.getSecurityRoles();
            }
            catch (Exception e) {
                ExceptionHandler.error("Unable to update identity map panel on selection change!", e);
            }
            this.updateView(false);
        }
    }

    protected SecurityControl getSecurityControl() {
        return this.security;
    }

    protected final String getUserStoreName() {
        if (this.userStoreName == null) {
            this.userStoreName = this.security.getSelectedUserStore();
            if (this.userStoreName == null) {
                try {
                    this.userStoreName = this.security.getSecurityInterface().getRemoteUserStoreFactory().getActiveUserStore().getConfiguration().getName();
                }
                catch (RemoteException e) {
                    ExceptionHandler.error("Unable to determine active user store!", e);
                }
            }
        }
        return this.userStoreName;
    }

    private boolean isUserFromRole(String userName, SecurityRole role) {
        String[] mappedUsers = role.getUsers();
        int i = 0;
        while (i < mappedUsers.length) {
            if (mappedUsers[i].equals(userName)) {
                return true;
            }
            ++i;
        }
        String[] groups = role.getGroups();
        if (groups.length > 0) {
            try {
                RemoteGroupContext ctx = this.security.getSecurityInterface().getRemoteUserStoreFactory().getUserStore(this.getUserStoreName()).getGroupContext();
                HashSet checkedGroups = new HashSet();
                int i2 = 0;
                while (i2 < groups.length) {
                    if (this.isUserFromGroup(userName, groups[i2], ctx, checkedGroups)) {
                        return true;
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private boolean isUserFromGroup(String user, String group, RemoteGroupContext ctx, HashSet checkedGroups) throws Exception {
        RemoteIterator users = ctx.getUsersOfGroup(group);
        while (users.hasNext()) {
            if (!users.next().equals(user)) continue;
            return true;
        }
        RemoteIterator groups = ctx.getChildGroups(group);
        String nextGroup = null;
        while (groups.hasNext()) {
            nextGroup = (String)groups.next();
            if (checkedGroups.contains(nextGroup)) continue;
            checkedGroups.add(nextGroup);
            if (!this.isUserFromGroup(user, nextGroup, ctx, checkedGroups)) continue;
            return true;
        }
        return false;
    }

    private SecurityRole convertReferenceToRole(SecurityRole role) throws RemoteException {
        String roleName = role.getName();
        this.roles.removeSecurityRole(roleName);
        this.roles.addSecurityRole(roleName);
        SecurityRole secRole = this.roles.getSecurityRole(roleName);
        String[] users = role.getUsers();
        int i = 0;
        while (i < users.length) {
            secRole.addUser(users[i]);
            ++i;
        }
        String[] groups = role.getGroups();
        int i2 = 0;
        while (i2 < groups.length) {
            secRole.addGroup(groups[i2]);
            ++i2;
        }
        this.roles.modifySecurityRole(secRole);
        this.updateView(false);
        this.rolesList.setSelectedValue(role.getName(), true);
        return secRole;
    }

    protected SecurityRole convertRoleToReference(SecurityRole role, String policyConfiguration, String securityRole) throws RemoteException {
        String roleName = role.getName();
        this.roles.removeSecurityRole(roleName);
        this.roles.addSecurityRoleReference(roleName, policyConfiguration, securityRole);
        SecurityRole secRole = this.roles.getSecurityRole(roleName);
        this.updateView(false);
        this.rolesList.setSelectedValue(role.getName(), true);
        return secRole;
    }

    protected SecurityRole getSelectedRole() {
        SecurityRole role = null;
        try {
            role = this.roles.getSecurityRole((String)this.rolesList.getSelectedValue());
        }
        catch (Exception e) {
            ExceptionHandler.error("The selected role cannot be loaded!", e);
        }
        return role;
    }

    protected UserGroupSelectionDialog getUserGroupSelectionDialog() {
        return this.selectionDialog;
    }

    protected void modifySecurityRole(SecurityRole role) throws RemoteException {
        this.roles.modifySecurityRole(role);
    }
}

