/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.resource;

import com.sap.engine.services.security.gui.resource.ImageHolder;
import com.sap.engine.services.security.gui.resource.InstanceTreeNode;
import com.sap.engine.services.security.gui.resource.ResourceTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class ResourceTreeRenderer
extends JLabel
implements TreeCellRenderer {
    private ImageHolder imageHolder = null;

    public ResourceTreeRenderer() {
        this.setOpaque(true);
        this.imageHolder = new ImageHolder();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof ResourceTreeNode) {
            this.setIcon(ImageHolder.resourceIcon);
        } else if (value instanceof InstanceTreeNode) {
            this.setIcon(ImageHolder.instanceIcon);
        } else {
            this.setIcon(ImageHolder.anotherIcon);
        }
        this.setText(value != null ? value.toString() : "");
        this.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(selected ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 10, retDimension.height);
        }
        return retDimension;
    }
}

