/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.security.gui.resource;

import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.services.security.gui.ComponentChangeListener;
import com.sap.engine.services.security.gui.ExceptionHandler;
import com.sap.engine.services.security.gui.SecurityControl;
import com.sap.engine.services.security.gui.resource.ResourceTreeRenderer;
import com.sap.engine.services.security.gui.util.SortedList;
import com.sap.engine.services.security.remote.RemotePolicyConfiguration;
import com.sap.engine.services.security.remote.resource.RemoteResourceAccessControlHandle;
import com.sap.engine.services.security.remote.resource.RemoteResourceHandle;
import com.sap.engine.services.security.remote.resource.RemoteSecurityResources;
import com.sap.engine.services.security.remote.roles.RemoteSecurityRoles;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ResourceControl
extends JPanel
implements ActionListener,
ListSelectionListener,
TreeSelectionListener,
ComponentChangeListener {
    private SecurityControl control = null;
    private RemoteSecurityResources resources = null;
    private RemoteSecurityRoles securityRoles = null;
    String[] comboItems = new String[0];
    JSplitPane splitPane = new JSplitPane();
    JPanel panel = new JPanel(new BorderLayout());
    JScrollPane scrollPane = new JScrollPane();
    JPanel permissionsPanel = new JPanel(new GridBagLayout());
    JPanel accessUsersPanel = new JPanel(new GridBagLayout());
    JPanel accessPanel = new JPanel(new GridBagLayout());
    JScrollPane accessScrollPane = null;
    JScrollPane denyScrollPane = null;
    JPanel groupPanel = new JPanel(new BorderLayout());
    JComboBox permissionsComboBox = new JComboBox<String>(this.comboItems);
    JLabel opLabel = new JLabel("Action :");
    JButton addBtn = new JButton("<<");
    JButton clearBtn = new JButton("Clear");
    JButton removeBtn = new JButton(">>");
    SortedList accessList = new SortedList();
    SortedList deniedList = new SortedList();
    SortedList rolesList = new SortedList();
    private String selectedAction = "ALL";
    private String selectedResource = null;
    private String selectedInstance = null;
    private String selectedRole = null;
    SortedList resourceList = new SortedList();
    JTree instanceTree = new JTree();

    public ResourceControl(SecurityControl control) {
        this.control = control;
        try {
            this.accessPanel.setPreferredSize(new Dimension(120, 10));
            this.accessScrollPane = new JScrollPane(this.accessList);
            this.denyScrollPane = new JScrollPane(this.deniedList);
            this.accessScrollPane.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), " Granted "));
            this.denyScrollPane.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), " Denied "));
            this.accessPanel.add((Component)this.accessScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.4, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.accessPanel.add((Component)this.denyScrollPane, new GridBagConstraints(0, 1, 1, 1, 0.4, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.permissionsPanel.add((Component)this.opLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.permissionsPanel.add((Component)this.permissionsComboBox, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.permissionsPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), " Actions "));
            this.accessUsersPanel.add((Component)this.accessPanel, new GridBagConstraints(0, 0, 1, 2, 0.4, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.accessUsersPanel.add((Component)this.addBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.5, 15, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.accessUsersPanel.add((Component)this.clearBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.accessUsersPanel.add((Component)this.removeBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.accessUsersPanel.add((Component)new JScrollPane(this.rolesList), new GridBagConstraints(2, 0, 1, 2, 0.4, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.groupPanel.add((Component)this.permissionsPanel, "North");
            this.groupPanel.add((Component)this.accessUsersPanel, "Center");
            this.scrollPane.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), " Resources "));
            this.panel.add((Component)this.scrollPane, "West");
            this.scrollPane.getViewport().add(this.resourceList);
            this.resourceList.addListSelectionListener(this);
            this.resourceList.setSelectionMode(0);
            JScrollPane instanceScrollPane = new JScrollPane();
            instanceScrollPane.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), " Instances "));
            instanceScrollPane.getViewport().add(this.instanceTree);
            this.panel.add((Component)instanceScrollPane, "Center");
            this.instanceTree.setCellRenderer(new ResourceTreeRenderer());
            this.instanceTree.getSelectionModel().addTreeSelectionListener(this);
            this.instanceTree.getSelectionModel().setSelectionMode(1);
            this.instanceTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("ALL")));
            this.splitPane.setLeftComponent(this.panel);
            this.splitPane.setRightComponent(this.groupPanel);
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setDividerLocation(0.1);
            this.splitPane.setResizeWeight(0.5);
            this.setLayout(new BorderLayout());
            this.add((Component)this.splitPane, "Center");
            this.permissionsComboBox.addActionListener(this);
            this.addBtn.setEnabled(false);
            this.clearBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
            this.addBtn.addActionListener(this);
            this.clearBtn.addActionListener(this);
            this.removeBtn.addActionListener(this);
            this.accessList.setEnabled(false);
            this.deniedList.setEnabled(false);
            this.rolesList.addListSelectionListener(this);
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to visualize resource panel!", ex);
        }
    }

    public void setFrame(Frame frame) {
    }

    public void actionPerformed(ActionEvent e) {
        try {
            block7: {
                try {
                    if (e.getSource() == this.addBtn) {
                        this.resources.getResourceAccessControlHandle(this.selectedResource).grantSecurityRole(this.selectedRole, this.selectedAction, this.selectedInstance);
                        break block7;
                    }
                    if (e.getSource() == this.removeBtn) {
                        this.resources.getResourceAccessControlHandle(this.selectedResource).denySecurityRole(this.selectedRole, this.selectedAction, this.selectedInstance);
                        break block7;
                    }
                    if (e.getSource() == this.clearBtn) {
                        this.resources.getResourceAccessControlHandle(this.selectedResource).clearSecurityRole(this.selectedRole, this.selectedAction, this.selectedInstance);
                        break block7;
                    }
                    this.comboAction();
                }
                catch (Exception r) {
                    ExceptionHandler.error("Unable to grant or deny security role to resource!", r);
                    Object var4_3 = null;
                    this.repaintAccess();
                }
            }
            Object var4_2 = null;
            this.repaintAccess();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.repaintAccess();
            throw throwable;
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        try {
            TreePath selectedPath = this.instanceTree.getSelectionPath();
            if (selectedPath != null) {
                this.selectedInstance = selectedPath.getLastPathComponent().toString();
                this.repaintAccess();
            }
        }
        catch (Exception exc) {
            ExceptionHandler.debug("Unable to update resource on selection!", exc);
        }
    }

    private void buildTree(RemoteResourceHandle handle, DefaultMutableTreeNode root) throws Exception {
        String[] children = handle.getChildren(root.toString());
        int i = 0;
        while (i < children.length) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(children[i]);
            root.add(node);
            this.buildTree(handle, node);
            ++i;
        }
    }

    private void initTree(String resourceAlias) throws Exception {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ALL");
        if (resourceAlias != null) {
            RemoteResourceHandle resourceHandle = this.resources.getResourceHandle(resourceAlias);
            String[] actions = resourceHandle.getActions();
            this.permissionsComboBox.removeAllItems();
            this.sortComboItems(actions);
            this.permissionsComboBox.removeActionListener(this);
            int i = 0;
            while (i < actions.length) {
                this.permissionsComboBox.addItem(actions[i]);
                ++i;
            }
            this.permissionsComboBox.addActionListener(this);
            this.selectedAction = actions[0];
            this.buildTree(resourceHandle, root);
            this.instanceTree.setSelectionInterval(0, 0);
            this.instanceTree.setEnabled(true);
            this.permissionsComboBox.setEnabled(true);
        } else {
            this.permissionsComboBox.removeAllItems();
            this.instanceTree.setEnabled(false);
            this.permissionsComboBox.setEnabled(true);
        }
        ((DefaultTreeModel)this.instanceTree.getModel()).setRoot(root);
        ((DefaultTreeModel)this.instanceTree.getModel()).reload();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        if (e.getSource() == this.resourceList) {
            try {
                String resourceAlias = (String)this.resourceList.getSelectedValue();
                this.initTree(resourceAlias);
                this.selectedResource = resourceAlias;
                this.repaintAccess();
            }
            catch (Exception exc) {
                ExceptionHandler.debug("Unable to update resource panel on selection!", exc);
            }
        } else {
            this.selectedRole = (String)this.rolesList.getSelectedValue();
            boolean isEnabled = this.selectedResource != null && this.selectedInstance != null && this.selectedAction != null;
            this.addBtn.setEnabled(isEnabled);
            this.clearBtn.setEnabled(isEnabled);
            this.removeBtn.setEnabled(isEnabled);
        }
    }

    public void onComponentChange(String policyConfigurationId) {
        if (policyConfigurationId != null) {
            try {
                RemotePolicyConfiguration policyContext = this.control.getSecurityInterface().getPolicyConfiguration(policyConfigurationId);
                if (policyContext == null) {
                    throw new RuntimeException("Policy configuration with an alias [" + policyConfigurationId + "] not found!");
                }
                this.resources = policyContext.getAuthorization().getResources();
                this.securityRoles = policyContext.getAuthorization().getSecurityRoles();
                String[] resourceNames = this.resources.getResourceAliases();
                this.selectedResource = resourceNames != null && resourceNames.length > 0 ? resourceNames[0] : null;
                this.updateView();
            }
            catch (Throwable re) {
                ExceptionHandler.error("Unable to update resource panel on selection!", re);
            }
        } else {
            throw new RuntimeException("Policy configuration with an NULL alias do not exists!");
        }
    }

    private void updateView() {
        this.accessList.setListData(new String[0], null);
        try {
            Object[] resourceNames = new String[]{};
            SecurityRole[] array = new SecurityRole[]{};
            Object[] roles = new String[]{};
            resourceNames = this.resources.getResourceAliases();
            if (resourceNames.length > 0) {
                this.initTree(resourceNames[0]);
                this.rolesList.setEnabled(true);
                array = this.securityRoles.listSecurityRoles();
                if (array == null) {
                    array = new SecurityRole[]{};
                }
                roles = new String[array.length];
                int i = 0;
                while (i < roles.length) {
                    roles[i] = array[i].getName();
                    ++i;
                }
            } else {
                this.initTree(null);
            }
            this.resourceList.setListData(resourceNames);
            this.rolesList.setListData(roles);
            this.rolesList.repaint();
        }
        catch (Exception ex) {
            ExceptionHandler.error("Unable to update resource panel view!", ex);
            this.rolesList.setEnabled(false);
        }
    }

    private void sortComboItems(String[] items) {
        if (items == null) {
            return;
        }
        Arrays.sort(items);
        int i = 0;
        while (i < items.length) {
            if ("ALL".equalsIgnoreCase(items[i])) {
                String swap = items[0];
                items[0] = items[i];
                items[i] = swap;
                return;
            }
            ++i;
        }
    }

    private void comboAction() throws Exception {
        this.selectedAction = (String)this.permissionsComboBox.getSelectedItem();
        if (this.selectedRole != null) {
            this.addBtn.setEnabled(true);
            this.clearBtn.setEnabled(true);
            this.removeBtn.setEnabled(true);
        }
    }

    private void repaintAccess() {
        try {
            ArrayList<String> directGranted = new ArrayList<String>(10);
            ArrayList<String> directDenied = new ArrayList<String>(10);
            ArrayList granted = new ArrayList(10);
            ArrayList denied = new ArrayList(10);
            String[] roles = null;
            if (this.selectedResource == null) {
                this.initTree(null);
                return;
            }
            if (this.selectedAction != null && this.selectedInstance != null) {
                RemoteResourceAccessControlHandle handle = this.resources.getResourceAccessControlHandle(this.selectedResource);
                roles = handle.listGrantedSecurityRoles(this.selectedAction, this.selectedInstance);
                int i = 0;
                while (i < roles.length) {
                    directGranted.add(roles[i]);
                    ++i;
                }
                roles = handle.listDeniedSecurityRoles(this.selectedAction, this.selectedInstance);
                int i2 = 0;
                while (i2 < roles.length) {
                    directDenied.add(roles[i2]);
                    ++i2;
                }
                this.listInheritedGrantedRoles(this.selectedInstance, directGranted, directDenied, granted, denied);
            }
            this.accessList.setListData(directGranted, granted);
            this.accessList.repaint();
            this.deniedList.setListData(directDenied, denied);
            this.deniedList.repaint();
        }
        catch (Exception e) {
            ExceptionHandler.error("Unable to repaint access list of resource!", e);
        }
    }

    private void listInheritedGrantedRoles(String instance, ArrayList directGranted, ArrayList directDenied, ArrayList granted, ArrayList denied) throws Exception {
        String[] roles = null;
        RemoteResourceAccessControlHandle handle = this.resources.getResourceAccessControlHandle(this.selectedResource);
        roles = handle.listGrantedSecurityRoles(this.selectedAction, instance);
        this.addInherited(roles, granted, directGranted, directDenied, granted, denied);
        roles = handle.listGrantedSecurityRoles("ALL", instance);
        this.addInherited(roles, granted, directGranted, directDenied, granted, denied);
        roles = handle.listDeniedSecurityRoles(this.selectedAction, instance);
        this.addInherited(roles, denied, directGranted, directDenied, granted, denied);
        roles = handle.listDeniedSecurityRoles("ALL", instance);
        this.addInherited(roles, denied, directGranted, directDenied, granted, denied);
        if (!"ALL".equalsIgnoreCase(instance)) {
            String parent = null;
            try {
                parent = this.resources.getResourceHandle(this.selectedResource).getParent(instance);
            }
            catch (Exception e) {
                ExceptionHandler.debug("No parent of resource instance!", e);
                parent = null;
            }
            if (parent != null && !instance.equalsIgnoreCase(parent)) {
                this.listInheritedGrantedRoles(parent, directGranted, directDenied, granted, denied);
            }
        }
    }

    private final void addInherited(String[] names, ArrayList list, ArrayList a, ArrayList b, ArrayList c, ArrayList d) throws Exception {
        int i = 0;
        while (i < names.length) {
            if (!this.existsIn(names[i], a, b, c, d)) {
                list.add(names[i]);
            }
            ++i;
        }
    }

    private final boolean existsIn(String name, ArrayList a, ArrayList b, ArrayList c, ArrayList d) throws Exception {
        return a.indexOf(name) >= 0 || b.indexOf(name) >= 0 || c.indexOf(name) >= 0 || d.indexOf(name) >= 0;
    }
}

